/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.parser;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ParseException;

public class ManifestMetadataParser {
    private Element[] m_elements = new Element[0];

    public Element[] getComponentsMetadata() throws ParseException {
        Element[] elems = this.m_elements[0].getElements();
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < elems.length; ++i) {
            if ("instance".equals(elems[i].getName())) continue;
            list.add(elems[i]);
        }
        return list.toArray(new Element[list.size()]);
    }

    public Dictionary[] getInstances() throws ParseException {
        Element[] configs = this.m_elements[0].getElements("instance");
        if (configs == null) {
            return null;
        }
        Dictionary[] dicts = new Dictionary[configs.length];
        for (int i = 0; i < configs.length; ++i) {
            dicts[i] = this.parseInstance(configs[i]);
        }
        return dicts;
    }

    private Dictionary parseInstance(Element instance) throws ParseException {
        Properties dict = new Properties();
        String name = instance.getAttribute("name");
        String comp = instance.getAttribute("component");
        String version = instance.getAttribute("version");
        if (name != null) {
            ((Dictionary)dict).put("instance.name", instance.getAttribute("name"));
        }
        if (comp == null) {
            throw new ParseException("An instance does not have the 'component' attribute");
        }
        ((Dictionary)dict).put("component", comp);
        if (version != null) {
            ((Dictionary)dict).put("factory.version", version);
        }
        Element[] props = instance.getElements("property");
        for (int i = 0; props != null && i < props.length; ++i) {
            this.parseProperty(props[i], dict);
        }
        return dict;
    }

    private void parseProperty(Element prop, Dictionary dict) throws ParseException {
        String name = prop.getAttribute("name");
        String value = prop.getAttribute("value");
        if (name == null) {
            throw new ParseException("A property does not have the 'name' attribute: " + prop);
        }
        if (value == null) {
            String type = prop.getAttribute("type");
            if (type == null || type.equalsIgnoreCase("dictionary")) {
                dict.put(name, this.parseDictionary(prop));
            } else if (type.equalsIgnoreCase("map")) {
                dict.put(name, this.parseMap(prop));
            } else if (type.equalsIgnoreCase("list")) {
                dict.put(name, this.parseList(prop));
            } else if (type.equalsIgnoreCase("array")) {
                List list = this.parseList(prop);
                boolean isString = true;
                for (int i = 0; isString && i < list.size(); ++i) {
                    isString = list.get(i) instanceof String;
                }
                Object[] obj = null;
                obj = isString ? new String[list.size()] : new Object[list.size()];
                dict.put(name, list.toArray(obj));
            }
        } else {
            dict.put(prop.getAttribute("name"), prop.getAttribute("value"));
        }
    }

    private Dictionary parseDictionary(Element prop) throws ParseException {
        Element[] subProps = prop.getElements("property");
        if (subProps != null) {
            Properties dict2 = new Properties();
            for (int i = 0; i < subProps.length; ++i) {
                this.parseProperty(subProps[i], dict2);
            }
            return dict2;
        }
        return new Properties();
    }

    private Map parseMap(Element prop) throws ParseException {
        Element[] subProps = prop.getElements("property");
        if (subProps != null) {
            HashMap map = new HashMap();
            for (int i = 0; i < subProps.length; ++i) {
                this.parseProperty(subProps[i], map);
            }
            return map;
        }
        return new HashMap(0);
    }

    private List parseList(Element prop) throws ParseException {
        Element[] subProps = prop.getElements("property");
        if (subProps != null) {
            ArrayList list = new ArrayList(subProps.length);
            for (int i = 0; i < subProps.length; ++i) {
                this.parseAnonymousProperty(subProps[i], list);
            }
            return list;
        }
        return new ArrayList(0);
    }

    private void parseProperty(Element prop, Map map) throws ParseException {
        String name = prop.getAttribute("name");
        String value = prop.getAttribute("value");
        if (name == null) {
            throw new ParseException("A property does not have the 'name' attribute");
        }
        if (value == null) {
            String type = prop.getAttribute("type");
            if (type == null || type.equalsIgnoreCase("dictionary")) {
                map.put(name, this.parseDictionary(prop));
            } else if (type.equalsIgnoreCase("map")) {
                map.put(name, this.parseMap(prop));
            } else if (type.equalsIgnoreCase("list")) {
                map.put(name, this.parseList(prop));
            } else if (type.equalsIgnoreCase("array")) {
                List list = this.parseList(prop);
                boolean isString = true;
                for (int i = 0; isString && i < list.size(); ++i) {
                    isString = list.get(i) instanceof String;
                }
                Object[] obj = null;
                obj = isString ? new String[list.size()] : new Object[list.size()];
                map.put(name, list.toArray(obj));
            }
        } else {
            map.put(prop.getAttribute("name"), prop.getAttribute("value"));
        }
    }

    private void parseAnonymousProperty(Element prop, List list) throws ParseException {
        String name = prop.getAttribute("name");
        String value = prop.getAttribute("value");
        if (name != null) {
            throw new ParseException("Anonymous property expected in a list or an array");
        }
        if (value == null) {
            String type = prop.getAttribute("type");
            if (type == null || type.equalsIgnoreCase("dictionary")) {
                Element[] subProps = prop.getElements("property");
                if (subProps != null) {
                    Properties dict2 = new Properties();
                    for (int i = 0; i < subProps.length; ++i) {
                        this.parseProperty(subProps[i], dict2);
                    }
                    list.add(dict2);
                } else {
                    list.add(new Properties());
                }
            } else if (type.equalsIgnoreCase("map")) {
                Element[] subProps = prop.getElements("property");
                if (subProps != null) {
                    HashMap map2 = new HashMap();
                    for (int i = 0; i < subProps.length; ++i) {
                        this.parseProperty(subProps[i], map2);
                    }
                    list.add(map2);
                } else {
                    list.add(new HashMap(0));
                }
            } else if (type.equalsIgnoreCase("list")) {
                Element[] subProps = prop.getElements("property");
                if (subProps != null) {
                    ArrayList list2 = new ArrayList(subProps.length);
                    for (int i = 0; i < subProps.length; ++i) {
                        this.parseAnonymousProperty(subProps[i], list2);
                    }
                    list.add(list2);
                } else {
                    list.add(new ArrayList(0));
                }
            } else if (type.equalsIgnoreCase("array")) {
                Element[] subProps = prop.getElements("property");
                if (subProps != null) {
                    ArrayList list2 = new ArrayList(subProps.length);
                    for (int i = 0; i < subProps.length; ++i) {
                        this.parseAnonymousProperty(subProps[i], list2);
                    }
                    list.add(list.toArray(new Object[list.size()]));
                } else {
                    list.add(new Element[0]);
                }
            }
        } else {
            list.add(prop.getAttribute("value"));
        }
    }

    private void addElement(Element elem) {
        if (this.m_elements == null) {
            this.m_elements = new Element[]{elem};
        } else {
            Element[] newElementsList = new Element[this.m_elements.length + 1];
            System.arraycopy(this.m_elements, 0, newElementsList, 0, this.m_elements.length);
            newElementsList[this.m_elements.length] = elem;
            this.m_elements = newElementsList;
        }
    }

    private Element removeLastElement() {
        int idx = -1;
        idx = this.m_elements.length - 1;
        Element last = this.m_elements[idx];
        if (idx >= 0) {
            if (this.m_elements.length - 1 == 0) {
                this.m_elements = new Element[0];
            } else {
                Element[] newElementsList = new Element[this.m_elements.length - 1];
                System.arraycopy(this.m_elements, 0, newElementsList, 0, idx);
                this.m_elements = newElementsList;
            }
        }
        return last;
    }

    public void parse(Dictionary dict) throws ParseException {
        String componentClassesStr = (String)dict.get("iPOJO-Components");
        this.addElement(new Element("iPOJO", ""));
        this.parseElements(componentClassesStr.trim());
    }

    public void parseHeader(String header) throws ParseException {
        this.addElement(new Element("iPOJO", ""));
        this.parseElements(header.trim());
    }

    public static Element parse(String metadata) throws ParseException {
        ManifestMetadataParser parser = new ManifestMetadataParser();
        parser.parseElements(metadata);
        if (parser.m_elements.length != 1) {
            throw new ParseException("Error in parsing, root element not found : " + metadata);
        }
        return parser.m_elements[0];
    }

    public static Element parseHeaderMetadata(String header) throws ParseException {
        ManifestMetadataParser parser = new ManifestMetadataParser();
        parser.addElement(new Element("iPOJO", ""));
        parser.parseElements(header);
        if (parser.m_elements.length != 1) {
            throw new ParseException("Error in parsing, root element not found : " + header);
        }
        return parser.m_elements[0];
    }

    private void parseElements(String elems) {
        char[] string = elems.toCharArray();
        block5: for (int i = 0; i < string.length; ++i) {
            char current = string[i];
            switch (current) {
                case '$': {
                    StringBuffer attName = new StringBuffer();
                    StringBuffer attValue = new StringBuffer();
                    StringBuffer attNs = null;
                    current = string[++i];
                    while (current != '=') {
                        if (current == ':') {
                            attNs = attName;
                            attName = new StringBuffer();
                        } else {
                            attName.append(current);
                        }
                        current = string[++i];
                    }
                    current = string[i += 2];
                    while (current != '\"') {
                        attValue.append(current);
                        current = string[++i];
                    }
                    current = string[++i];
                    Attribute att = null;
                    att = attNs == null ? new Attribute(attName.toString(), attValue.toString()) : new Attribute(attName.toString(), attNs.toString(), attValue.toString());
                    this.m_elements[this.m_elements.length - 1].addAttribute(att);
                    continue block5;
                }
                case '}': {
                    Element lastElement = this.removeLastElement();
                    if (this.m_elements.length == 0) {
                        this.addElement(lastElement);
                        continue block5;
                    }
                    Element newQueue = this.m_elements[this.m_elements.length - 1];
                    newQueue.addElement(lastElement);
                    continue block5;
                }
                case ' ': {
                    continue block5;
                }
                default: {
                    StringBuffer qname = new StringBuffer();
                    current = string[i];
                    while (current != ' ') {
                        qname.append(current);
                        current = string[++i];
                    }
                    while (string[i] == ' ') {
                        ++i;
                    }
                    ++i;
                    Element elem = null;
                    String n = qname.toString();
                    if (n.indexOf(58) == -1) {
                        elem = new Element(n, null);
                    } else {
                        int last = n.lastIndexOf(58);
                        String ns = n.substring(0, last);
                        String name = n.substring(last + 1);
                        elem = new Element(name.toString(), ns.toString());
                    }
                    this.addElement(elem);
                }
            }
        }
    }
}

