/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.irmi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.ObjID;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.carol.irmi.ClientInterceptor;
import org.ow2.carol.irmi.Constants;
import org.ow2.carol.irmi.ObjectInputList;
import org.ow2.carol.irmi.ObjectOutputList;
import org.ow2.carol.irmi.Pair;
import org.ow2.carol.irmi.Server;

public class Ref
implements RemoteRef,
Constants {
    private static Map COUNTS = new HashMap();
    private String host;
    private int port;
    private ObjID oid;
    private ClientInterceptor clint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Collection getKeys() {
        Map map = COUNTS;
        synchronized (map) {
            return new ArrayList(COUNTS.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map getCounts(String host, int port) {
        Map map = COUNTS;
        synchronized (map) {
            Key key = new Key(host, port);
            HashMap result = (HashMap)COUNTS.get(key);
            if (result == null) {
                result = new HashMap();
                COUNTS.put(key, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Count getCount(String host, int port, ObjID oid) {
        Map counts;
        Map map = counts = Ref.getCounts(host, port);
        synchronized (map) {
            Count count = (Count)counts.get(oid);
            if (count == null) {
                count = new Count(0);
                counts.put(oid, count);
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int incr(String host, int port, ObjID oid, int amount) {
        Count count;
        Count count2 = count = Ref.getCount(host, port, oid);
        synchronized (count2) {
            count.count += amount;
            return count.count;
        }
    }

    private static final int incr(String host, int port, ObjID oid) {
        return Ref.incr(host, port, oid, 1);
    }

    private static final int decr(String host, int port, ObjID oid) {
        return Ref.incr(host, port, oid, -1);
    }

    public Ref() {
    }

    public Ref(String host, int port, ObjID oid, ClientInterceptor clint) {
        this.host = host;
        this.port = port;
        this.oid = oid;
        this.clint = clint;
        Ref.incr(host, port, oid);
    }

    public ObjID getOID() {
        return this.oid;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    ClientInterceptor getInterceptor() {
        return this.clint;
    }

    public void connect(Ref ref) {
        this.host = ref.host;
        this.port = ref.port;
        this.oid = ref.oid;
        this.clint = ref.clint;
    }

    private void throwAny(Object o) throws Exception {
        if (o instanceof Exception) {
            throw (Exception)o;
        }
        if (o instanceof Error) {
            throw (Error)o;
        }
        throw new RuntimeException("" + o);
    }

    public Object invoke(Remote rem, Method meth, Object[] args, long hash) throws Exception {
        return this.invoke(meth, -1, hash, args);
    }

    private Object invoke(Method meth, int opnum, long hash, Object[] args) throws Exception {
        Server.Result result = Server.invoke(this, meth, opnum, hash, args);
        switch (result.code) {
            case 1: {
                return result.value;
            }
            case 2: {
                if (result.value instanceof RemoteException) {
                    throw new ServerException("RemoteException thrown during remote method invocation", (Exception)result.value);
                }
                this.throwAny(result.value);
                break;
            }
            case 3: {
                this.throwAny(result.value);
            }
        }
        throw new IllegalStateException("unreachable");
    }

    public RemoteCall newCall(RemoteObject obj, Operation[] ops, int opnum, long hash) {
        return new Call(opnum, hash);
    }

    public void invoke(RemoteCall call) throws Exception {
        call.executeCall();
    }

    public void done(RemoteCall call) {
        try {
            call.done();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public String getRefClass(ObjectOutput out) {
        return null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.host);
        out.writeInt(this.port);
        this.oid.write(out);
        out.writeObject(this.clint);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.host = in.readUTF();
        this.port = in.readInt();
        this.oid = ObjID.read(in);
        this.clint = (ClientInterceptor)in.readObject();
        Ref.incr(this.host, this.port, this.oid);
    }

    public void finalize() {
        Ref.decr(this.host, this.port, this.oid);
    }

    public boolean remoteEquals(RemoteRef obj) {
        Ref ref = (Ref)obj;
        return this.host.equals(ref.host) && this.port == ref.port && this.oid.equals(ref.oid);
    }

    public int remoteHashCode() {
        int hash = 1;
        hash = hash * 31 + this.host.hashCode();
        hash = hash * 31 + this.port;
        hash = hash * 31 + this.oid.hashCode();
        return hash;
    }

    public String remoteToString() {
        return "<remote reference for " + this.host + ":" + this.port + ":" + this.oid + ">";
    }

    static {
        new Pinger(300000L).start();
    }

    private static class Pinger
    extends Thread {
        private long interval;

        private Pinger(long interval) {
            this.interval = interval;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: while (true) {
                try {
                    Pinger.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    break;
                }
                Collection keys = Ref.getKeys();
                Iterator it = keys.iterator();
                while (true) {
                    if (!it.hasNext()) continue block7;
                    Key key = (Key)it.next();
                    Map counts = Ref.getCounts(key.getHost(), key.getPort());
                    ArrayList<ObjID> oids = new ArrayList<ObjID>(counts.size());
                    Map map = counts;
                    synchronized (map) {
                        Set entries = counts.entrySet();
                        Iterator iter = entries.iterator();
                        while (iter.hasNext()) {
                            Map.Entry me = iter.next();
                            ObjID oid = (ObjID)me.getKey();
                            Count count = (Count)me.getValue();
                            if (count.count <= 0) {
                                iter.remove();
                                continue;
                            }
                            oids.add(oid);
                        }
                    }
                    try {
                        Server.ping(key.getHost(), key.getPort(), oids);
                    }
                    catch (IOException e) {
                        System.err.println("ERROR WHILE PINGING SERVER");
                        e.printStackTrace(System.err);
                    }
                }
                break;
            }
        }
    }

    private class Call
    implements RemoteCall {
        private int opnum;
        private long hash;
        private List args;
        private ObjectOutput out;
        private List result;
        private ObjectInput in;

        public Call(int opnum, long hash) {
            this.opnum = opnum;
            this.hash = hash;
            this.args = new ArrayList();
            this.out = new ObjectOutputList(this.args);
            this.result = new ArrayList();
            this.in = new ObjectInputList(this.result);
        }

        public void executeCall() throws Exception {
            this.result.add(Ref.this.invoke(null, this.opnum, this.hash, this.args.toArray()));
        }

        public void done() {
        }

        public ObjectOutput getOutputStream() {
            return this.out;
        }

        public void releaseOutputStream() {
        }

        public ObjectInput getInputStream() {
            return this.in;
        }

        public void releaseInputStream() {
        }

        public ObjectOutput getResultStream(boolean success) {
            throw new UnsupportedOperationException();
        }
    }

    private static class Count {
        private int count;

        private Count(int initial) {
            this.count = initial;
        }
    }

    private static class Key
    extends Pair {
        public Key(String host, int port) {
            super((Object)host, port);
        }

        public String getHost() {
            return (String)this.getOne();
        }

        public int getPort() {
            return (Integer)this.getTwo();
        }
    }
}

