/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.loader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import org.ow2.easybeans.api.loader.EZBClassLoader;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansClassLoader
extends URLClassLoader
implements EZBClassLoader {
    private static final int BUF_APPEND = 1000;
    private static Log logger = LogFactory.getLog(EasyBeansClassLoader.class);
    private boolean recomputeToString = true;
    private String toStringValue = null;
    private boolean alwaysTransform = false;
    private Map<String, byte[]> mapDefined = new HashMap<String, byte[]>();
    private List<ClassTransformer> classTransformers = null;

    public EasyBeansClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public EasyBeansClassLoader(URL[] urls) {
        super(urls);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.searchingDefinedClass(name);
        if (clazz != null) {
            return clazz;
        }
        return super.findClass(name);
    }

    /*
     * Unable to fully structure code
     */
    private Class<?> defineInternalClass(String className, byte[] bytecode) {
        block14: {
            if (EasyBeansClassLoader.logger.isDebugEnabled()) {
                fName = System.getProperty("java.io.tmpdir") + File.separator + className + ".class";
                fos = null;
                try {
                    fos = new FileOutputStream(fName);
                    fos.write(bytecode);
                    var7_6 = null;
                    ** if (fos == null) goto lbl-1000
                }
                catch (Throwable var6_11) {
                    var7_7 = null;
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            EasyBeansClassLoader.logger.debug((Object)"Cannot close stream for ''{0}''.", new Object[]{fName});
                        }
                    }
                    throw var6_11;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        EasyBeansClassLoader.logger.debug((Object)"Cannot close stream for ''{0}''.", new Object[]{fName});
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block14;
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
        }
        this.checkAndDefinePackage(className);
        try {
            return this.defineClass(className, bytecode, 0, bytecode.length);
        }
        catch (Error e) {
            if (e != null && e.getMessage().contains("duplicate class definition")) {
                EasyBeansClassLoader.logger.debug((Object)"Cannot invoke the defineClass method on the classloader", new Object[]{e});
            } else {
                EasyBeansClassLoader.logger.error((Object)"Cannot invoke the defineClass method on the classloader", new Object[]{e});
            }
            return null;
        }
    }

    public void addClassDefinition(String className, byte[] bytecode) {
        if (this.mapDefined.get(className) != null) {
            logger.debug((Object)("There is already a bytecode defined for the class named '" + className + "'. Not replacing. This could be due to a duplicated class in the given package."), new Object[0]);
        }
        this.mapDefined.put(className, bytecode);
    }

    /*
     * Loose catch block
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        byte[] bytes;
        String resourceName;
        block15: {
            this.searchingDefinedClass(name);
            if (this.classTransformers == null) {
                return super.loadClass(name, false);
            }
            if (this.findLoadedClass(name) != null) {
                return super.loadClass(name, false);
            }
            StringBuilder sb = new StringBuilder(name.replace(".", "/"));
            sb.append(".class");
            resourceName = sb.toString();
            URL resourceURL = this.findResource(resourceName);
            if (resourceURL == null) {
                return super.loadClass(name, false);
            }
            InputStream inputStream = this.getResourceAsStream(resourceName);
            if (inputStream == null) {
                throw new ClassNotFoundException("The resource '" + resourceName + "' was not found");
            }
            bytes = null;
            bytes = EasyBeansClassLoader.readClass(inputStream);
            Object var9_7 = null;
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)"Cannot close the stream", new Object[]{e});
            }
            break block15;
            {
                catch (IOException e) {
                    throw new ClassNotFoundException("Cannot read the class ''.", e);
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Cannot close the stream", new Object[]{e});
                }
                throw throwable;
            }
        }
        boolean transformed = false;
        for (ClassTransformer classTransformer : this.classTransformers) {
            try {
                byte[] updatedBytes = classTransformer.transform((ClassLoader)this, name.replace(".", "/"), null, null, bytes);
                if (updatedBytes == null) continue;
                bytes = updatedBytes;
                transformed = true;
            }
            catch (IllegalClassFormatException e) {
                throw new ClassNotFoundException("Cannot transform the resource '" + resourceName + "'", e);
            }
        }
        if (this.alwaysTransform || transformed) {
            return this.defineInternalClass(name, bytes);
        }
        return super.loadClass(name, false);
    }

    protected void checkAndDefinePackage(String className) {
        String packageName;
        Package pkg;
        int i = className.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(packageName = className.substring(0, i))) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
    }

    private Class<?> searchingDefinedClass(String className) {
        Class<?> clazz;
        byte[] defined;
        if (this.mapDefined != null && (defined = this.mapDefined.get(className)) != null && (clazz = this.defineInternalClass(className, defined)) != null) {
            this.mapDefined.remove(className);
            return clazz;
        }
        return null;
    }

    public String toString() {
        if (this.recomputeToString) {
            this.computeToString();
        }
        return this.toStringValue;
    }

    private void computeToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[");
        sb.append("urls=");
        URL[] urls = this.getURLs();
        for (int u = 0; u < urls.length; ++u) {
            sb.append(urls[u]);
            if (u == urls.length - 1) continue;
            sb.append(";");
        }
        sb.append("]");
        this.toStringValue = sb.toString();
        this.recomputeToString = false;
    }

    public ClassLoader duplicate() {
        PrivilegedAction<EasyBeansClassLoader> privilegedAction = new PrivilegedAction<EasyBeansClassLoader>(){

            @Override
            public EasyBeansClassLoader run() {
                return new EasyBeansClassLoader(EasyBeansClassLoader.this.getURLs(), EasyBeansClassLoader.this.getParent());
            }
        };
        return AccessController.doPrivileged(privilegedAction);
    }

    public void addTransformer(ClassTransformer transformer) {
        if (this.classTransformers == null) {
            this.classTransformers = new ArrayList<ClassTransformer>();
        }
        this.classTransformers.add(transformer);
    }

    protected void setAlwaysTransform(boolean alwaysTransform) {
        this.alwaysTransform = alwaysTransform;
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Given input stream is null");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }
}

