/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator.wsdl11;

import java.util.Collection;
import java.util.HashSet;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.model.JavaClass;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.BeanGenerator;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.model.WrapperBeanClass;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.RequestWrapper;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.ResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WrapperBeanGenerator
extends BeanGenerator {
    @Override
    protected Collection<JavaClass> generateBeanClasses(ServiceInfo serviceInfo) {
        HashSet<JavaClass> wrapperClasses = new HashSet<JavaClass>();
        for (OperationInfo op : serviceInfo.getInterface().getOperations()) {
            WrapperBeanClass jClass;
            if (op.getUnwrappedOperation() == null) continue;
            if (op.hasInput()) {
                RequestWrapper requestWrapper = new RequestWrapper();
                requestWrapper.setOperationInfo(op);
                jClass = requestWrapper.buildWrapperBeanClass();
                if (requestWrapper.isWrapperBeanClassNotExist()) {
                    wrapperClasses.add(jClass);
                }
            }
            if (!op.hasOutput()) continue;
            ResponseWrapper responseWrapper = new ResponseWrapper();
            responseWrapper.setOperationInfo(op);
            jClass = responseWrapper.buildWrapperBeanClass();
            if (!responseWrapper.isWrapperBeanClassNotExist()) continue;
            wrapperClasses.add(jClass);
        }
        return wrapperClasses;
    }
}

