/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.eval.api.BinaryEvaluatedTC;
import org.objectweb.medor.eval.api.NodeEvaluator;
import org.objectweb.medor.eval.lib.BasicBinaryEvalutedTC;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.lib.Log;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.medor.tuple.lib.MemoryTuple;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class BinaryImplicitTC
extends BasicBinaryEvalutedTC
implements BinaryEvaluatedTC {
    static Logger log = null;
    boolean debug;
    private ParameterOperand[] parameters;
    private QueryNode query;
    private Expression filter;
    private TupleCollection leftTCResult;
    private TupleCollection rightTCResult;
    private Tuple tupleBuffer1;
    private Tuple tupleBuffer2;
    private Tuple concatResult;
    private VariableOperand[] operandBuffer1;
    private VariableOperand[] operandBuffer2;
    private VariableOperand[] attConcatBuffers;
    private int cursor;
    private int leftTCSize;
    private int rightTCSize;
    private boolean empty;
    private boolean isBuffer2Free = false;
    private boolean isTheLast = false;
    private Operand filterResult;

    public BinaryImplicitTC(QueryNode query, NodeEvaluator leftNodeEvaluator, NodeEvaluator rightNodeEvaluator, ParameterOperand[] parameters) throws MedorException {
        int cpt;
        if (log == null) {
            log = Log.loggerFactory.getLogger("org.objectweb.medor.eval.lib.BinaryImplicitTC");
        }
        this.debug = log.isLoggable(BasicLevel.DEBUG);
        this.closed = false;
        this.parameters = parameters;
        this.query = query;
        this.filter = query.getQueryFilter();
        try {
            this.filterResult = this.filter.compileExpression();
        }
        catch (ExpressionException e) {
            throw new MedorException(e);
        }
        this.leftTCResult = leftNodeEvaluator.fetchData(parameters);
        this.rightTCResult = rightNodeEvaluator.fetchData(parameters);
        this.leftTCSize = this.leftTCResult.getMetaData().getSize();
        this.rightTCSize = this.rightTCResult.getMetaData().getSize();
        this.operandBuffer1 = new VariableOperand[query.getTupleStructure().getSize()];
        this.operandBuffer2 = new VariableOperand[query.getTupleStructure().getSize()];
        for (cpt = 0; cpt < query.getTupleStructure().getSize(); ++cpt) {
            this.operandBuffer1[cpt] = new BasicVariableOperand(query.getTupleStructure().getField(cpt + 1).getType());
            this.operandBuffer2[cpt] = new BasicVariableOperand(query.getTupleStructure().getField(cpt + 1).getType());
        }
        this.tupleBuffer1 = new MemoryTuple(this.operandBuffer1);
        this.tupleBuffer2 = new MemoryTuple(this.operandBuffer2);
        this.attConcatBuffers = new VariableOperand[this.leftTCSize + this.rightTCSize];
        for (cpt = 0; cpt < this.leftTCSize; ++cpt) {
            this.attConcatBuffers[cpt] = new BasicVariableOperand(this.leftTCResult.getMetaData().getField(cpt + 1).getType());
        }
        for (cpt = this.leftTCSize; cpt < this.leftTCSize + this.rightTCSize; ++cpt) {
            this.attConcatBuffers[cpt] = new BasicVariableOperand(this.rightTCResult.getMetaData().getField(cpt + 1 - this.leftTCSize).getType());
        }
        this.concatResult = new MemoryTuple(this.attConcatBuffers);
        boolean bl = this.empty = this.leftTCResult.isEmpty() || this.rightTCResult.isEmpty();
        if (this.empty) {
            this.cursor = 0;
        } else {
            try {
                this.init();
            }
            catch (ExpressionException e) {
                throw new MedorException(e);
            }
        }
    }

    public TupleStructure getMetaData() throws MedorException {
        return this.query.getTupleStructure();
    }

    public boolean isLast() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.isTheLast;
    }

    public void close() throws MedorException {
        this.closed = true;
        if (this.leftTCResult != null) {
            this.leftTCResult.close();
        }
        if (this.rightTCResult != null) {
            this.rightTCResult.close();
        }
    }

    public int card() throws MedorException {
        return this.cursor;
    }

    public synchronized boolean next() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        boolean isMoved = false;
        if (this.isEmpty() || this.cursor == -2) {
            isMoved = false;
        } else if (this.isLast()) {
            this.cursor = -2;
            isMoved = false;
        } else {
            try {
                isMoved = true;
                ++this.cursor;
                do {
                    int i;
                    Tuple rightTuple;
                    Tuple leftTuple;
                    if (this.rightTCResult.next()) {
                        leftTuple = this.leftTCResult.getTuple();
                        rightTuple = this.rightTCResult.getTuple();
                        if (this.debug) {
                            log.log(BasicLevel.DEBUG, (Object)"Case rightTCResult");
                            log.log(BasicLevel.DEBUG, (Object)"Left tuple:");
                            for (i = 1; i < this.leftTCResult.getMetaData().getSize(); ++i) {
                                log.log(BasicLevel.DEBUG, (Object)(this.leftTCResult.getMetaData().getField(i).getName() + "(" + this.leftTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.leftTCResult.getTuple().getObject(i)));
                            }
                            log.log(BasicLevel.DEBUG, (Object)"Right tuple:");
                            for (i = 1; i < this.rightTCResult.getMetaData().getSize(); ++i) {
                                log.log(BasicLevel.DEBUG, (Object)(this.rightTCResult.getMetaData().getField(i).getName() + "(" + this.rightTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.rightTCResult.getTuple().getObject(i)));
                            }
                        }
                        this.concatTuple(leftTuple, rightTuple);
                        this.filter.evaluate(this.parameters, this.concatResult);
                        if (!this.debug) continue;
                        log.log(BasicLevel.DEBUG, (Object)("Filter result:" + this.filterResult.getBoolean()));
                        continue;
                    }
                    if (this.leftTCResult.next()) {
                        this.rightTCResult.first();
                        rightTuple = this.rightTCResult.getTuple();
                        leftTuple = this.leftTCResult.getTuple();
                        if (this.debug) {
                            log.log(BasicLevel.DEBUG, (Object)"Case leftTCResult");
                            log.log(BasicLevel.DEBUG, (Object)"Left tuple:");
                            for (i = 1; i < this.leftTCResult.getMetaData().getSize(); ++i) {
                                log.log(BasicLevel.DEBUG, (Object)(this.leftTCResult.getMetaData().getField(i).getName() + "(" + this.leftTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.leftTCResult.getTuple().getObject(i)));
                            }
                            log.log(BasicLevel.DEBUG, (Object)"Right tuple:");
                            for (i = 1; i < this.rightTCResult.getMetaData().getSize(); ++i) {
                                log.log(BasicLevel.DEBUG, (Object)(this.rightTCResult.getMetaData().getField(i).getName() + "(" + this.rightTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.rightTCResult.getTuple().getObject(i)));
                            }
                        }
                        this.concatTuple(leftTuple, rightTuple);
                        this.filter.evaluate(this.parameters, this.concatResult);
                        if (!this.debug) continue;
                        log.log(BasicLevel.DEBUG, (Object)("Filter result:" + this.filterResult.getBoolean()));
                        continue;
                    }
                    this.isTheLast = true;
                } while (!this.isTheLast && !this.filterResult.getBoolean());
                if (!this.isTheLast) {
                    if (this.isBuffer2Free) {
                        this.query.getTupleLoader().loadTuple(this.concatResult, this.operandBuffer2, this.parameters);
                        this.isBuffer2Free = false;
                    } else {
                        this.query.getTupleLoader().loadTuple(this.concatResult, this.operandBuffer1, this.parameters);
                        this.isBuffer2Free = true;
                    }
                } else {
                    this.isBuffer2Free = !this.isBuffer2Free;
                }
            }
            catch (ExpressionException e) {
                throw new MedorException(e);
            }
        }
        return isMoved;
    }

    private boolean init() throws MedorException, ExpressionException {
        int i;
        if (this.debug) {
            log.log(BasicLevel.DEBUG, (Object)"Entering init");
        }
        this.leftTCResult.first();
        this.rightTCResult.first();
        this.isTheLast = false;
        Tuple leftTuple = this.leftTCResult.getTuple();
        Tuple rightTuple = this.rightTCResult.getTuple();
        if (this.debug) {
            log.log(BasicLevel.DEBUG, (Object)"Case init");
            log.log(BasicLevel.DEBUG, (Object)"Left tuple:");
            for (i = 1; i < this.leftTCResult.getMetaData().getSize(); ++i) {
                log.log(BasicLevel.DEBUG, (Object)(this.leftTCResult.getMetaData().getField(i).getName() + "(" + this.leftTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.leftTCResult.getTuple().getObject(i)));
            }
            log.log(BasicLevel.DEBUG, (Object)"Right tuple:");
            for (i = 1; i < this.rightTCResult.getMetaData().getSize(); ++i) {
                log.log(BasicLevel.DEBUG, (Object)(this.rightTCResult.getMetaData().getField(i).getName() + "(" + this.rightTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.rightTCResult.getTuple().getObject(i)));
            }
        }
        this.concatTuple(leftTuple, rightTuple);
        this.filter.evaluate(this.parameters, this.concatResult);
        if (this.debug) {
            log.log(BasicLevel.DEBUG, (Object)("Filter result:" + this.filterResult.getBoolean()));
        }
        while (!this.empty && !this.filterResult.getBoolean()) {
            if (this.rightTCResult.next()) {
                rightTuple = this.rightTCResult.getTuple();
                if (this.debug) {
                    log.log(BasicLevel.DEBUG, (Object)"Case init + rightTCResult");
                    log.log(BasicLevel.DEBUG, (Object)"Left tuple:");
                    for (i = 1; i < this.leftTCResult.getMetaData().getSize(); ++i) {
                        log.log(BasicLevel.DEBUG, (Object)(this.leftTCResult.getMetaData().getField(i).getName() + "(" + this.leftTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.leftTCResult.getTuple().getObject(i)));
                    }
                    log.log(BasicLevel.DEBUG, (Object)"Right tuple:");
                    for (i = 1; i < this.rightTCResult.getMetaData().getSize(); ++i) {
                        log.log(BasicLevel.DEBUG, (Object)(this.rightTCResult.getMetaData().getField(i).getName() + "(" + this.rightTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.rightTCResult.getTuple().getObject(i)));
                    }
                }
                this.concatTuple(leftTuple, rightTuple);
                this.filter.evaluate(this.parameters, this.concatResult);
                if (!this.debug) continue;
                log.log(BasicLevel.DEBUG, (Object)("Filter result:" + this.filterResult.getBoolean()));
                continue;
            }
            if (this.leftTCResult.next()) {
                this.rightTCResult.first();
                rightTuple = this.rightTCResult.getTuple();
                leftTuple = this.leftTCResult.getTuple();
                if (this.debug) {
                    log.log(BasicLevel.DEBUG, (Object)"Case init + leftTCResult");
                    log.log(BasicLevel.DEBUG, (Object)"Left tuple:");
                    for (i = 1; i < this.leftTCResult.getMetaData().getSize(); ++i) {
                        log.log(BasicLevel.DEBUG, (Object)(this.leftTCResult.getMetaData().getField(i).getName() + "(" + this.leftTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.leftTCResult.getTuple().getObject(i)));
                    }
                    log.log(BasicLevel.DEBUG, (Object)"Right tuple:");
                    for (i = 1; i < this.rightTCResult.getMetaData().getSize(); ++i) {
                        log.log(BasicLevel.DEBUG, (Object)(this.rightTCResult.getMetaData().getField(i).getName() + "(" + this.rightTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.rightTCResult.getTuple().getObject(i)));
                    }
                }
                this.concatTuple(leftTuple, rightTuple);
                this.filter.evaluate(this.parameters, this.concatResult);
                if (!this.debug) continue;
                log.log(BasicLevel.DEBUG, (Object)("Filter result:" + this.filterResult.getBoolean()));
                continue;
            }
            this.empty = true;
        }
        if (this.empty) {
            this.cursor = 0;
        } else {
            this.query.getTupleLoader().loadTuple(this.concatResult, this.operandBuffer1, this.parameters);
            this.cursor = 1;
            do {
                if (this.rightTCResult.next()) {
                    rightTuple = this.rightTCResult.getTuple();
                    if (this.debug) {
                        log.log(BasicLevel.DEBUG, (Object)"Case init + loading first result from right");
                        log.log(BasicLevel.DEBUG, (Object)"Left tuple:");
                        for (i = 1; i < this.leftTCResult.getMetaData().getSize(); ++i) {
                            log.log(BasicLevel.DEBUG, (Object)(this.leftTCResult.getMetaData().getField(i).getName() + "(" + this.leftTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.leftTCResult.getTuple().getObject(i)));
                        }
                        log.log(BasicLevel.DEBUG, (Object)"Right tuple:");
                        for (i = 1; i < this.rightTCResult.getMetaData().getSize(); ++i) {
                            log.log(BasicLevel.DEBUG, (Object)(this.rightTCResult.getMetaData().getField(i).getName() + "(" + this.rightTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.rightTCResult.getTuple().getObject(i)));
                        }
                    }
                    this.concatTuple(leftTuple, rightTuple);
                    this.filter.evaluate(this.parameters, this.concatResult);
                    if (!this.debug) continue;
                    log.log(BasicLevel.DEBUG, (Object)("Filter result:" + this.filterResult.getBoolean()));
                    continue;
                }
                if (this.leftTCResult.next()) {
                    this.rightTCResult.first();
                    rightTuple = this.rightTCResult.getTuple();
                    leftTuple = this.leftTCResult.getTuple();
                    if (this.debug) {
                        log.log(BasicLevel.DEBUG, (Object)"Case init + loading first result from left");
                        log.log(BasicLevel.DEBUG, (Object)"Left tuple:");
                        for (i = 1; i < this.leftTCResult.getMetaData().getSize(); ++i) {
                            log.log(BasicLevel.DEBUG, (Object)(this.leftTCResult.getMetaData().getField(i).getName() + "(" + this.leftTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.leftTCResult.getTuple().getObject(i)));
                        }
                        log.log(BasicLevel.DEBUG, (Object)"Right tuple:");
                        for (i = 1; i < this.rightTCResult.getMetaData().getSize(); ++i) {
                            log.log(BasicLevel.DEBUG, (Object)(this.rightTCResult.getMetaData().getField(i).getName() + "(" + this.rightTCResult.getMetaData().getField(i).getType().getJavaName() + ")" + " = " + this.rightTCResult.getTuple().getObject(i)));
                        }
                    }
                    this.concatTuple(leftTuple, rightTuple);
                    this.filter.evaluate(this.parameters, this.concatResult);
                    if (!this.debug) continue;
                    log.log(BasicLevel.DEBUG, (Object)("Filter result:" + this.filterResult.getBoolean()));
                    continue;
                }
                this.isTheLast = true;
            } while (!this.isTheLast && !this.filterResult.getBoolean());
            if (!this.isTheLast) {
                this.query.getTupleLoader().loadTuple(this.concatResult, this.operandBuffer2, this.parameters);
            }
        }
        return !this.empty;
    }

    public synchronized void first() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        try {
            this.init();
        }
        catch (ExpressionException e) {
            e.printStackTrace();
        }
    }

    public synchronized int getRow() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.cursor;
    }

    public synchronized Tuple getTuple() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (!this.isEmpty() && this.getRow() >= 1) {
            if (this.isBuffer2Free) {
                return this.tupleBuffer2;
            }
            return this.tupleBuffer1;
        }
        throw new MedorException(" No elements fetched in this TupleCollection " + this.getRow());
    }

    public synchronized boolean isEmpty() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.empty;
    }

    public synchronized boolean row(int numTuple) throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (this.cursor > numTuple || this.cursor < 0) {
            this.first();
        }
        boolean stop = false;
        while (this.cursor < numTuple && !stop) {
            if (this.next()) continue;
            stop = true;
        }
        return this.cursor == numTuple;
    }

    public synchronized Tuple getTuple(int numTuple) throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.row(numTuple);
        return this.getTuple();
    }

    public synchronized int getLeftTCCursor() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.leftTCResult.getRow();
    }

    public synchronized int getRightTCCursor() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.rightTCResult.getRow();
    }

    private void concatTuple(Tuple t1, Tuple t2) throws MedorException {
        int cpt;
        for (cpt = 0; cpt < this.leftTCSize; ++cpt) {
            this.attConcatBuffers[cpt] = (VariableOperand)t1.getLikeOperand(cpt + 1);
        }
        for (cpt = 0; cpt < this.rightTCSize; ++cpt) {
            this.attConcatBuffers[cpt + this.leftTCSize] = (VariableOperand)t2.getLikeOperand(cpt + 1);
        }
    }
}

