/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.internal.resizer.impl.stocker;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.statistics.StockerStatistics;
import org.ow2.util.pool.impl.enhanced.internal.resizer.impl.AbstractResizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinMaxExpectedSpareStockerResizer<S extends StockerStatistics>
extends AbstractResizer<S> {
    private static final Log LOG = LogFactory.getLog(MinMaxExpectedSpareStockerResizer.class);
    public static final int NO_MAX_POOL_LIMIT = -1;
    private boolean noRegression;
    private int expectedSize;
    private int minPool;
    private int maxPool;
    private int expectedSparePool;
    private Object mutex;

    public MinMaxExpectedSpareStockerResizer(int minPool, int maxPool, boolean noRegression) {
        this(minPool, maxPool, 1, noRegression);
    }

    public MinMaxExpectedSpareStockerResizer(int minPool, int maxPool, int expectedSparePool, boolean noRegression) {
        if (minPool < 0 || expectedSparePool < 1) {
            throw new IllegalArgumentException();
        }
        if (maxPool != -1 && (minPool > maxPool || maxPool < 0)) {
            throw new IllegalArgumentException();
        }
        this.minPool = minPool;
        this.maxPool = maxPool;
        this.expectedSparePool = expectedSparePool;
        this.noRegression = noRegression;
        this.mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareUpdate(S stockedCount) {
        int usedPoolItem = stockedCount.getStockedCount();
        Object object = this.mutex;
        synchronized (object) {
            LOG.debug((Object)"prepare an update {0}, conf min {1} max {2} spare {3}", new Object[]{usedPoolItem, this.minPool, this.maxPool, this.expectedSparePool});
            int expectedTotal = usedPoolItem + this.expectedSparePool;
            if (this.noRegression && expectedTotal < this.expectedSize) {
                expectedTotal = this.expectedSize;
            }
            this.expectedSize = expectedTotal < this.minPool ? this.minPool : (this.maxPool != -1 && expectedTotal > this.maxPool ? this.maxPool : expectedTotal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        int expectedSize;
        Object object = this.mutex;
        synchronized (object) {
            expectedSize = this.expectedSize;
            if (expectedSize < this.minPool) {
                expectedSize = this.minPool;
            } else if (this.maxPool != -1 && expectedSize > this.maxPool) {
                expectedSize = this.maxPool;
            }
        }
        LOG.debug((Object)"call change size to {0} by {1}", new Object[]{expectedSize, Thread.currentThread()});
        this.updateWith(expectedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpectedSparePool(int expectedSparePool) {
        if (this.maxPool != -1 && expectedSparePool < 1) {
            throw new IllegalArgumentException();
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.expectedSparePool != expectedSparePool) {
                this.expectedSparePool = expectedSparePool;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPool(int maxPool) {
        if (maxPool != -1) {
            if (maxPool < 0) {
                throw new IllegalArgumentException();
            }
            Object object = this.mutex;
            synchronized (object) {
                if (this.minPool > maxPool) {
                    this.minPool = maxPool;
                }
                this.maxPool = maxPool;
            }
        }
        Object object = this.mutex;
        synchronized (object) {
            this.maxPool = maxPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinPool(int minPool) {
        if (minPool < 0) {
            throw new IllegalArgumentException();
        }
        Object object = this.mutex;
        synchronized (object) {
            if (minPool > this.maxPool) {
                this.maxPool = minPool;
            }
            this.minPool = minPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinPool() {
        Object object = this.mutex;
        synchronized (object) {
            return this.minPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxPool() {
        Object object = this.mutex;
        synchronized (object) {
            return this.maxPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExpectedSparePool() {
        Object object = this.mutex;
        synchronized (object) {
            return this.expectedSparePool;
        }
    }
}

