/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.extension.loader;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.ow2.jonas.extension.loader.Bnd;
import org.ow2.jonas.extension.loader.Bundlizable;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

public class ExtensionLoaderComponent
implements Pojo {
    private InstanceManager __IM;
    private static final Log logger = LogFactory.getLog(ExtensionLoaderComponent.class);
    private boolean __Fcontext;
    private BundleContext context;
    private boolean __FserverProps;
    private ServerProperties serverProps;
    private boolean __Fbundles;
    private List<Bundle> bundles;
    private boolean __Fbundlizables;
    private Map<String, Bundlizable> bundlizables;
    private boolean __FpackageAdmin;
    private PackageAdmin packageAdmin;
    private boolean __Mstart;
    private boolean __Muninstall$java_io_File;
    private boolean __MapplyBndWrap$java_io_File$java_io_File;
    private boolean __Mstop;
    private boolean __MsetPackageAdmin$org_osgi_service_packageadmin_PackageAdmin;
    private boolean __MsetServerProperties$org_ow2_jonas_properties_ServerProperties;

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    ServerProperties __getserverProps() {
        if (!this.__FserverProps) {
            return this.serverProps;
        }
        return (ServerProperties)this.__IM.onGet((Object)this, "serverProps");
    }

    void __setserverProps(ServerProperties serverProperties) {
        if (!this.__FserverProps) {
            this.serverProps = serverProperties;
            return;
        }
        this.__IM.onSet((Object)this, "serverProps", (Object)serverProperties);
    }

    List __getbundles() {
        if (!this.__Fbundles) {
            return this.bundles;
        }
        return (List)this.__IM.onGet((Object)this, "bundles");
    }

    void __setbundles(List list) {
        if (!this.__Fbundles) {
            this.bundles = list;
            return;
        }
        this.__IM.onSet((Object)this, "bundles", (Object)list);
    }

    Map __getbundlizables() {
        if (!this.__Fbundlizables) {
            return this.bundlizables;
        }
        return (Map)this.__IM.onGet((Object)this, "bundlizables");
    }

    void __setbundlizables(Map map) {
        if (!this.__Fbundlizables) {
            this.bundlizables = map;
            return;
        }
        this.__IM.onSet((Object)this, "bundlizables", (Object)map);
    }

    PackageAdmin __getpackageAdmin() {
        if (!this.__FpackageAdmin) {
            return this.packageAdmin;
        }
        return (PackageAdmin)this.__IM.onGet((Object)this, "packageAdmin");
    }

    void __setpackageAdmin(PackageAdmin packageAdmin) {
        if (!this.__FpackageAdmin) {
            this.packageAdmin = packageAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "packageAdmin", (Object)packageAdmin);
    }

    public ExtensionLoaderComponent(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ExtensionLoaderComponent(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__setcontext(context);
        this.__setbundles(new ArrayList());
        this.__setbundlizables(new HashMap());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
        boolean resolved;
        Bundlizable bnd;
        String name;
        this.__getbundles().clear();
        this.__getbundlizables().clear();
        File jonasRoot = new File(System.getProperty("jonas.root"));
        File jonasBase = new File(System.getProperty("jonas.base"));
        File rootLibExt = new File(new File(jonasRoot, "lib"), "ext");
        File baseLibExt = new File(new File(jonasBase, "lib"), "ext");
        File bundleWork = new File(this.__getserverProps().getWorkDirectory(), "ext-bundles");
        if (!bundleWork.exists()) {
            bundleWork.mkdirs();
        }
        FileFilter selectJar = new FileFilter(){

            public boolean accept(File child) {
                return child.getName().endsWith(".jar") && child.isFile();
            }
        };
        if (rootLibExt.isDirectory()) {
            for (File child : rootLibExt.listFiles(selectJar)) {
                name = child.getName();
                bnd = (Bundlizable)this.__getbundlizables().get(name);
                if (bnd != null) continue;
                bnd = new Bundlizable();
                bnd.setSource(child);
                this.__getbundlizables().put(child.getName(), bnd);
            }
        }
        if (baseLibExt.isDirectory() && !rootLibExt.equals(baseLibExt)) {
            for (File child : baseLibExt.listFiles(selectJar)) {
                name = child.getName();
                bnd = (Bundlizable)this.__getbundlizables().get(name);
                if (bnd != null) continue;
                bnd = new Bundlizable();
                bnd.setSource(child);
                this.__getbundlizables().put(child.getName(), bnd);
            }
        }
        for (File child : bundleWork.listFiles(selectJar)) {
            name = child.getName();
            bnd = (Bundlizable)this.__getbundlizables().get(name);
            if (bnd != null) continue;
            bnd = new Bundlizable();
            bnd.setTarget(child);
            this.__getbundlizables().put(child.getName(), bnd);
        }
        Iterator i = this.__getbundlizables().entrySet().iterator();
        while (i.hasNext()) {
            File target;
            Map.Entry entry = i.next();
            Bundlizable bnd2 = (Bundlizable)entry.getValue();
            if (bnd2.isSourceSuppressed()) {
                target = bnd2.getTarget();
                this.uninstall(target);
                target.delete();
                i.remove();
                continue;
            }
            if (bnd2.isFirstUsage()) {
                target = new File(bundleWork, bnd2.getSource().getName());
                bnd2.setTarget(target);
                this.applyBndWrap(bnd2.getSource(), target);
                continue;
            }
            if (!bnd2.isTargetOutdated()) continue;
            bnd2.getTarget().delete();
            this.applyBndWrap(bnd2.getSource(), bnd2.getTarget());
        }
        if (this.__getbundlizables().size() != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Some jars have been found in [");
            sb.append(rootLibExt);
            if (!rootLibExt.equals(baseLibExt)) {
                sb.append(", ");
                sb.append(baseLibExt);
            }
            sb.append("].");
            sb.append(" They have been transformed into bundles (see ");
            sb.append(bundleWork);
            sb.append(" directory).");
            sb.append("This is NOT the preferred way to extend JOnAS libraries, ");
            sb.append("prefer to use carefully created and tested bundles, ");
            sb.append("and place them in your deploy/ directory.");
            logger.info((Object)sb.toString(), new Object[0]);
        }
        for (Map.Entry entry : this.__getbundlizables().entrySet()) {
            Bundlizable bnd3 = (Bundlizable)entry.getValue();
            String url = URLUtils.fileToURL((File)bnd3.getTarget()).toExternalForm();
            try {
                Bundle installed = this.__getcontext().installBundle(url);
                logger.info((Object)"{0} installed as a bundle.", new Object[]{url});
                this.__getbundles().add(installed);
            }
            catch (BundleException e) {
                logger.warn((Object)"Unable to install '{0}': {1}", new Object[]{url, e.getMessage()});
            }
        }
        Bundle[] resolvables = this.__getbundles().toArray(new Bundle[this.__getbundles().size()]);
        if (resolvables != null && !(resolved = this.__getpackageAdmin().resolveBundles(resolvables))) {
            logger.debug((Object)"Some lib/ext bundles could not be resolved", new Object[0]);
        }
    }

    protected void uninstall(File file) {
        if (!this.__Muninstall$java_io_File) {
            this.__uninstall(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "uninstall$java_io_File", new Object[]{file});
            this.__uninstall(file);
            this.__IM.onExit((Object)this, "uninstall$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "uninstall$java_io_File", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void __uninstall(File target) {
        if (target == null || !target.exists()) {
            return;
        }
        symbolicName = null;
        jar = null;
        try {
            jar = new JarFile(target);
            symbolicName = jar.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
            ** if (jar == null) goto lbl-1000
        }
        catch (IOException e) {
            block19: {
                try {
                    ExtensionLoaderComponent.logger.error((Object)"Unable to find symbolic name from the bundle ''{0}''", new Object[]{target});
                    if (jar == null) break block19;
                }
                catch (Throwable var6_9) {
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (IOException e) {
                            ExtensionLoaderComponent.logger.debug((Object)"Unable to close the bundle file ''{0}''", new Object[]{target});
                        }
                    }
                    throw var6_9;
                }
                try {
                    jar.close();
                }
                catch (IOException e) {
                    ExtensionLoaderComponent.logger.debug((Object)"Unable to close the bundle file ''{0}''", new Object[]{target});
                }
            }
            return;
        }
lbl-1000:
        // 1 sources

        {
            try {
                jar.close();
            }
            catch (IOException e) {
                ExtensionLoaderComponent.logger.debug((Object)"Unable to close the bundle file ''{0}''", new Object[]{target});
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (symbolicName == null) {
            ExtensionLoaderComponent.logger.error((Object)"Unable to find symbolic name from the bundle ''{0}''", new Object[]{target});
            return;
        }
        bundleFound = false;
        bundles = this.__getcontext().getBundles();
        bundle = null;
        if (bundles != null) {
            for (i = 0; !bundleFound && i < bundles.length; ++i) {
                bundle = bundles[i];
                if (!symbolicName.equals(bundle.getSymbolicName())) continue;
                bundleFound = true;
                break;
            }
        }
        if (bundleFound) {
            try {
                ExtensionLoaderComponent.logger.info((Object)"Uninstalling the bundle ''{0}'' as the origin file has been removed from lib/ext", new Object[]{target});
                bundle.uninstall();
            }
            catch (BundleException e) {
                ExtensionLoaderComponent.logger.warn((Object)"Unable to uninstall ''{0}''", new Object[]{target, e});
            }
        }
    }

    private void applyBndWrap(File file, File file2) {
        if (!this.__MapplyBndWrap$java_io_File$java_io_File) {
            this.__applyBndWrap(file, file2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "applyBndWrap$java_io_File$java_io_File", new Object[]{file, file2});
            this.__applyBndWrap(file, file2);
            this.__IM.onExit((Object)this, "applyBndWrap$java_io_File$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "applyBndWrap$java_io_File$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __applyBndWrap(File source, File output) {
        List<String> messages;
        Bnd myBnd = new Bnd();
        boolean errors = false;
        try {
            errors = myBnd.wrap(source, output);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to bundlize '{0}'", new Object[]{source, e});
        }
        if (errors && logger.isDebugEnabled() && (messages = myBnd.getErrors()) != null) {
            for (String message : messages) {
                logger.debug((Object)"[Bnd] {0}: {1}", new Object[]{source.getName(), message});
            }
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
        for (Bundle bundle : this.__getbundles()) {
            try {
                bundle.uninstall();
            }
            catch (BundleException e) {
                logger.debug((Object)"Unable to uninstall bundle '{0}[{1}]': {2}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId(), e.getMessage()});
            }
        }
    }

    public void setPackageAdmin(PackageAdmin packageAdmin) {
        if (!this.__MsetPackageAdmin$org_osgi_service_packageadmin_PackageAdmin) {
            this.__setPackageAdmin(packageAdmin);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setPackageAdmin$org_osgi_service_packageadmin_PackageAdmin", new Object[]{packageAdmin});
            this.__setPackageAdmin(packageAdmin);
            this.__IM.onExit((Object)this, "setPackageAdmin$org_osgi_service_packageadmin_PackageAdmin", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setPackageAdmin$org_osgi_service_packageadmin_PackageAdmin", throwable);
            throw throwable;
        }
    }

    private void __setPackageAdmin(PackageAdmin packageAdmin) {
        this.__setpackageAdmin(packageAdmin);
    }

    public void setServerProperties(ServerProperties serverProperties) {
        if (!this.__MsetServerProperties$org_ow2_jonas_properties_ServerProperties) {
            this.__setServerProperties(serverProperties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", new Object[]{serverProperties});
            this.__setServerProperties(serverProperties);
            this.__IM.onExit((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", throwable);
            throw throwable;
        }
    }

    private void __setServerProperties(ServerProperties props) {
        this.__setserverProps(props);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("serverProps")) {
                this.__FserverProps = true;
            }
            if (set.contains("bundles")) {
                this.__Fbundles = true;
            }
            if (set.contains("packageAdmin")) {
                this.__FpackageAdmin = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("bundlizables")) {
                this.__Fbundlizables = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("uninstall$java_io_File")) {
                this.__Muninstall$java_io_File = true;
            }
            if (set.contains("applyBndWrap$java_io_File$java_io_File")) {
                this.__MapplyBndWrap$java_io_File$java_io_File = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("setPackageAdmin$org_osgi_service_packageadmin_PackageAdmin")) {
                this.__MsetPackageAdmin$org_osgi_service_packageadmin_PackageAdmin = true;
            }
            if (set.contains("setServerProperties$org_ow2_jonas_properties_ServerProperties")) {
                this.__MsetServerProperties$org_ow2_jonas_properties_ServerProperties = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

