/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ejbjar.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.ApplicationException;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.impl.deployable.metadata.DeployableMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJInterceptors;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarClassMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarDeployableMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarFieldMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarMethodMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJCommonBean;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IEJB3;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JApplicationException;
import org.ow2.util.ee.metadata.ws.api.xml.struct.IWebservices;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.marshalling.Serialization;
import org.ow2.util.marshalling.SerializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbJarDeployableMetadata<E extends EJBDeployable<E>, D extends IEjbJarDeployableMetadata<E, D, C, M, F>, C extends IEjbJarClassMetadata<E, D, C, M, F>, M extends IEjbJarMethodMetadata<E, D, C, M, F>, F extends IEjbJarFieldMetadata<E, D, C, M, F>>
extends DeployableMetadata<E>
implements IEjbJarDeployableMetadata<E, D, C, M, F> {
    private static final long serialVersionUID = 2467337105092579966L;
    private static Log logger = LogFactory.getLog(EjbJarDeployableMetadata.class);
    private Map<String, C> classesAnnotationMetadata = new HashMap<String, C>();
    private Map<String, Map<String, C>> beanClassesAnnotationMetadata = new HashMap<String, Map<String, C>>();
    private IEJB3 ejb3 = null;
    private IWebservices webservices = null;
    private Map<String, ApplicationException> applicationExceptions = null;
    private IJInterceptors defaultInterceptorsClasses = null;

    public EjbJarDeployableMetadata() {
    }

    public EjbJarDeployableMetadata(E deployable) {
        this();
        this.setDeployable((IDeployable)deployable);
    }

    public void addScannedClassMetadata(C classAnnotationMetadata) {
        String key = classAnnotationMetadata.getClassName();
        if (this.classesAnnotationMetadata.containsKey(key)) {
            String msg = logger.getI18n().getMessage("EjbJarAnnotationMetadata.addClassAnnotationMetadata.alreadyPresent", new Object[]{key});
            logger.debug((Object)msg, new Object[0]);
            throw new IllegalStateException(msg);
        }
        this.classesAnnotationMetadata.put(key, classAnnotationMetadata);
    }

    public C getEjbJarClassMetadataForEjbName(String ejbName) {
        Map<String, C> beanMapClassMetadata = this.beanClassesAnnotationMetadata.get(ejbName);
        if (beanMapClassMetadata == null) {
            return null;
        }
        for (IEjbJarClassMetadata metadata : beanMapClassMetadata.values()) {
            IJCommonBean bean = metadata.getJCommonBean();
            if (bean == null || !ejbName.equals(bean.getName())) continue;
            return (C)metadata;
        }
        return null;
    }

    public C getBeanEjbJarClassMetadataForEjbName(String ejbName, String ejbClass) {
        Object classMetadata;
        logger.debug((Object)"Call with ''{0}'' and ejbClass ''{1}''", new Object[]{ejbName, ejbClass});
        Map<String, C> beanMapClassMetadata = this.beanClassesAnnotationMetadata.get(ejbName);
        if (beanMapClassMetadata == null) {
            beanMapClassMetadata = new HashMap<String, C>();
            this.beanClassesAnnotationMetadata.put(ejbName, beanMapClassMetadata);
            logger.debug((Object)"Creating a Map for EJB ''{0}''", new Object[]{ejbName});
        }
        String ejbClassEncoded = null;
        if (ejbClass == null) {
            for (IEjbJarClassMetadata tmpMetaData : this.getEjbJarClassMetadataCollection()) {
                IJCommonBean bean = tmpMetaData.getJCommonBean();
                if (bean == null || ejbName == null || !ejbName.equals(bean.getName())) continue;
                ejbClassEncoded = tmpMetaData.getClassName();
                break;
            }
        } else {
            ejbClassEncoded = EjbJarDeployableMetadata.encode(ejbClass);
        }
        if ((classMetadata = (IEjbJarClassMetadata)beanMapClassMetadata.get(ejbClassEncoded)) != null) {
            return (C)classMetadata;
        }
        classMetadata = this.getScannedClassMetadata(ejbClassEncoded);
        if (classMetadata == null) {
            throw new IllegalStateException("No metadata defined for the EJB class '" + ejbClass + "'");
        }
        IEjbJarClassMetadata clonedClassMetadata = null;
        try {
            clonedClassMetadata = (IEjbJarClassMetadata)Serialization.cloneObject((Serializable)classMetadata);
        }
        catch (SerializationException e) {
            throw new IllegalStateException("Cannot clone classmetada for '" + ejbClass + "'", e);
        }
        clonedClassMetadata.setLinkedBean(ejbName);
        logger.debug((Object)"Cloning scanning classmetadata ''{0}''", new Object[]{ejbClassEncoded});
        beanMapClassMetadata.put(ejbClassEncoded, clonedClassMetadata);
        clonedClassMetadata.setEjbJarArchiveMetadata((IEjbJarDeployableMetadata)this);
        return (C)clonedClassMetadata;
    }

    protected static String encode(String className) {
        if (className != null) {
            return className.replace(".", "/");
        }
        return null;
    }

    public C getScannedClassMetadata(String className) {
        return (C)((IEjbJarClassMetadata)this.classesAnnotationMetadata.get(className));
    }

    public Collection<C> getEjbJarClassMetadataCollection() {
        return this.classesAnnotationMetadata.values();
    }

    public IEJB3 getEjb3() {
        return this.ejb3;
    }

    public void setEjb3(IEJB3 ejb3) {
        this.ejb3 = ejb3;
    }

    public IWebservices getWebservices12() {
        return this.webservices;
    }

    public void setWebservices12(IWebservices webservices12) {
        this.webservices = webservices12;
    }

    public Map<String, ApplicationException> getApplicationExceptions() {
        if (this.applicationExceptions != null) {
            return this.applicationExceptions;
        }
        this.applicationExceptions = new HashMap<String, ApplicationException>();
        for (IEjbJarClassMetadata classMetadata : this.getEjbJarClassMetadataCollection()) {
            ApplicationException appException = classMetadata.getApplicationException();
            if (appException == null) continue;
            this.applicationExceptions.put(classMetadata.getClassName().replaceAll("/", "."), appException);
            logger.debug((Object)"Adding application exception ''{}''", new Object[]{classMetadata.getClassName().replaceAll("/", ".")});
        }
        this.applicationExceptions.put("DEFAULT", (ApplicationException)new JApplicationException());
        return this.applicationExceptions;
    }

    public IJInterceptors getDefaultInterceptorsClasses() {
        return this.defaultInterceptorsClasses;
    }

    public void setDefaultInterceptorsClasses(IJInterceptors defaultInterceptorsClasses) {
        this.defaultInterceptorsClasses = defaultInterceptorsClasses;
    }

    public List<String> getBeanNames() {
        return Arrays.asList(this.beanClassesAnnotationMetadata.keySet().toArray(new String[0]));
    }

    public Collection<C> getClassesForBean(String beanName) {
        Map<String, C> beanClasses = this.beanClassesAnnotationMetadata.get(beanName);
        if (beanClasses == null) {
            return Collections.EMPTY_LIST;
        }
        return beanClasses.values();
    }

    public C getClassForBean(String beanName, String className) {
        return (C)((IEjbJarClassMetadata)this.beanClassesAnnotationMetadata.get(beanName).get(className));
    }

    public List<String> getClassesnameForBean(String beanName) {
        return Arrays.asList(this.beanClassesAnnotationMetadata.get(beanName).keySet().toArray(new String[0]));
    }
}

