/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.mail.internal;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JModule;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.PropDump;
import org.ow2.jonas.mail.MailService;
import org.ow2.jonas.mail.MailServiceException;
import org.ow2.jonas.mail.factory.JavaMail;
import org.ow2.jonas.mail.internal.factory.AbstractJavaMail;
import org.ow2.jonas.mail.internal.factory.JavaMailMimePartDS;
import org.ow2.jonas.mail.internal.factory.JavaMailSession;
import org.ow2.jonas.mail.internal.factory.mbean.JavaMailMimePartDSResource;
import org.ow2.jonas.mail.internal.factory.mbean.JavaMailSessionResource;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASMailService
extends AbsServiceImpl
implements MailService,
Pojo {
    private InstanceManager __IM;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.mail");
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __Fictx;
    private Context ictx;
    private boolean __FregistryService;
    private RegistryService registryService;
    private boolean __FfactoryNames;
    private List<String> factoryNames;
    private boolean __FjMailSessionFactories;
    private Map<String, JavaMailSession> jMailSessionFactories;
    private boolean __FjMailMimePartDSFactories;
    private Map<String, JavaMailMimePartDS> jMailMimePartDSFactories;
    private boolean __FboundFactories;
    private Map<String, String> boundFactories;
    private static final int JAVAX_MAIL_SESSION_FACTORY = 1;
    private static final int JAVAX_MAIL_INTERNET_MIMEPARTDATASOURCE = 2;
    public static final String FACTORIES = "jonas.service.mail.factories";
    public static final String CLASS = "jonas.service.mail.class";
    private boolean __MsetFactories$java_lang_String;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __MrecreateJavaMailFactory$org_ow2_jonas_mail_factory_JavaMail;
    private boolean __MrenameJavaMailFactory$java_lang_String$org_ow2_jonas_mail_factory_JavaMail;
    private boolean __McreateMailFactory$java_lang_String$java_util_Properties;
    private boolean __McreateMailFactoryMBean$java_lang_String$java_util_Properties$java_lang_Boolean;
    private boolean __MunbindMailFactories;
    private boolean __MunbindMailFactoryMBean$java_lang_String;
    private boolean __MgetFactoryName$java_lang_String;
    private boolean __MgetCurrentNumberOfMailFactories;
    private boolean __MgetCurrentNumberOfSessionMailFactories;
    private boolean __MgetCurrentNumberOfMimeMailFactories;
    private boolean __MgetMailFactoryPropertiesFile$java_lang_String;
    private boolean __MgetMailFactoryPropertiesFiles;
    private boolean __MgetMimePartMailFactoryPropertiesFiles;
    private boolean __MgetSessionMailFactoryPropertiesFiles;
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MsetRegistryService$org_ow2_jonas_registry_RegistryService;
    private boolean __MgetRegistryService;

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    Context __getictx() {
        if (!this.__Fictx) {
            return this.ictx;
        }
        return (Context)this.__IM.onGet((Object)this, "ictx");
    }

    void __setictx(Context context) {
        if (!this.__Fictx) {
            this.ictx = context;
            return;
        }
        this.__IM.onSet((Object)this, "ictx", (Object)context);
    }

    RegistryService __getregistryService() {
        if (!this.__FregistryService) {
            return this.registryService;
        }
        return (RegistryService)this.__IM.onGet((Object)this, "registryService");
    }

    void __setregistryService(RegistryService registryService) {
        if (!this.__FregistryService) {
            this.registryService = registryService;
            return;
        }
        this.__IM.onSet((Object)this, "registryService", (Object)registryService);
    }

    List __getfactoryNames() {
        if (!this.__FfactoryNames) {
            return this.factoryNames;
        }
        return (List)this.__IM.onGet((Object)this, "factoryNames");
    }

    void __setfactoryNames(List list) {
        if (!this.__FfactoryNames) {
            this.factoryNames = list;
            return;
        }
        this.__IM.onSet((Object)this, "factoryNames", (Object)list);
    }

    Map __getjMailSessionFactories() {
        if (!this.__FjMailSessionFactories) {
            return this.jMailSessionFactories;
        }
        return (Map)this.__IM.onGet((Object)this, "jMailSessionFactories");
    }

    void __setjMailSessionFactories(Map map) {
        if (!this.__FjMailSessionFactories) {
            this.jMailSessionFactories = map;
            return;
        }
        this.__IM.onSet((Object)this, "jMailSessionFactories", (Object)map);
    }

    Map __getjMailMimePartDSFactories() {
        if (!this.__FjMailMimePartDSFactories) {
            return this.jMailMimePartDSFactories;
        }
        return (Map)this.__IM.onGet((Object)this, "jMailMimePartDSFactories");
    }

    void __setjMailMimePartDSFactories(Map map) {
        if (!this.__FjMailMimePartDSFactories) {
            this.jMailMimePartDSFactories = map;
            return;
        }
        this.__IM.onSet((Object)this, "jMailMimePartDSFactories", (Object)map);
    }

    Map __getboundFactories() {
        if (!this.__FboundFactories) {
            return this.boundFactories;
        }
        return (Map)this.__IM.onGet((Object)this, "boundFactories");
    }

    void __setboundFactories(Map map) {
        if (!this.__FboundFactories) {
            this.boundFactories = map;
            return;
        }
        this.__IM.onSet((Object)this, "boundFactories", (Object)map);
    }

    public JOnASMailService() {
        this(null);
    }

    private JOnASMailService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setjmxService(null);
        this.__setictx(null);
        this.__setfactoryNames(new Vector());
        this.__setjMailSessionFactories(new Hashtable());
        this.__setjMailMimePartDSFactories(new Hashtable());
        this.__setboundFactories(new Hashtable());
    }

    public void setFactories(String string) {
        if (!this.__MsetFactories$java_lang_String) {
            this.__setFactories(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setFactories$java_lang_String", new Object[]{string});
            this.__setFactories(string);
            this.__IM.onExit((Object)this, "setFactories$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setFactories$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setFactories(String factories) {
        this.__setfactoryNames(JOnASMailService.convertToList((String)factories));
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() throws ServiceException {
        IExecution<InitialContext> ictxGetter = new IExecution<InitialContext>(){

            public InitialContext execute() throws Exception {
                return JOnASMailService.this.getRegistryService().getRegistryContext();
            }
        };
        ExecutionResult ictxResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)ictxGetter);
        if (ictxResult.hasException()) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot create initial context when Mail service initializing");
            throw new ServiceException("Cannot create initial context when Mail service initializing", (Throwable)ictxResult.getException());
        }
        this.__setictx((Context)ictxResult.getResult());
        this.__getjmxService().loadDescriptors(((Object)((Object)this)).getClass().getPackage().getName(), ((Object)((Object)this)).getClass().getClassLoader());
        String factoryName = null;
        for (int i = 0; i < this.__getfactoryNames().size(); ++i) {
            factoryName = (String)this.__getfactoryNames().get(i);
            try {
                JProp prop = JProp.getInstance((String)factoryName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Creating mail factory " + factoryName));
                }
                this.createMailFactory(factoryName, prop.getConfigFileEnv());
                continue;
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                logger.log(BasicLevel.ERROR, (Object)("JOnAS: Cannot create mail factory " + factoryName + " : " + e));
                logger.log(BasicLevel.ERROR, (Object)("Please check the " + factoryName + ".properties file"));
            }
        }
        try {
            this.__getjmxService().registerModelMBean((Object)this, JonasObjectName.mailService((String)this.getDomainName()));
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Cannot register 'mail' service MBean", (Throwable)e);
        }
        logger.log(BasicLevel.INFO, (Object)"Mail Service started");
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() throws ServiceException {
        try {
            this.unbindMailFactories();
        }
        catch (MailServiceException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot unbind mail factories " + (Object)((Object)e)));
            throw new ServiceException("Cannot unbind mail factories ", (Throwable)e);
        }
        if (this.__getjmxService() != null) {
            this.__getjmxService().unregisterModelMBean(JonasObjectName.mailService((String)this.getDomainName()));
        }
        logger.log(BasicLevel.INFO, (Object)"mail service stopped");
    }

    public void recreateJavaMailFactory(JavaMail javaMail) throws MailServiceException {
        if (!this.__MrecreateJavaMailFactory$org_ow2_jonas_mail_factory_JavaMail) {
            this.__recreateJavaMailFactory(javaMail);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "recreateJavaMailFactory$org_ow2_jonas_mail_factory_JavaMail", new Object[]{javaMail});
            this.__recreateJavaMailFactory(javaMail);
            this.__IM.onExit((Object)this, "recreateJavaMailFactory$org_ow2_jonas_mail_factory_JavaMail", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "recreateJavaMailFactory$org_ow2_jonas_mail_factory_JavaMail", throwable);
            throw throwable;
        }
    }

    private void __recreateJavaMailFactory(JavaMail factory) throws MailServiceException {
        String jndiName = factory.getName();
        try {
            this.__getictx().rebind(jndiName, (Object)factory);
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot bind mail factory '" + jndiName + "'  :" + e.getMessage()));
            throw new MailServiceException("Cannot bind mail factory " + jndiName + ".", (Throwable)e);
        }
    }

    public void renameJavaMailFactory(String string, JavaMail javaMail) throws MailServiceException {
        if (!this.__MrenameJavaMailFactory$java_lang_String$org_ow2_jonas_mail_factory_JavaMail) {
            this.__renameJavaMailFactory(string, javaMail);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "renameJavaMailFactory$java_lang_String$org_ow2_jonas_mail_factory_JavaMail", new Object[]{string, javaMail});
            this.__renameJavaMailFactory(string, javaMail);
            this.__IM.onExit((Object)this, "renameJavaMailFactory$java_lang_String$org_ow2_jonas_mail_factory_JavaMail", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "renameJavaMailFactory$java_lang_String$org_ow2_jonas_mail_factory_JavaMail", throwable);
            throw throwable;
        }
    }

    private void __renameJavaMailFactory(String oldName, JavaMail factory) throws MailServiceException {
        block7: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("In renameMailFactory, old name = " + oldName));
            }
            try {
                this.__getictx().unbind(oldName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(oldName + " unbound"));
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block7;
                logger.log(BasicLevel.DEBUG, (Object)("Warning: cannot unbind mail factory object named " + oldName));
            }
        }
        String jndiName = factory.getName();
        try {
            this.__getictx().rebind(jndiName, (Object)factory);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("factory rebound under the name " + jndiName));
            }
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot bind mail factory '" + jndiName + "'  :" + e.getMessage()));
            throw new MailServiceException("Cannot bind mail factory " + jndiName + ".", (Throwable)e);
        }
        this.__getboundFactories().put(jndiName, factory.getFactoryName());
        this.__getboundFactories().remove(oldName);
    }

    public void createMailFactory(String string, Properties properties) throws MailServiceException {
        if (!this.__McreateMailFactory$java_lang_String$java_util_Properties) {
            this.__createMailFactory(string, properties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createMailFactory$java_lang_String$java_util_Properties", new Object[]{string, properties});
            this.__createMailFactory(string, properties);
            this.__IM.onExit((Object)this, "createMailFactory$java_lang_String$java_util_Properties", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createMailFactory$java_lang_String$java_util_Properties", throwable);
            throw throwable;
        }
    }

    private void __createMailFactory(String factoryName, Properties props) throws MailServiceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            PropDump.print((String)"These are the properties from which the MailService picks to construct Mail Factories", (Properties)props, (Logger)logger, (int)BasicLevel.DEBUG);
        }
        AbstractJavaMail factory = null;
        String factoryType = props.getProperty("mail.factory.type");
        String jndiName = props.getProperty("mail.factory.name");
        if (jndiName == null) {
            logger.log(BasicLevel.ERROR, (Object)"The property 'mail.factory.name' is a required property.");
            throw new MailServiceException("The property 'mail.factory.name' is a required property for this factory.");
        }
        if (factoryType == null) {
            logger.log(BasicLevel.ERROR, (Object)"The property 'mail.factory.type' is a required property.");
            throw new MailServiceException("The property 'mail.factory.type' is a required property for this factory.");
        }
        if (this.__getboundFactories().containsKey(jndiName)) {
            logger.log(BasicLevel.ERROR, (Object)("There is already a factory bound with the name " + jndiName));
            throw new MailServiceException("There is already a factory bound with the name '" + jndiName + "', please correct the provided configuration properties");
        }
        int typeOfFactory = factoryType.equalsIgnoreCase("javax.mail.Session") ? 1 : (factoryType.equalsIgnoreCase("javax.mail.internet.MimePartDataSource") ? 2 : 0);
        switch (typeOfFactory) {
            case 1: {
                JavaMailSession sessionFactory = new JavaMailSession(factoryName, jndiName, props, this);
                this.__getjMailSessionFactories().put(factoryName, sessionFactory);
                factory = sessionFactory;
                break;
            }
            case 2: {
                JavaMailMimePartDS mimeFactory = new JavaMailMimePartDS(factoryName, jndiName, props, this);
                this.__getjMailMimePartDSFactories().put(factoryName, mimeFactory);
                factory = mimeFactory;
                break;
            }
            default: {
                throw new MailServiceException("Can not create a factory of the type '" + factoryType + "'. This type is incorrect.");
            }
        }
        try {
            this.__getictx().rebind(jndiName, (Object)factory);
            this.__getboundFactories().put(jndiName, factoryName);
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot bind mail factory '" + jndiName + "'  :" + e.getMessage()));
            throw new MailServiceException("Cannot bind mail factory " + jndiName + ".", (Throwable)e);
        }
        logger.log(BasicLevel.INFO, (Object)("Mapping Mail Factory " + factoryType + " on " + jndiName));
        try {
            ObjectName on = null;
            switch (typeOfFactory) {
                case 1: {
                    on = J2eeObjectName.JavaMailResource((String)this.getDomainName(), (String)factoryName, (String)this.getJonasServerName(), (String)"javax.mail.Session");
                    JavaMailSessionResource javaMailSessionResource = null;
                    javaMailSessionResource = new JavaMailSessionResource(on.toString(), false, false, false, (JavaMailSession)factory);
                    this.__getjmxService().registerModelMBean((Object)javaMailSessionResource, on);
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break;
                    logger.log(BasicLevel.DEBUG, (Object)("Register session mail factory with name " + factoryName));
                    break;
                }
                case 2: {
                    on = J2eeObjectName.JavaMailResource((String)this.getDomainName(), (String)factoryName, (String)this.getJonasServerName(), (String)"javax.mail.internet.MimePartDataSource");
                    JavaMailMimePartDSResource javaMailMimePartDSResource = null;
                    javaMailMimePartDSResource = new JavaMailMimePartDSResource(on.toString(), false, false, false, (JavaMailMimePartDS)factory);
                    this.__getjmxService().registerModelMBean((Object)javaMailMimePartDSResource, on);
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break;
                    logger.log(BasicLevel.DEBUG, (Object)("Register mime mail factory with name " + factoryName));
                }
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)"Could not register JavaMailResource MBean");
        }
    }

    public void createMailFactoryMBean(String string, Properties properties, Boolean bl) throws MailServiceException {
        if (!this.__McreateMailFactoryMBean$java_lang_String$java_util_Properties$java_lang_Boolean) {
            this.__createMailFactoryMBean(string, properties, bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createMailFactoryMBean$java_lang_String$java_util_Properties$java_lang_Boolean", new Object[]{string, properties, bl});
            this.__createMailFactoryMBean(string, properties, bl);
            this.__IM.onExit((Object)this, "createMailFactoryMBean$java_lang_String$java_util_Properties$java_lang_Boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createMailFactoryMBean$java_lang_String$java_util_Properties$java_lang_Boolean", throwable);
            throw throwable;
        }
    }

    private void __createMailFactoryMBean(String name, Properties props, Boolean loadFromFile) throws MailServiceException {
        boolean fromFile = loadFromFile;
        if (!fromFile) {
            try {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Call getInstance on JProp in order to create the properties file");
                }
                JProp.getInstance((String)name, (Properties)props);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot create mail factory " + name + " as cannot create properties file : " + e.toString()));
                throw new ServiceException("MailService: Cannot create mail factory " + name + ",\n" + e.toString());
            }
        }
        try {
            this.createMailFactory(name, props);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot create mail factory: " + name));
            throw new ServiceException("MailService: Cannot create mail factory: " + name + ",\n" + e.toString());
        }
    }

    public void unbindMailFactories() throws MailServiceException {
        if (!this.__MunbindMailFactories) {
            this.__unbindMailFactories();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindMailFactories", new Object[0]);
            this.__unbindMailFactories();
            this.__IM.onExit((Object)this, "unbindMailFactories", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindMailFactories", throwable);
            throw throwable;
        }
    }

    private void __unbindMailFactories() throws MailServiceException {
        String factoryName;
        int i;
        String[] factories = new String[this.__getjMailSessionFactories().size()];
        factories = this.__getjMailSessionFactories().keySet().toArray(factories);
        for (i = 0; i < factories.length; ++i) {
            factoryName = factories[i];
            this.unbindMailFactoryMBean(factoryName);
        }
        factories = new String[this.__getjMailMimePartDSFactories().size()];
        factories = this.__getjMailMimePartDSFactories().keySet().toArray(factories);
        for (i = 0; i < factories.length; ++i) {
            factoryName = factories[i];
            this.unbindMailFactoryMBean(factoryName);
        }
    }

    public void unbindMailFactoryMBean(String string) throws MailServiceException {
        if (!this.__MunbindMailFactoryMBean$java_lang_String) {
            this.__unbindMailFactoryMBean(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindMailFactoryMBean$java_lang_String", new Object[]{string});
            this.__unbindMailFactoryMBean(string);
            this.__IM.onExit((Object)this, "unbindMailFactoryMBean$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindMailFactoryMBean$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __unbindMailFactoryMBean(String factoryName) throws MailServiceException {
        int typeOfFactory;
        String name = null;
        JavaMailSession jmailSession = (JavaMailSession)this.__getjMailSessionFactories().get(factoryName);
        JavaMailMimePartDS jMailMimePartDS = (JavaMailMimePartDS)this.__getjMailMimePartDSFactories().get(factoryName);
        if (jmailSession != null) {
            name = jmailSession.getName();
            typeOfFactory = 1;
        } else if (jMailMimePartDS != null) {
            name = jMailMimePartDS.getName();
            typeOfFactory = 2;
        } else {
            throw new MailServiceException("Can not unload the mail factory '" + factoryName + "' (this is not a known factory name)");
        }
        try {
            this.__getictx().unbind(name);
            this.__getboundFactories().remove(name);
        }
        catch (NamingException e) {
            throw new MailServiceException("Can not unbind the factory '" + name + "'.", (Throwable)e);
        }
        JProp.removeInstance((String)name);
        if (this.__getjmxService() != null) {
            ObjectName on = null;
            switch (typeOfFactory) {
                case 1: {
                    on = J2eeObjectName.JavaMailResource((String)this.getDomainName(), (String)factoryName, (String)this.getJonasServerName(), (String)"javax.mail.Session");
                    this.__getjmxService().unregisterModelMBean(on);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("Unregister session mail factory with name " + factoryName));
                    }
                    this.__getjMailSessionFactories().remove(factoryName);
                    break;
                }
                case 2: {
                    on = J2eeObjectName.JavaMailResource((String)this.getDomainName(), (String)factoryName, (String)this.getJonasServerName(), (String)"javax.mail.internet.MimePartDataSource");
                    this.__getjmxService().unregisterModelMBean(on);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("Unregister mime mail factory with name " + factoryName));
                    }
                    this.__getjMailMimePartDSFactories().remove(factoryName);
                }
            }
        }
    }

    public String getFactoryName(String string) {
        String string2;
        if (!this.__MgetFactoryName$java_lang_String) {
            return this.__getFactoryName(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getFactoryName$java_lang_String", new Object[]{string});
            string2 = this.__getFactoryName(string);
            this.__IM.onExit((Object)this, "getFactoryName$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFactoryName$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getFactoryName(String jndiName) {
        return (String)this.__getboundFactories().get(jndiName);
    }

    public Integer getCurrentNumberOfMailFactories() {
        Integer n;
        if (!this.__MgetCurrentNumberOfMailFactories) {
            return this.__getCurrentNumberOfMailFactories();
        }
        try {
            this.__IM.onEntry((Object)this, "getCurrentNumberOfMailFactories", new Object[0]);
            n = this.__getCurrentNumberOfMailFactories();
            this.__IM.onExit((Object)this, "getCurrentNumberOfMailFactories", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCurrentNumberOfMailFactories", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getCurrentNumberOfMailFactories() {
        return this.__getjMailSessionFactories().size() + this.__getjMailMimePartDSFactories().size();
    }

    public Integer getCurrentNumberOfSessionMailFactories() {
        Integer n;
        if (!this.__MgetCurrentNumberOfSessionMailFactories) {
            return this.__getCurrentNumberOfSessionMailFactories();
        }
        try {
            this.__IM.onEntry((Object)this, "getCurrentNumberOfSessionMailFactories", new Object[0]);
            n = this.__getCurrentNumberOfSessionMailFactories();
            this.__IM.onExit((Object)this, "getCurrentNumberOfSessionMailFactories", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCurrentNumberOfSessionMailFactories", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getCurrentNumberOfSessionMailFactories() {
        return this.__getjMailSessionFactories().size();
    }

    public Integer getCurrentNumberOfMimeMailFactories() {
        Integer n;
        if (!this.__MgetCurrentNumberOfMimeMailFactories) {
            return this.__getCurrentNumberOfMimeMailFactories();
        }
        try {
            this.__IM.onEntry((Object)this, "getCurrentNumberOfMimeMailFactories", new Object[0]);
            n = this.__getCurrentNumberOfMimeMailFactories();
            this.__IM.onExit((Object)this, "getCurrentNumberOfMimeMailFactories", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCurrentNumberOfMimeMailFactories", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getCurrentNumberOfMimeMailFactories() {
        return this.__getjMailMimePartDSFactories().size();
    }

    public Properties getMailFactoryPropertiesFile(String string) throws Exception {
        Properties properties;
        if (!this.__MgetMailFactoryPropertiesFile$java_lang_String) {
            return this.__getMailFactoryPropertiesFile(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getMailFactoryPropertiesFile$java_lang_String", new Object[]{string});
            properties = this.__getMailFactoryPropertiesFile(string);
            this.__IM.onExit((Object)this, "getMailFactoryPropertiesFile$java_lang_String", (Object)properties);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMailFactoryPropertiesFile$java_lang_String", throwable);
            throw throwable;
        }
        return properties;
    }

    private Properties __getMailFactoryPropertiesFile(String configFile) throws Exception {
        try {
            return JProp.getInstance((String)configFile).getConfigFileEnv();
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Error occured when reading file " + configFile));
            throw e;
        }
    }

    public List<String> getMailFactoryPropertiesFiles() throws Exception {
        List<String> list;
        if (!this.__MgetMailFactoryPropertiesFiles) {
            return this.__getMailFactoryPropertiesFiles();
        }
        try {
            this.__IM.onEntry((Object)this, "getMailFactoryPropertiesFiles", new Object[0]);
            list = this.__getMailFactoryPropertiesFiles();
            this.__IM.onExit((Object)this, "getMailFactoryPropertiesFiles", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMailFactoryPropertiesFiles", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getMailFactoryPropertiesFiles() throws Exception {
        return JModule.getMailFactoryPropsInDir();
    }

    public List<String> getMimePartMailFactoryPropertiesFiles() throws Exception {
        List<String> list;
        if (!this.__MgetMimePartMailFactoryPropertiesFiles) {
            return this.__getMimePartMailFactoryPropertiesFiles();
        }
        try {
            this.__IM.onEntry((Object)this, "getMimePartMailFactoryPropertiesFiles", new Object[0]);
            list = this.__getMimePartMailFactoryPropertiesFiles();
            this.__IM.onExit((Object)this, "getMimePartMailFactoryPropertiesFiles", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMimePartMailFactoryPropertiesFiles", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getMimePartMailFactoryPropertiesFiles() throws Exception {
        return JModule.getMailFactoryPropsInDir((String)"javax.mail.internet.MimePartDataSource");
    }

    public List<String> getSessionMailFactoryPropertiesFiles() throws Exception {
        List<String> list;
        if (!this.__MgetSessionMailFactoryPropertiesFiles) {
            return this.__getSessionMailFactoryPropertiesFiles();
        }
        try {
            this.__IM.onEntry((Object)this, "getSessionMailFactoryPropertiesFiles", new Object[0]);
            list = this.__getSessionMailFactoryPropertiesFiles();
            this.__IM.onExit((Object)this, "getSessionMailFactoryPropertiesFiles", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSessionMailFactoryPropertiesFiles", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getSessionMailFactoryPropertiesFiles() throws Exception {
        return JModule.getMailFactoryPropsInDir((String)"javax.mail.Session");
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __setJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
    }

    public void setRegistryService(RegistryService registryService) {
        if (!this.__MsetRegistryService$org_ow2_jonas_registry_RegistryService) {
            this.__setRegistryService(registryService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", new Object[]{registryService});
            this.__setRegistryService(registryService);
            this.__IM.onExit((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", throwable);
            throw throwable;
        }
    }

    private void __setRegistryService(RegistryService registry) {
        this.__setregistryService(registry);
    }

    private RegistryService getRegistryService() {
        RegistryService registryService;
        if (!this.__MgetRegistryService) {
            return this.__getRegistryService();
        }
        try {
            this.__IM.onEntry((Object)this, "getRegistryService", new Object[0]);
            registryService = this.__getRegistryService();
            this.__IM.onExit((Object)this, "getRegistryService", (Object)registryService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRegistryService", throwable);
            throw throwable;
        }
        return registryService;
    }

    private RegistryService __getRegistryService() {
        return this.__getregistryService();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("registryService")) {
                this.__FregistryService = true;
            }
            if (set.contains("ictx")) {
                this.__Fictx = true;
            }
            if (set.contains("factoryNames")) {
                this.__FfactoryNames = true;
            }
            if (set.contains("jMailSessionFactories")) {
                this.__FjMailSessionFactories = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
            if (set.contains("boundFactories")) {
                this.__FboundFactories = true;
            }
            if (set.contains("jMailMimePartDSFactories")) {
                this.__FjMailMimePartDSFactories = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setFactories$java_lang_String")) {
                this.__MsetFactories$java_lang_String = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("recreateJavaMailFactory$org_ow2_jonas_mail_factory_JavaMail")) {
                this.__MrecreateJavaMailFactory$org_ow2_jonas_mail_factory_JavaMail = true;
            }
            if (set.contains("renameJavaMailFactory$java_lang_String$org_ow2_jonas_mail_factory_JavaMail")) {
                this.__MrenameJavaMailFactory$java_lang_String$org_ow2_jonas_mail_factory_JavaMail = true;
            }
            if (set.contains("createMailFactory$java_lang_String$java_util_Properties")) {
                this.__McreateMailFactory$java_lang_String$java_util_Properties = true;
            }
            if (set.contains("createMailFactoryMBean$java_lang_String$java_util_Properties$java_lang_Boolean")) {
                this.__McreateMailFactoryMBean$java_lang_String$java_util_Properties$java_lang_Boolean = true;
            }
            if (set.contains("unbindMailFactories")) {
                this.__MunbindMailFactories = true;
            }
            if (set.contains("unbindMailFactoryMBean$java_lang_String")) {
                this.__MunbindMailFactoryMBean$java_lang_String = true;
            }
            if (set.contains("getFactoryName$java_lang_String")) {
                this.__MgetFactoryName$java_lang_String = true;
            }
            if (set.contains("getCurrentNumberOfMailFactories")) {
                this.__MgetCurrentNumberOfMailFactories = true;
            }
            if (set.contains("getCurrentNumberOfSessionMailFactories")) {
                this.__MgetCurrentNumberOfSessionMailFactories = true;
            }
            if (set.contains("getCurrentNumberOfMimeMailFactories")) {
                this.__MgetCurrentNumberOfMimeMailFactories = true;
            }
            if (set.contains("getMailFactoryPropertiesFile$java_lang_String")) {
                this.__MgetMailFactoryPropertiesFile$java_lang_String = true;
            }
            if (set.contains("getMailFactoryPropertiesFiles")) {
                this.__MgetMailFactoryPropertiesFiles = true;
            }
            if (set.contains("getMimePartMailFactoryPropertiesFiles")) {
                this.__MgetMimePartMailFactoryPropertiesFiles = true;
            }
            if (set.contains("getSessionMailFactoryPropertiesFiles")) {
                this.__MgetSessionMailFactoryPropertiesFiles = true;
            }
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("setRegistryService$org_ow2_jonas_registry_RegistryService")) {
                this.__MsetRegistryService$org_ow2_jonas_registry_RegistryService = true;
            }
            if (set.contains("getRegistryService")) {
                this.__MgetRegistryService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

