/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector.utils;

import java.io.CharArrayWriter;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Wrapper {
    private boolean debug = false;
    private Map map = null;

    public Wrapper(boolean debug) {
        this.debug = debug;
    }

    public String parse(InputStream in) throws Exception {
        StringBuffer buff = new StringBuffer();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(in);
        NodeList nl = doc.getElementsByTagName("resourceadapter");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            buff.append(this.explore(node));
        }
        return buff.toString();
    }

    public String explore(Node node) throws Exception {
        StringBuffer buff = new StringBuffer();
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeName().equals("config-property")) {
                buff.append(this.extractPropertyInfo(n.getChildNodes()));
                continue;
            }
            if (n.getNodeName().equals("resourceadapter-class") || n.getNodeName().equals("managedconnectionfactory-class")) {
                String nodeName = n.getFirstChild().getNodeValue();
                buff.append("[");
                buff.append(nodeName);
                buff.append("]");
                buff.append("\n");
            }
            buff.append(this.explore(n));
        }
        return buff.toString();
    }

    public String extractPropertyInfo(NodeList nodeList) throws Exception {
        String name = null;
        String value = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeName().equals("config-property-name")) {
                name = n.getFirstChild().getNodeValue();
                continue;
            }
            if (!n.getNodeName().equals("config-property-value")) continue;
            value = n.getFirstChild().getNodeValue();
        }
        StringBuffer buff = new StringBuffer();
        buff.append("  ");
        buff.append(name);
        buff.append("\t");
        if (value != null) {
            buff.append(value);
        }
        buff.append("\n");
        return buff.toString();
    }

    public String update(InputStream in, Map map) throws Exception {
        this.map = map;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(in);
        NodeList nl = doc.getElementsByTagName("resourceadapter");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            this.browse(node);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource source = new DOMSource(doc);
        CharArrayWriter writer = new CharArrayWriter();
        StreamResult output = new StreamResult(writer);
        transformer.transform(source, output);
        writer.flush();
        return writer.toString();
    }

    public void browse(Node node) throws Exception {
        if (this.debug) {
            System.out.println("Wrapper.browse(" + node + ")");
        }
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            String nodeValue = n.getNodeValue();
            if (nodeValue != null && this.map.containsKey(nodeValue)) {
                if (this.debug) {
                    System.out.println("NodeName=" + nodeValue);
                }
                this.explore(n.getParentNode().getParentNode(), nodeValue);
                continue;
            }
            if (nodeValue != null && !nodeValue.equals("config-property")) continue;
            this.browse(n);
        }
    }

    public void explore(Node node, String key) throws Exception {
        if (this.debug) {
            System.out.println(">>>> Wrapper.explore(" + node + "," + key + ")");
        }
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            String nodeName = n.getNodeName();
            if (nodeName.equals("config-property")) {
                this.setPropertiesValue(n.getChildNodes(), key);
                continue;
            }
            if (nodeName.equals("outbound-resourceadapter") || nodeName.equals("inbound-resourceadapter")) continue;
            this.explore(n, key);
        }
        if (this.debug) {
            System.out.println("<<<<<< Wrapper.explore node = " + node);
        }
    }

    public void setPropertiesValue(NodeList nodeList, String key) throws Exception {
        if (this.debug) {
            System.out.println("Wrapper.setPropertiesValue(" + nodeList + "," + key + ")");
        }
        String name = null;
        String value = null;
        Map prop = (Map)this.map.get(key);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeName().equals("config-property-name")) {
                name = n.getFirstChild().getNodeValue();
                continue;
            }
            if (!n.getNodeName().equals("config-property-value") || !prop.containsKey(name)) continue;
            n.getFirstChild().setNodeValue((String)prop.get(name));
        }
        if (this.debug) {
            System.out.println("Wrapper.setPropertiesValue name=" + name + ", value=" + value);
        }
    }
}

