/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.annotation.processor.handler;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.util.annotation.processor.ProcessorException;
import org.ow2.util.annotation.processor.handler.AbstractAnnotationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInjectionHandler
extends AbstractAnnotationHandler {
    protected void doInjectMethod(Method method, Object target, Object value) throws ProcessorException {
        boolean accessibility = method.isAccessible();
        try {
            method.setAccessible(true);
            method.invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessorException("Cannot inject '" + method + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessorException("Cannot inject '" + method + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new ProcessorException("Cannot inject '" + method + "'", e);
        }
        finally {
            method.setAccessible(accessibility);
        }
    }

    protected void doInjectField(Field field, Object target, Object value) throws ProcessorException {
        boolean accessibility = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessorException("Cannot inject '" + field + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessorException("Cannot inject '" + field + "'", e);
        }
        finally {
            field.setAccessible(accessibility);
        }
    }

    protected String getAttributeName(Method method) throws ProcessorException {
        String name = method.getName();
        String attributeName = null;
        if (name.startsWith("set")) {
            attributeName = name.substring(3);
        } else if (name.startsWith("unset")) {
            attributeName = name.substring(5);
        } else if (name.startsWith("bind")) {
            attributeName = name.substring(4);
        } else if (name.startsWith("unbind")) {
            attributeName = name.substring(6);
        } else {
            throw new ProcessorException("Method '" + method + "' is not a recognised method");
        }
        attributeName = attributeName.substring(0, 1).toLowerCase() + attributeName.substring(1);
        return attributeName;
    }

    protected boolean isSetterMethod(Method method) {
        String name = method.getName();
        if (!name.startsWith("set")) {
            return false;
        }
        Class<?>[] types = method.getParameterTypes();
        return types.length == 1;
    }

    protected Class<?> getSetterParameterType(Method method) {
        if (!this.isSetterMethod(method)) {
            throw new IllegalStateException("Method " + method + " is not a setter method");
        }
        return method.getParameterTypes()[0];
    }
}

