/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.Executor;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.component.jms.reply.ReplyManagerSupport;
import org.apache.camel.component.jms.reply.TemporaryQueueReplyHandler;
import org.apache.camel.component.jms.reply.UnknownReplyMessageException;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.destination.DestinationResolver;

public class TemporaryQueueReplyManager
extends ReplyManagerSupport {
    public String registerReply(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        TemporaryQueueReplyHandler handler = new TemporaryQueueReplyHandler(this, exchange, callback, originalCorrelationId, requestTimeout);
        this.correlation.put(correlationId, handler, requestTimeout);
        return correlationId;
    }

    public void updateCorrelationId(String correlationId, String newCorrelationId, long requestTimeout) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Updated provisional correlationId [" + correlationId + "] to expected correlationId [" + newCorrelationId + "]"));
        }
        ReplyHandler handler = (ReplyHandler)this.correlation.remove(correlationId);
        this.correlation.put(newCorrelationId, handler, requestTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReplyMessage(String correlationID, javax.jms.Message message) {
        ReplyHandler handler = (ReplyHandler)this.correlation.get(correlationID);
        if (handler == null && this.endpoint.isUseMessageIDAsCorrelationID()) {
            handler = this.waitForProvisionCorrelationToBeUpdated(correlationID, message);
        }
        if (handler != null) {
            try {
                handler.onReply(correlationID, message);
            }
            finally {
                this.correlation.remove(correlationID);
            }
        } else {
            String text = "Reply received for unknown correlationID [" + correlationID + "] -> " + message;
            this.log.warn((Object)text);
            throw new UnknownReplyMessageException(text, message, correlationID);
        }
    }

    public void setReplyToSelectorHeader(Message camelMessage, javax.jms.Message jmsMessage) throws JMSException {
    }

    protected AbstractMessageListenerContainer createListenerContainer() throws Exception {
        DefaultMessageListenerContainer answer = new DefaultMessageListenerContainer();
        answer.setDestinationName("temporary");
        answer.setDestinationResolver(new DestinationResolver(){

            public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
                TemporaryQueue queue = session.createTemporaryQueue();
                TemporaryQueueReplyManager.this.setReplyTo((Destination)queue);
                return queue;
            }
        });
        answer.setAutoStartup(true);
        answer.setMessageListener((Object)this);
        answer.setPubSubDomain(false);
        answer.setSubscriptionDurable(false);
        answer.setConcurrentConsumers(1);
        answer.setConnectionFactory(this.endpoint.getConnectionFactory());
        String clientId = this.endpoint.getClientId();
        if (clientId != null) {
            clientId = clientId + ".CamelReplyManager";
            answer.setClientId(clientId);
        }
        answer.setSessionTransacted(false);
        if (this.endpoint.getExceptionListener() != null) {
            answer.setExceptionListener(this.endpoint.getExceptionListener());
        }
        if (this.endpoint.getReceiveTimeout() >= 0L) {
            answer.setReceiveTimeout(this.endpoint.getReceiveTimeout());
        }
        if (this.endpoint.getRecoveryInterval() >= 0L) {
            answer.setRecoveryInterval(this.endpoint.getRecoveryInterval());
        }
        if (this.endpoint.getTaskExecutor() != null) {
            answer.setTaskExecutor((Executor)this.endpoint.getTaskExecutor());
        } else if (this.endpoint.getTaskExecutorSpring2() != null) {
            IntrospectionSupport.setProperty((Object)answer, (String)"taskExecutor", (Object)this.endpoint.getTaskExecutorSpring2());
        }
        return answer;
    }
}

