/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBuilder
extends Builder {
    Project project;
    boolean initialized;

    public ProjectBuilder(Project project) {
        super(project);
        this.project = project;
    }

    public ProjectBuilder(ProjectBuilder builder) {
        super(builder);
        this.project = builder.project;
    }

    @Override
    public long lastModified() {
        return Math.max(this.project.lastModified(), super.lastModified());
    }

    @Override
    protected Object[] getMacroDomains() {
        return new Object[]{this.project, this.project.getWorkspace()};
    }

    @Override
    public Builder getSubBuilder() throws Exception {
        return this.project.getBuilder(this);
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public void init() {
        try {
            if (!this.initialized) {
                this.initialized = true;
                for (Container container : this.project.getBuildpath()) {
                    this.addClasspath(container.getFile());
                }
                for (Container container : this.project.getBootclasspath()) {
                    this.addClasspath(container.getFile());
                }
                for (File file : this.project.getAllsourcepath()) {
                    this.addSourcepath(file);
                }
            }
        }
        catch (Exception e) {
            this.error("init project builder fails", e, new Object[0]);
        }
    }

    @Override
    public List<Jar> getClasspath() {
        this.init();
        return super.getClasspath();
    }

    @Override
    protected void changedFile(File f) {
        this.project.getWorkspace().changedFile(f);
    }
}

