/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven;

import aQute.lib.osgi.Processor;
import aQute.lib.osgi.WriteResource;
import aQute.lib.tag.Tag;
import aQute.libg.version.Version;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pom
extends WriteResource {
    final Manifest manifest;
    private List<String> scm = new ArrayList<String>();
    private List<String> developers = new ArrayList<String>();
    static final Pattern NAME_URL = Pattern.compile("(.*)(http://.*)");
    String xbsn;
    String xgroupId;
    String xartifactId;

    public String getBsn() {
        if (this.xbsn == null) {
            this.xbsn = this.manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        }
        if (this.xbsn == null) {
            throw new RuntimeException("Cannot create POM unless bsn is set");
        }
        this.xbsn = this.xbsn.trim();
        int n = this.xbsn.lastIndexOf(46);
        if (n < 0) {
            n = this.xbsn.length();
            this.xbsn = this.xbsn + "." + this.xbsn;
        }
        this.xgroupId = this.xbsn.substring(0, n);
        this.xartifactId = this.xbsn.substring(n + 1);
        n = this.xartifactId.indexOf(59);
        if (n > 0) {
            this.xartifactId = this.xartifactId.substring(0, n).trim();
        }
        return this.xbsn;
    }

    public String getGroupId() {
        this.getBsn();
        return this.xgroupId;
    }

    public String getArtifactId() {
        this.getBsn();
        return this.xartifactId;
    }

    public Version getVersion() {
        String version = this.manifest.getMainAttributes().getValue("Bundle-Version");
        return new Version(version);
    }

    public Pom(Manifest manifest) {
        this.manifest = manifest;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        String scmheader;
        PrintWriter ps = new PrintWriter(out);
        String name = this.manifest.getMainAttributes().getValue("Bundle-Name");
        String description = this.manifest.getMainAttributes().getValue("Bundle-Description");
        String docUrl = this.manifest.getMainAttributes().getValue("Bundle-DocURL");
        String bundleVendor = this.manifest.getMainAttributes().getValue("Bundle-Vendor");
        String licenses = this.manifest.getMainAttributes().getValue("Bundle-License");
        Tag project = new Tag("project");
        project.addAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        project.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        project.addAttribute("xmlns:xsi", "");
        project.addAttribute("xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd");
        project.addContent(new Tag("modelVersion").addContent("4.0.0"));
        project.addContent(new Tag("groupId").addContent(this.getGroupId()));
        project.addContent(new Tag("artifactId").addContent(this.getArtifactId()));
        project.addContent(new Tag("version").addContent(this.getVersion().toString()));
        if (description != null) {
            new Tag(project, "description").addContent(description);
        }
        if (name != null) {
            new Tag(project, "name").addContent(name);
        }
        if (docUrl != null) {
            new Tag(project, "url").addContent(docUrl);
        }
        if ((scmheader = this.manifest.getMainAttributes().getValue("Bundle-SCM")) != null) {
            this.scm.add(scmheader);
        }
        Tag scmtag = new Tag(project, "scm");
        if (this.scm != null && !this.scm.isEmpty()) {
            for (String cm : this.scm) {
                new Tag(scmtag, "url").addContent(cm);
                new Tag(scmtag, "connection").addContent(cm);
                new Tag(scmtag, "developerConnection").addContent(cm);
            }
        }
        if (bundleVendor != null) {
            Matcher m = NAME_URL.matcher(bundleVendor);
            String namePart = bundleVendor;
            String urlPart = null;
            if (m.matches()) {
                namePart = m.group(1);
                urlPart = m.group(2);
            }
            Tag organization = new Tag(project, "organization");
            new Tag(organization, "name").addContent(namePart.trim());
            if (urlPart != null) {
                new Tag(organization, "url").addContent(urlPart.trim());
            }
        }
        if (!this.developers.isEmpty()) {
            Tag d = new Tag(project, "developers");
            Iterator<String> i$ = this.developers.iterator();
            while (i$.hasNext()) {
                String email;
                String id = email = i$.next();
                String xname = email;
                String organization = null;
                Matcher m = Pattern.compile("([^@]+)@([\\d\\w\\-_\\.]+)\\.([\\d\\w\\-_\\.]+)").matcher(email);
                if (m.matches()) {
                    xname = m.group(1);
                    organization = m.group(2);
                }
                Tag developer = new Tag(d, "developer");
                new Tag(developer, "id").addContent(id);
                new Tag(developer, "name").addContent(xname);
                new Tag(developer, "email").addContent(email);
                if (organization == null) continue;
                new Tag(developer, "organization").addContent(organization);
            }
        }
        if (licenses != null) {
            Tag ls = new Tag(project, "licenses");
            Map<String, Map<String, String>> map = Processor.parseHeader(licenses, null);
            for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                Tag l = new Tag(ls, "license");
                Map<String, String> values = entry.getValue();
                String url = entry.getKey();
                if (values.containsKey("description")) {
                    this.tagFromMap(l, values, "description", "name", url);
                } else {
                    this.tagFromMap(l, values, "name", "name", url);
                }
                this.tagFromMap(l, values, "url", "url", url);
                this.tagFromMap(l, values, "distribution", "distribution", "repo");
            }
        }
        project.print(0, ps);
        ps.flush();
    }

    private Tag tagFromMap(Tag parent, Map<String, String> values, String string, String tag, String object) {
        String value = values.get(string);
        if (value == null) {
            value = object;
        }
        if (value == null) {
            return parent;
        }
        new Tag(parent, tag).addContent(value.trim());
        return parent;
    }

    public void setSCM(String scm) {
        this.scm.add(scm);
    }

    public void addDeveloper(String email) {
        this.developers.add(email);
    }
}

