/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.repackage.cglib.asm.attrs;

import org.hibernate.repackage.cglib.asm.Attribute;
import org.hibernate.repackage.cglib.asm.ByteVector;
import org.hibernate.repackage.cglib.asm.ClassReader;
import org.hibernate.repackage.cglib.asm.ClassWriter;
import org.hibernate.repackage.cglib.asm.Label;

public class SourceDebugExtensionAttribute
extends Attribute {
    public String debugExtension;

    public SourceDebugExtensionAttribute() {
        super("SourceDebugExtension");
    }

    public SourceDebugExtensionAttribute(String string) {
        this();
        this.debugExtension = string;
    }

    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        return new SourceDebugExtensionAttribute(this.readUTF8(classReader, n, n2));
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = this.putUTF8(this.debugExtension);
        return new ByteVector().putByteArray(byArray2, 0, byArray2.length);
    }

    private String readUTF8(ClassReader classReader, int n, int n2) {
        int n3 = n + n2;
        byte[] byArray = classReader.b;
        char[] cArray = new char[n2];
        int n4 = 0;
        block4: while (n < n3) {
            byte by;
            int n5 = byArray[n++] & 0xFF;
            switch (n5 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n4++] = (char)n5;
                    continue block4;
                }
                case 12: 
                case 13: {
                    by = byArray[n++];
                    cArray[n4++] = (char)((n5 & 0x1F) << 6 | by & 0x3F);
                    continue block4;
                }
            }
            by = byArray[n++];
            byte by2 = byArray[n++];
            cArray[n4++] = (char)((n5 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
        }
        return new String(cArray, 0, n4);
    }

    private byte[] putUTF8(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (n >= 1 && n <= 127) {
                ++n3;
                continue;
            }
            if (n > 2047) {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        byte[] byArray = new byte[n3];
        n = 0;
        while (n < n2) {
            char c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            byArray[n++] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[n++] = (byte)(0x80 | c & 0x3F);
        }
        return byArray;
    }

    public String toString() {
        return this.debugExtension;
    }
}

