/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.hibernate.Hibernate;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.QueueingProcessor;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkQueue;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;
import org.hibernate.search.backend.impl.blackhole.BlackHoleBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.jgroups.MasterJGroupsBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.jgroups.SlaveJGroupsBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.jms.JMSBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessorFactory;
import org.hibernate.search.batchindexing.Executors;
import org.hibernate.search.engine.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.PluginLoader;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchedQueueingProcessor
implements QueueingProcessor {
    private static final Logger log = LoggerFactory.make();
    private final boolean sync;
    private final int batchSize;
    private final ExecutorService executorService;
    private final BackendQueueProcessorFactory backendQueueProcessorFactory;
    private final SearchFactoryImplementor searchFactoryImplementor;

    public BatchedQueueingProcessor(SearchFactoryImplementor searchFactoryImplementor, Properties properties) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.sync = BatchedQueueingProcessor.isConfiguredAsSync(properties);
        int threadPoolSize = ConfigurationParseHelper.getIntValue(properties, "hibernate.search.worker.thread_pool.size", 1);
        int queueSize = ConfigurationParseHelper.getIntValue(properties, "hibernate.search.worker.buffer_queue.max", Integer.MAX_VALUE);
        this.batchSize = ConfigurationParseHelper.getIntValue(properties, "hibernate.search.worker.batch_size", 0);
        this.executorService = !this.sync ? Executors.newFixedThreadPool(threadPoolSize, "backend queueing processor", queueSize) : null;
        String backend = properties.getProperty("hibernate.search.worker.backend");
        this.backendQueueProcessorFactory = StringHelper.isEmpty(backend) || "lucene".equalsIgnoreCase(backend) ? new LuceneBackendQueueProcessorFactory() : ("jms".equalsIgnoreCase(backend) ? new JMSBackendQueueProcessorFactory() : ("blackhole".equalsIgnoreCase(backend) ? new BlackHoleBackendQueueProcessorFactory() : ("jgroupsMaster".equals(backend) ? new MasterJGroupsBackendQueueProcessorFactory() : ("jgroupsSlave".equals(backend) ? new SlaveJGroupsBackendQueueProcessorFactory() : PluginLoader.instanceFromName(BackendQueueProcessorFactory.class, backend, BatchedQueueingProcessor.class, "processor")))));
        this.backendQueueProcessorFactory.initialize(properties, searchFactoryImplementor);
        searchFactoryImplementor.setBackendQueueProcessorFactory(this.backendQueueProcessorFactory);
    }

    @Override
    public void add(Work work, WorkQueue workQueue) {
        workQueue.add(work);
        if (this.batchSize > 0 && workQueue.size() >= this.batchSize) {
            WorkQueue subQueue = workQueue.splitQueue();
            this.prepareWorks(subQueue);
            this.performWorks(subQueue);
        }
    }

    @Override
    public void prepareWorks(WorkQueue workQueue) {
        List<Work> queue = workQueue.getQueue();
        int initialSize = queue.size();
        ArrayList<LuceneWork> luceneQueue = new ArrayList<LuceneWork>(initialSize);
        this.processWorkByLayer(queue, initialSize, luceneQueue, Layer.FIRST);
        this.processWorkByLayer(queue, initialSize, luceneQueue, Layer.SECOND);
        workQueue.setSealedQueue(this.optimize(luceneQueue));
    }

    private List<LuceneWork> optimize(List<LuceneWork> luceneQueue) {
        int size = luceneQueue.size();
        ArrayList<Integer> toDelete = new ArrayList<Integer>(size);
        HashMap<DuplicatableWork, Integer> workByPosition = new HashMap<DuplicatableWork, Integer>(size);
        for (int index = 0; index < size; ++index) {
            Integer oldIndex;
            DuplicatableWork dupWork;
            LuceneWork work = luceneQueue.get(index);
            if (work instanceof AddLuceneWork) {
                dupWork = new DuplicatableWork(work);
                oldIndex = (Integer)workByPosition.get(dupWork);
                if (oldIndex != null) {
                    toDelete.add(oldIndex);
                    workByPosition.put(dupWork, index);
                }
                workByPosition.put(dupWork, index);
                continue;
            }
            if (!(work instanceof DeleteLuceneWork)) continue;
            dupWork = new DuplicatableWork(work);
            oldIndex = (Integer)workByPosition.get(dupWork);
            if (oldIndex != null) {
                toDelete.add(index);
                continue;
            }
            workByPosition.put(dupWork, index);
        }
        ArrayList<LuceneWork> result = new ArrayList<LuceneWork>(size - toDelete.size());
        for (int index = 0; index < size; ++index) {
            if (toDelete.contains(index)) continue;
            result.add(luceneQueue.get(index));
        }
        return result;
    }

    private <T> void processWorkByLayer(List<Work> queue, int initialSize, List<LuceneWork> luceneQueue, Layer layer) {
        for (int i = 0; i < initialSize; ++i) {
            Work work = queue.get(i);
            if (work == null || !layer.isRightLayer(work.getType())) continue;
            queue.set(i, null);
            this.addWorkToBuilderQueue(luceneQueue, work);
        }
    }

    private <T> void addWorkToBuilderQueue(List<LuceneWork> luceneQueue, Work<T> work) {
        Class entityClass = work.getEntityClass() != null ? work.getEntityClass() : Hibernate.getClass(work.getEntity());
        DocumentBuilderIndexedEntity<T> entityBuilder = this.searchFactoryImplementor.getDocumentBuilderIndexedEntity(entityClass);
        if (entityBuilder != null) {
            entityBuilder.addWorkToQueue(entityClass, work.getEntity(), work.getId(), work.getType(), luceneQueue, this.searchFactoryImplementor);
            return;
        }
        DocumentBuilderContainedEntity<T> containedInBuilder = this.searchFactoryImplementor.getDocumentBuilderContainedEntity(entityClass);
        if (containedInBuilder != null) {
            containedInBuilder.addWorkToQueue(entityClass, work.getEntity(), work.getId(), work.getType(), luceneQueue, this.searchFactoryImplementor);
        }
    }

    @Override
    public void performWorks(WorkQueue workQueue) {
        List<LuceneWork> sealedQueue = workQueue.getSealedQueue();
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("Lucene WorkQueue to send to backend: \n\t");
            for (LuceneWork lw : sealedQueue) {
                sb.append(lw.toString());
                sb.append("\n\t");
            }
            log.trace(sb.toString());
        }
        Runnable processor = this.backendQueueProcessorFactory.getProcessor(sealedQueue);
        if (this.sync) {
            processor.run();
        } else {
            this.executorService.execute(processor);
        }
    }

    @Override
    public void cancelWorks(WorkQueue workQueue) {
        workQueue.clear();
    }

    @Override
    public void close() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error("Unable to properly shut down asynchronous indexing work", (Throwable)e);
            }
        }
        this.backendQueueProcessorFactory.close();
    }

    public static boolean isConfiguredAsSync(Properties properties) {
        return !"async".equalsIgnoreCase(properties.getProperty("hibernate.search.worker.execution"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Layer {
        FIRST,
        SECOND;


        public boolean isRightLayer(WorkType type) {
            if (this == FIRST && type != WorkType.COLLECTION) {
                return true;
            }
            return this == SECOND && type == WorkType.COLLECTION;
        }
    }

    private static class DuplicatableWork {
        private final Class<? extends LuceneWork> workType;
        private final Serializable id;
        private final Class<?> entityType;

        public DuplicatableWork(LuceneWork work) {
            this.workType = work.getClass();
            if (!AddLuceneWork.class.isAssignableFrom(this.workType) && !DeleteLuceneWork.class.isAssignableFrom(this.workType)) {
                throw new AssertionFailure("Should not be used for lucene work type: " + this.workType);
            }
            this.id = work.getId();
            this.entityType = work.getEntityClass();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DuplicatableWork that = (DuplicatableWork)o;
            if (!this.entityType.equals(that.entityType)) {
                return false;
            }
            if (!this.id.equals(that.id)) {
                return false;
            }
            return this.workType.equals(that.workType);
        }

        public int hashCode() {
            int result = this.workType.hashCode();
            result = 31 * result + this.id.hashCode();
            result = 31 * result + this.entityType.hashCode();
            return result;
        }
    }
}

