/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.tcp;

import fr.dyade.aaa.common.Debug;
import java.net.ConnectException;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.tcp.TcpRequestChannel;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class TcpConnectionFactory
extends ConnectionFactory {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Debug.getLogger((String)TcpConnectionFactory.class.getName());

    public TcpConnectionFactory() {
    }

    private TcpConnectionFactory(String host, int port) {
        super(host, port);
    }

    protected RequestChannel createRequestChannel(FactoryParameters params, Identity identity, String reliableClass) throws JMSException {
        return new TcpRequestChannel(params, identity, reliableClass);
    }

    public static ConnectionFactory create() throws ConnectException {
        return TcpConnectionFactory.create(TcpConnectionFactory.getDefaultServerHost(), TcpConnectionFactory.getDefaultServerPort());
    }

    public static ConnectionFactory create(String host, int port) {
        return TcpConnectionFactory.create(host, port, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient");
    }

    public static ConnectionFactory create(String host, int port, String reliableClass) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("TcpConnectionFactory.create(" + host + ',' + port + ',' + reliableClass + ')'));
        }
        TcpConnectionFactory cf = new TcpConnectionFactory(host, port);
        cf.setReliableClass(reliableClass);
        return cf;
    }
}

