/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.IOException;
import javax.net.ssl.SSLException;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.remote.FtpOperations;
import org.apache.camel.component.file.remote.FtpsConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPSClient;

public class FtpsOperations
extends FtpOperations {
    public FtpsOperations(FTPSClient client, FTPClientConfig clientConfig) {
        super((FTPClient)client, clientConfig);
    }

    public boolean connect(RemoteFileConfiguration configuration) throws GenericFileOperationFailedException {
        boolean answer = super.connect(configuration);
        FtpsConfiguration config = (FtpsConfiguration)configuration;
        if (answer) {
            try {
                String execProt = config.getExecProt();
                Long execPbsz = config.getExecPbsz();
                if (!config.isDisableSecureDataChannelDefaults()) {
                    if (ObjectHelper.isEmpty((Object)execProt)) {
                        execProt = "P";
                    }
                    if (ObjectHelper.isEmpty((Object)execPbsz)) {
                        execPbsz = 0L;
                    }
                }
                if (execPbsz != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("FTPClient initializing with execPbsz=" + execPbsz));
                    }
                    this.getFtpClient().execPBSZ(execPbsz.longValue());
                }
                if (execProt != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("FTPClient initializing with execProt=" + execProt));
                    }
                    this.getFtpClient().execPROT(execProt);
                }
            }
            catch (SSLException e) {
                throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
            }
        }
        return answer;
    }

    protected FTPSClient getFtpClient() {
        return (FTPSClient)super.getFtpClient();
    }
}

