/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.i18n;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.bouncycastle.i18n.MissingEntryException;
import org.bouncycastle.i18n.filter.Filter;
import org.bouncycastle.i18n.filter.UntrustedInput;

public class LocalizedMessage {
    protected final String id;
    protected final String resource;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected String encoding = "ISO-8859-1";
    protected Object[] arguments;
    protected Object[] filteredArguments;
    protected Filter filter = null;
    protected ClassLoader loader = null;

    public LocalizedMessage(String string, String string2) throws NullPointerException {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = new Object[0];
        this.filteredArguments = this.arguments;
    }

    public LocalizedMessage(String string, String string2, String string3) throws NullPointerException, UnsupportedEncodingException {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = new Object[0];
        this.filteredArguments = this.arguments;
        if (!Charset.isSupported(string3)) {
            throw new UnsupportedEncodingException("The encoding \"" + string3 + "\" is not supported.");
        }
        this.encoding = string3;
    }

    public LocalizedMessage(String string, String string2, Object[] objectArray) throws NullPointerException {
        if (string == null || string2 == null || objectArray == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = objectArray;
        this.filteredArguments = objectArray;
    }

    public LocalizedMessage(String string, String string2, String string3, Object[] objectArray) throws NullPointerException, UnsupportedEncodingException {
        if (string == null || string2 == null || objectArray == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = objectArray;
        this.filteredArguments = objectArray;
        if (!Charset.isSupported(string3)) {
            throw new UnsupportedEncodingException("The encoding \"" + string3 + "\" is not supported.");
        }
        this.encoding = string3;
    }

    public String getEntry(String string, Locale locale, TimeZone timeZone) throws MissingEntryException {
        String string2 = this.id + "." + string;
        try {
            ResourceBundle resourceBundle = this.loader == null ? ResourceBundle.getBundle(this.resource, locale) : ResourceBundle.getBundle(this.resource, locale, this.loader);
            String string3 = resourceBundle.getString(string2);
            if (!this.encoding.equals(DEFAULT_ENCODING)) {
                string3 = new String(string3.getBytes(DEFAULT_ENCODING), this.encoding);
            }
            if (this.arguments == null || this.arguments.length == 0) {
                return string3;
            }
            return this.formatWithTimeZone(string3, this.filteredArguments, locale, timeZone);
        }
        catch (MissingResourceException missingResourceException) {
            throw new MissingEntryException("Can't find entry " + string2 + " in resource file " + this.resource + ".", this.resource, string2, locale, this.loader != null ? this.loader : this.getClassLoader());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    protected String formatWithTimeZone(String string, Object[] objectArray, Locale locale, TimeZone timeZone) {
        MessageFormat messageFormat = new MessageFormat(" ");
        messageFormat.setLocale(locale);
        messageFormat.applyPattern(string);
        if (!timeZone.equals(TimeZone.getDefault())) {
            Format[] formatArray = messageFormat.getFormats();
            for (int i = 0; i < formatArray.length; ++i) {
                if (!(formatArray[i] instanceof DateFormat)) continue;
                DateFormat dateFormat = (DateFormat)formatArray[i];
                dateFormat.setTimeZone(timeZone);
                messageFormat.setFormat(i, dateFormat);
            }
        }
        return messageFormat.format(objectArray);
    }

    public void setFilter(Filter filter) {
        if (filter == null) {
            this.filteredArguments = this.arguments;
        } else if (!filter.equals(this.filter)) {
            this.filteredArguments = new Object[this.arguments.length];
            for (int i = 0; i < this.arguments.length; ++i) {
                this.filteredArguments[i] = this.arguments[i] instanceof UntrustedInput ? filter.doFilter(((UntrustedInput)this.arguments[i]).getString()) : this.arguments[i];
            }
        }
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getId() {
        return this.id;
    }

    public String getResource() {
        return this.resource;
    }

    public Object[] getArguments() {
        return this.arguments;
    }
}

