/*
 * Decompiled with CFR 0.152.
 */
package wssec;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PrivilegedAccessor {
    public static Object getValue(Object instance, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = PrivilegedAccessor.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    public static void setValue(Object instance, String fieldName, Object value) throws IllegalAccessException, NoSuchFieldException {
        Field field = PrivilegedAccessor.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        field.set(instance, value);
    }

    public static Object invokeMethod(Object instance, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return PrivilegedAccessor.invokeMethod(instance, methodName, args);
    }

    public static Object invokeMethod(Object instance, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] classTypes = null;
        if (args != null) {
            classTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                classTypes[i] = args[i].getClass();
            }
        }
        return PrivilegedAccessor.getMethod(instance, methodName, classTypes).invoke(instance, args);
    }

    public static Method getMethod(Object instance, String methodName, Class[] classTypes) throws NoSuchMethodException {
        Method accessMethod = PrivilegedAccessor.getMethod(instance.getClass(), methodName, classTypes);
        accessMethod.setAccessible(true);
        return accessMethod;
    }

    private static Field getField(Class thisClass, String fieldName) throws NoSuchFieldException {
        if (thisClass == null) {
            throw new NoSuchFieldException("Invalid field : " + fieldName);
        }
        try {
            return thisClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return PrivilegedAccessor.getField(thisClass.getSuperclass(), fieldName);
        }
    }

    private static Method getMethod(Class thisClass, String methodName, Class[] classTypes) throws NoSuchMethodException {
        if (thisClass == null) {
            throw new NoSuchMethodException("Invalid method : " + methodName);
        }
        try {
            return thisClass.getDeclaredMethod(methodName, classTypes);
        }
        catch (NoSuchMethodException e) {
            return PrivilegedAccessor.getMethod(thisClass.getSuperclass(), methodName, classTypes);
        }
    }
}

