/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.stream.impl.delegator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.ow2.util.stream.impl.delegator.DelegatorStreamAccessor;

public class DelegatorOutputStream
extends FileOutputStream {
    private DelegatorStreamAccessor delegatorFileAccessor;
    private File temporaryFile;

    public DelegatorOutputStream(DelegatorStreamAccessor delegatorFileAccessor, File file, boolean temporary) throws FileNotFoundException {
        super(file);
        if (temporary) {
            this.temporaryFile = file;
        }
    }

    public void flush() throws IOException {
        super.flush();
        if (this.temporaryFile == null) {
            this.delegatorFileAccessor.doWrite();
        }
    }

    public void close() throws IOException {
        super.flush();
        super.close();
        if (this.temporaryFile != null) {
            this.delegatorFileAccessor.doWrite(this.temporaryFile);
        } else {
            this.delegatorFileAccessor.doWrite();
        }
    }

    protected void finalize() {
        if (this.temporaryFile != null) {
            this.temporaryFile.delete();
        }
    }
}

