/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.datasource.lib;

import org.objectweb.medor.api.EvaluationException;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.datasource.api.Wrapper;
import org.objectweb.medor.eval.api.EvaluationMetaData;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.TCQueryLeaf;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.medor.tuple.lib.MemoryTuple;

public class TCWrapper
implements Wrapper {
    public TupleCollection fetchData(QueryLeaf ql, ParameterOperand[] parameters, Object conn, EvaluationMetaData evalmd) throws EvaluationException {
        return new FilteredTC((TCQueryLeaf)ql, parameters);
    }

    public long deleteData(QueryLeaf ql, ParameterOperand[] parameters, Object connection, EvaluationMetaData evalmd) throws EvaluationException {
        throw new EvaluationException("deleteData operation not impleted on TCWrapper");
    }

    public long updateData(QueryLeaf ql, ParameterOperand[] parameters, Object connection, EvaluationMetaData evalmd) throws EvaluationException {
        throw new EvaluationException("updateData operation not impleted on TCWrapper");
    }

    class FilteredTC
    implements TupleCollection {
        private TCQueryLeaf tcQueryLeaf;
        private Expression filter;
        private TupleCollection subTupleCollection;
        private ParameterOperand[] parameters;
        private Tuple tupleBuffer1;
        private Tuple tupleBuffer2;
        private VariableOperand[] operandBuffer1;
        private VariableOperand[] operandBuffer2;
        private int cursor;
        private boolean empty;
        private boolean isTheLast = false;
        private boolean isBuffer2Free = false;
        Operand filterResult;
        private boolean closed = false;

        public FilteredTC(TCQueryLeaf tcQueryLeaf, ParameterOperand[] parameters) throws EvaluationException {
            this.tcQueryLeaf = tcQueryLeaf;
            this.parameters = parameters;
            this.filter = tcQueryLeaf.getQueryFilter();
            try {
                this.filterResult = this.filter.compileExpression();
            }
            catch (ExpressionException e) {
                throw new EvaluationException(e);
            }
            try {
                this.operandBuffer1 = new BasicVariableOperand[tcQueryLeaf.getTupleStructure().getSize()];
                this.operandBuffer2 = new BasicVariableOperand[tcQueryLeaf.getTupleStructure().getSize()];
                for (int cpt = 0; cpt < tcQueryLeaf.getTupleStructure().getSize(); ++cpt) {
                    this.operandBuffer1[cpt] = new BasicVariableOperand(tcQueryLeaf.getTupleStructure().getField(cpt + 1).getType());
                    this.operandBuffer2[cpt] = new BasicVariableOperand(tcQueryLeaf.getTupleStructure().getField(cpt + 1).getType());
                }
                this.tupleBuffer1 = new MemoryTuple(this.operandBuffer1);
                this.tupleBuffer2 = new MemoryTuple(this.operandBuffer2);
                this.subTupleCollection = tcQueryLeaf.getTupleCollection();
                this.empty = this.subTupleCollection.isEmpty();
                if (this.empty) {
                    this.cursor = 0;
                } else {
                    this.init();
                }
            }
            catch (MedorException mexp) {
                throw new EvaluationException(mexp);
            }
        }

        public void close() throws MedorException {
            this.closed = true;
        }

        public TupleStructure getMetaData() throws MedorException {
            return this.tcQueryLeaf.getTupleStructure();
        }

        public boolean isLast() throws MedorException {
            return this.isTheLast;
        }

        public int card() throws MedorException {
            return this.cursor;
        }

        public boolean next() throws MedorException {
            Tuple currentTuple = null;
            boolean moved = false;
            if (this.isEmpty() || this.cursor == -2) {
                moved = false;
            } else if (this.isLast()) {
                this.cursor = -2;
                moved = false;
            } else {
                try {
                    moved = true;
                    ++this.cursor;
                    do {
                        if (this.subTupleCollection.next()) {
                            currentTuple = this.subTupleCollection.getTuple();
                            this.filter.evaluate(this.parameters, currentTuple);
                            continue;
                        }
                        this.isTheLast = true;
                    } while (!this.isTheLast && !this.filterResult.getBoolean());
                    if (!this.isTheLast) {
                        if (this.isBuffer2Free) {
                            this.tcQueryLeaf.getTupleLoader().loadTuple(currentTuple, this.operandBuffer2, this.parameters);
                            this.isBuffer2Free = false;
                        } else {
                            this.tcQueryLeaf.getTupleLoader().loadTuple(currentTuple, this.operandBuffer1, this.parameters);
                            this.isBuffer2Free = true;
                        }
                    } else {
                        this.isBuffer2Free = !this.isBuffer2Free;
                    }
                }
                catch (ExpressionException e) {
                    throw new MedorException(e);
                }
            }
            return moved;
        }

        private boolean init() throws MedorException {
            this.isTheLast = false;
            this.isBuffer2Free = false;
            this.subTupleCollection.first();
            Tuple currentTuple = this.subTupleCollection.getTuple();
            try {
                this.filter.evaluate(this.parameters, currentTuple);
                while (!this.empty && !this.filterResult.getBoolean()) {
                    if (this.subTupleCollection.next()) {
                        currentTuple = this.subTupleCollection.getTuple();
                        this.filter.evaluate(this.parameters, currentTuple);
                        continue;
                    }
                    this.empty = true;
                }
                if (this.empty) {
                    this.cursor = -2;
                } else {
                    this.tcQueryLeaf.getTupleLoader().loadTuple(currentTuple, this.operandBuffer1, this.parameters);
                    this.cursor = 1;
                    do {
                        if (this.subTupleCollection.next()) {
                            currentTuple = this.subTupleCollection.getTuple();
                            this.filter.evaluate(this.parameters, currentTuple);
                            continue;
                        }
                        this.isTheLast = true;
                    } while (!this.isTheLast && !this.filterResult.getBoolean());
                    if (!this.isTheLast) {
                        this.tcQueryLeaf.getTupleLoader().loadTuple(currentTuple, this.operandBuffer2, this.parameters);
                    }
                }
            }
            catch (ExpressionException e) {
                throw new MedorException(e);
            }
            return !this.empty;
        }

        public void first() throws MedorException {
            this.init();
        }

        public int getRow() throws MedorException {
            return this.cursor;
        }

        public Tuple getTuple() throws MedorException {
            if (!this.isEmpty() && this.getRow() >= 1) {
                if (this.isBuffer2Free) {
                    return this.tupleBuffer2;
                }
                return this.tupleBuffer1;
            }
            throw new MedorException(" No elements fetched in this TupleCollection");
        }

        public synchronized Tuple getTuple(int numTuple) throws MedorException {
            this.row(numTuple);
            return this.getTuple();
        }

        public boolean isEmpty() throws MedorException {
            return this.empty;
        }

        public boolean row(int numTuple) throws MedorException {
            this.first();
            int cpt = 1;
            boolean stop = false;
            while (cpt < numTuple && !stop) {
                if (!this.next()) {
                    stop = true;
                    continue;
                }
                ++cpt;
            }
            if (cpt < numTuple) {
                return false;
            }
            this.cursor = numTuple;
            return true;
        }
    }
}

