/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.persistence.concurrency;

import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.perseus.cache.api.CacheEntry;
import org.objectweb.perseus.concurrency.api.ConcurrencyException;
import org.objectweb.perseus.concurrency.api.ConcurrencyManager;
import org.objectweb.perseus.persistence.api.PersistenceException;
import org.objectweb.perseus.persistence.api.State;
import org.objectweb.perseus.persistence.api.StateManager;
import org.objectweb.perseus.persistence.api.StorageManager;
import org.objectweb.perseus.persistence.api.WorkingSet;
import org.objectweb.perseus.persistence.concurrency.NoDSIConcurrencyException;
import org.objectweb.perseus.persistence.concurrency.PConcurrencyManager;
import org.objectweb.util.monolog.api.Logger;

public class PDbDelegateConcurrencyManager
implements PConcurrencyManager,
BindingController,
LifeCycleController {
    private String componentState = "STOPPED";
    protected Logger logger = null;
    protected StateManager stateManager;
    protected StorageManager storageManager;

    public String[] listFc() {
        return new String[]{"storage-manager", "state-manager"};
    }

    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if ("storage-manager".equals(s)) {
            return this.storageManager;
        }
        if ("state-manager".equals(s)) {
            return this.stateManager;
        }
        throw new NoSuchInterfaceException(s);
    }

    public void bindFc(String s, Object o) throws NoSuchInterfaceException, IllegalBindingException {
        if ("storage-manager".equals(s)) {
            this.storageManager = (StorageManager)o;
        } else if ("state-manager".equals(s)) {
            this.stateManager = (StateManager)o;
        } else {
            throw new NoSuchInterfaceException(s);
        }
    }

    public void unbindFc(String s) throws NoSuchInterfaceException {
        if ("storage-manager".equals(s)) {
            this.storageManager = null;
        } else if ("state-manager".equals(s)) {
            this.stateManager = null;
        } else {
            throw new NoSuchInterfaceException(s);
        }
    }

    public void finalize(Object ctx) {
    }

    public String getFcState() {
        return this.componentState;
    }

    public void startFc() throws IllegalLifeCycleException {
        if (this.componentState == "STARTED") {
            return;
        }
        this.componentState = "STARTED";
    }

    public void stopFc() throws IllegalLifeCycleException {
        if (this.componentState == "STOPPED") {
            return;
        }
        this.componentState = "STOPPED";
    }

    public void begin(Object ctx) {
    }

    public boolean validate(Object ctx) {
        return true;
    }

    public Object readIntention(Object ctx, Object resourceId, Object hints, ConcurrencyManager.ResourceProvider resProv, Object resourceHints) throws ConcurrencyException {
        return this.accessIntention(ctx, resourceId, hints, false, resProv, resourceHints);
    }

    public Object writeIntention(Object ctx, Object resourceId, Object hints, ConcurrencyManager.ResourceProvider resProv, Object resourceHints) throws ConcurrencyException {
        return this.accessIntention(ctx, resourceId, hints, true, resProv, resourceHints);
    }

    public void abort(Object ctx) {
    }

    protected Object accessIntention(Object ctx, Object resourceid, Object thinLock, boolean isWrite, ConcurrencyManager.ResourceProvider resProv, Object resourceHints) throws ConcurrencyException {
        CacheEntry ce = (CacheEntry)resourceHints;
        WorkingSet ws = (WorkingSet)ctx;
        if (resProv == null) {
            return null;
        }
        return this.load(ws, resourceid, ce, isWrite);
    }

    private State load(WorkingSet ws, Object resourceId, CacheEntry ce, boolean isWrite) throws ConcurrencyException {
        State state = this.stateManager.createState(ce);
        try {
            this.storageManager.read(ws, resourceId, state, isWrite);
            this.stateManager.makeClean(state);
        }
        catch (PersistenceException e) {
            this.stateManager.destroyState(state);
            throw new NoDSIConcurrencyException(e);
        }
        return state;
    }
}

