/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.lang.reflect.Field;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;
import org.eclipse.persistence.mappings.structures.ReferenceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingularAttributeImpl<X, T>
extends AttributeImpl<X, T>
implements SingularAttribute<X, T> {
    private static final long serialVersionUID = 3928292425281232234L;
    protected Type<T> elementType;

    protected SingularAttributeImpl(ManagedTypeImpl<X> managedType, DatabaseMapping mapping) {
        this(managedType, mapping, false);
    }

    protected SingularAttributeImpl(ManagedTypeImpl<X> managedType, DatabaseMapping mapping, boolean validationEnabled) {
        super(managedType, mapping);
        Class attributeClass = mapping.getAttributeClassification();
        if (null == attributeClass) {
            if (mapping.isOneToOneMapping()) {
                attributeClass = ((OneToOneMapping)mapping).getReferenceClass();
            } else if (mapping.isDirectToFieldMapping()) {
                attributeClass = mapping.getField().getType();
                if (null == attributeClass) {
                    attributeClass = managedType.getTypeClassFromAttributeOrMethodLevelAccessor(mapping);
                }
            } else if (mapping.isAggregateObjectMapping()) {
                attributeClass = ((AggregateMapping)mapping).getReferenceClass();
            } else if (mapping.isVariableOneToOneMapping()) {
                if (validationEnabled) {
                    AbstractSessionLog.getLog().log(1, "metamodel_mapping_type_is_unsupported", mapping, this);
                }
                attributeClass = ((VariableOneToOneMapping)mapping).getReferenceClass();
            } else if (mapping.isEISMapping() || mapping.isTransformationMapping()) {
                if (validationEnabled) {
                    AbstractSessionLog.getLog().log(1, "metamodel_mapping_type_is_unsupported", mapping, this);
                }
            } else if (mapping.isReferenceMapping()) {
                if (validationEnabled) {
                    AbstractSessionLog.getLog().log(1, "metamodel_mapping_type_is_unsupported", mapping, this);
                }
                attributeClass = ((ReferenceMapping)mapping).getReferenceClass();
            }
        }
        if (null == attributeClass && validationEnabled) {
            attributeClass = MetamodelImpl.DEFAULT_ELEMENT_TYPE_FOR_UNSUPPORTED_MAPPINGS;
            AbstractSessionLog.getLog().log(1, "metamodel_attribute_class_type_is_null", this);
        }
        this.elementType = this.getMetamodel().getType(attributeClass);
    }

    public Class<T> getBindableJavaType() {
        return this.elementType.getJavaType();
    }

    public boolean isId() {
        if (this.getManagedTypeImpl().isMappedSuperclass()) {
            return this.getDescriptor().getPrimaryKeyFields().contains(this.getMapping().getField());
        }
        return this.getMapping().isPrimaryKeyMapping() || this.getMapping().isJPAId();
    }

    public boolean isOptional() {
        return this.getMapping().isOptional();
    }

    @Override
    public boolean isPlural() {
        return false;
    }

    public boolean isVersion() {
        if (this.getDescriptor().usesOptimisticLocking() && this.getMapping().isDirectToFieldMapping()) {
            OptimisticLockingPolicy policy = this.getDescriptor().getOptimisticLockingPolicy();
            return policy.getWriteLockField().equals(((DirectToFieldMapping)this.getMapping()).getField());
        }
        return false;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.SINGULAR_ATTRIBUTE;
    }

    @Override
    public Class<T> getJavaType() {
        if (null == this.elementType) {
            Class<?> aJavaType;
            block4: {
                aJavaType = this.getMapping().getAttributeClassification();
                if (null == aJavaType && null == (aJavaType = this.getMapping().getField().getType())) {
                    Class containingClass = this.getMapping().getDescriptor().getJavaClass();
                    Field aField = null;
                    try {
                        aField = containingClass.getDeclaredField(this.getMapping().getAttributeName());
                        aJavaType = aField.getType();
                        return aJavaType;
                    }
                    catch (NoSuchFieldException nsfe) {
                        if (null != aJavaType) break block4;
                        AbstractSessionLog.getLog().log(1, "metamodel_attribute_class_type_is_null", this);
                        return MetamodelImpl.DEFAULT_ELEMENT_TYPE_FOR_UNSUPPORTED_MAPPINGS;
                    }
                }
            }
            return aJavaType;
        }
        return this.elementType.getJavaType();
    }

    public Type<T> getType() {
        return this.elementType;
    }

    public String toString() {
        return "SingularAttributeImpl[" + this.getMapping() + "]";
    }
}

