/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.conversion.Base64;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.AttachmentHelper;
import org.eclipse.persistence.internal.xr.Invocation;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.ValueObject;
import org.eclipse.persistence.internal.xr.XRDynamicEntity_CollectionWrapper;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatModel;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLFragmentCollectionMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryOperation
extends Operation {
    protected Result result;
    protected QueryHandler queryHandler;
    protected boolean userDefined = true;

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public QueryHandler getQueryHandler() {
        return this.queryHandler;
    }

    public void setQueryHandler(QueryHandler queryHandler) {
        this.queryHandler = queryHandler;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }

    @Override
    public boolean isCollection() {
        return this.result.isCollection();
    }

    public boolean isSimpleXMLFormat() {
        return this.result != null && this.result.getSimpleXMLFormat() != null;
    }

    public boolean isAttachment() {
        return this.result != null && this.result.getAttachment() != null;
    }

    public QName getResultType() {
        if (this.result != null) {
            return this.result.getType();
        }
        return null;
    }

    @Override
    public boolean hasResponse() {
        return this.result != null;
    }

    @Override
    public void validate(XRServiceAdapter xrService) {
        QName resultType;
        super.validate(xrService);
        QName qName = resultType = this.result == null ? null : this.result.getType();
        if (resultType != null && !resultType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            boolean sxf;
            boolean bl = sxf = resultType.getLocalPart().equals("simple-xml-format") || resultType.getLocalPart().equals("cursor of simple-xml-format");
            if (!sxf && !xrService.descriptorsByQName.containsKey(resultType)) {
                throw DBWSException.resultHasNoMapping(resultType.toString(), this.name);
            }
        }
        if (this.queryHandler != null) {
            this.queryHandler.validate(xrService, this);
        }
    }

    @Override
    public void initialize(XRServiceAdapter xrService) {
        DatabaseQuery dq;
        super.initialize(xrService);
        if (this.queryHandler == null && (dq = xrService.getORSession().getQuery(this.name)) != null) {
            this.queryHandler = new QueryHandler(){

                public void initializeDatabaseQuery(XRServiceAdapter xrService, QueryOperation queryOperation) {
                }

                public void initializeArguments(XRServiceAdapter xrService, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
                }

                public void initializeCall(XRServiceAdapter xrService, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
                }
            };
            this.queryHandler.setDatabaseQuery(dq);
        }
        if (this.queryHandler == null) {
            throw DBWSException.couldNotLocateQueryForSession(this.name, xrService.getORSession().getName());
        }
        this.queryHandler.initialize(xrService, this);
        Session oxSession = xrService.getOXSession();
        QName resultType = this.result == null ? null : this.result.getType();
        this.addSimpleXMLFormatModelDescriptor(xrService);
        this.addValueObjectDescriptor(xrService);
        if (resultType == null && this.isAttachment()) {
            Attachment attachment = this.result.getAttachment();
            XMLDescriptor descriptor = (XMLDescriptor)oxSession.getProject().getClassDescriptor(DataHandler.class);
            if (descriptor == null) {
                descriptor = new XMLDescriptor();
                descriptor.setAlias("DataHandler");
                descriptor.setJavaClass(DataHandler.class);
                descriptor.setInstantiationPolicy(new DataHandlerInstantiationPolicy(attachment.getMimeType()));
                XMLBinaryDataMapping mapping = new XMLBinaryDataMapping();
                mapping.setAttributeName("results");
                mapping.setAttributeAccessor(new AttributeAccessor(){

                    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
                        Object result = null;
                        DataHandler dataHandler = (DataHandler)object;
                        try {
                            result = dataHandler.getContent();
                            if (result instanceof InputStream) {
                                InputStream is = (InputStream)result;
                                byte[] buf = new byte[2048];
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                int bytesRead = is.read(buf);
                                while (bytesRead >= 0) {
                                    baos.write(buf, 0, bytesRead);
                                    bytesRead = is.read(buf);
                                }
                                result = baos.toByteArray();
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return result;
                    }

                    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
                    }
                });
                mapping.setXPath("simple-xml-format/simple-xml/attachment");
                mapping.setSwaRef(true);
                mapping.setShouldInlineBinaryData(false);
                mapping.setMimeType(attachment.getMimeType());
                descriptor.addMapping(mapping);
                NamespaceResolver nr = new NamespaceResolver();
                descriptor.setNamespaceResolver(nr);
                oxSession.getProject().addDescriptor(descriptor);
                ((DatabaseSessionImpl)oxSession).initializeDescriptorIfSessionAlive(descriptor);
                xrService.getXMLContext().storeXMLDescriptorByQName(descriptor);
            }
        }
    }

    protected void addValueObjectDescriptor(XRServiceAdapter xrService) {
        Session oxSession = xrService.getOXSession();
        XMLDescriptor descriptor = (XMLDescriptor)oxSession.getProject().getClassDescriptor(ValueObject.class);
        if (descriptor == null) {
            descriptor = new XMLDescriptor();
            descriptor.setAlias("ValueObject");
            descriptor.setJavaClass(ValueObject.class);
            XMLDirectMapping mapping = new XMLDirectMapping();
            mapping.setAttributeName("value");
            mapping.setXPath("value");
            descriptor.addMapping(mapping);
            NamespaceResolver nr = new NamespaceResolver();
            descriptor.setNamespaceResolver(nr);
            oxSession.getProject().addDescriptor(descriptor);
            ((DatabaseSessionImpl)oxSession).initializeDescriptorIfSessionAlive(descriptor);
            xrService.getXMLContext().storeXMLDescriptorByQName(descriptor);
        }
    }

    protected void addSimpleXMLFormatModelDescriptor(XRServiceAdapter xrService) {
        Session oxSession;
        XMLDescriptor simpleXMLFormatDescriptor;
        if (this.isSimpleXMLFormat() && (simpleXMLFormatDescriptor = (XMLDescriptor)(oxSession = xrService.getOXSession()).getProject().getClassDescriptor(SimpleXMLFormatModel.class)) == null) {
            simpleXMLFormatDescriptor = new XMLDescriptor();
            simpleXMLFormatDescriptor.setJavaClass(SimpleXMLFormatModel.class);
            simpleXMLFormatDescriptor.setAlias("simple-xml-format");
            simpleXMLFormatDescriptor.setDefaultRootElement("simple-xml-format");
            XMLFragmentCollectionMapping xmlTag = new XMLFragmentCollectionMapping();
            xmlTag.setAttributeName("simpleXML");
            xmlTag.setXPath("simple-xml");
            simpleXMLFormatDescriptor.addMapping(xmlTag);
            NamespaceResolver nr = new NamespaceResolver();
            simpleXMLFormatDescriptor.setNamespaceResolver(nr);
            XMLSchemaURLReference schemaReference = new XMLSchemaURLReference("");
            schemaReference.setSchemaContext("/any");
            schemaReference.setType(1);
            simpleXMLFormatDescriptor.setSchemaReference(schemaReference);
            oxSession.getProject().addDescriptor(simpleXMLFormatDescriptor);
            ((DatabaseSessionImpl)oxSession).initializeDescriptorIfSessionAlive(simpleXMLFormatDescriptor);
            xrService.getXMLContext().storeXMLDescriptorByQName(simpleXMLFormatDescriptor);
        }
    }

    @Override
    public Object invoke(XRServiceAdapter xrService, Invocation invocation) {
        DatabaseQuery query = this.queryHandler.getDatabaseQuery();
        List<String> queryArguments = query.getArguments();
        int queryArgumentsSize = queryArguments.size();
        NonSynchronizedVector executeArguments = new NonSynchronizedVector();
        for (int i = 0; i < queryArgumentsSize; ++i) {
            String argName = queryArguments.get(i);
            ((Vector)executeArguments).add(invocation.getParameter(argName));
        }
        Object value = xrService.getORSession().getActiveSession().executeQuery(query, (List)executeArguments);
        if (value != null) {
            if (this.isSimpleXMLFormat()) {
                value = this.createSimpleXMLFormat(xrService, value);
            } else {
                QName resultType = this.getResultType();
                if (this.isAttachment() || !this.isCollection() && resultType.equals(XMLConstants.BASE_64_BINARY_QNAME)) {
                    String mimeType = "application/octet-stream";
                    if (this.isAttachment() && this.result.getAttachment().getMimeType() != null) {
                        mimeType = this.result.getAttachment().getMimeType();
                    }
                    return AttachmentHelper.buildAttachmentHandler((byte[])value, mimeType);
                }
                if (resultType != null) {
                    if (resultType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        ValueObject vo = new ValueObject();
                        vo.value = value;
                        value = vo;
                    } else {
                        Object targetObject = value;
                        if (xrService.descriptorsByQName.containsKey(resultType)) {
                            XMLDescriptor xdesc = xrService.descriptorsByQName.get(resultType);
                            ClassDescriptor desc = xrService.getORSession().getDescriptorForAlias(xdesc.getAlias());
                            if (desc.isAggregateDescriptor() && !desc.isObjectRelationalDataTypeDescriptor()) {
                                if (this.isCollection()) {
                                    XRDynamicEntity_CollectionWrapper xrCollWrapper = new XRDynamicEntity_CollectionWrapper();
                                    Vector results = (Vector)value;
                                    int len = results.size();
                                    for (int i = 0; i < len; ++i) {
                                        Object o = desc.getObjectBuilder().buildNewInstance();
                                        this.populateTargetObjectFromRecord(desc.getMappings(), (AbstractRecord)results.get(i), o, (AbstractSession)xrService.getORSession());
                                        xrCollWrapper.add(o);
                                    }
                                    targetObject = xrCollWrapper;
                                } else {
                                    targetObject = desc.getObjectBuilder().buildNewInstance();
                                    this.populateTargetObjectFromRecord(desc.getMappings(), (AbstractRecord)((Vector)value).get(0), targetObject, (AbstractSession)xrService.getORSession());
                                }
                            }
                        }
                        value = targetObject;
                    }
                }
            }
        }
        return value;
    }

    protected void populateTargetObjectFromRecord(Vector<DatabaseMapping> mappings, AbstractRecord record, Object targetObject, AbstractSession session) {
        for (DatabaseMapping dm : mappings) {
            dm.readFromRowIntoObject(record, null, targetObject, null, session);
        }
    }

    public Object createSimpleXMLFormat(XRServiceAdapter xrService, Object value) {
        XMLRoot xmlRoot = new XMLRoot();
        SimpleXMLFormat simpleXMLFormat = this.result.getSimpleXMLFormat();
        String tempSimpleXMLFormatTag = "simple-xml-format";
        String simpleXMLFormatTag = simpleXMLFormat.getSimpleXMLFormatTag();
        if (simpleXMLFormatTag != null && !"".equals(simpleXMLFormatTag)) {
            tempSimpleXMLFormatTag = simpleXMLFormatTag;
        }
        xmlRoot.setLocalName(tempSimpleXMLFormatTag);
        String tempXMLTag = "simple-xml";
        String xmlTag = simpleXMLFormat.getXMLTag();
        if (xmlTag != null && !"".equals(xmlTag)) {
            tempXMLTag = xmlTag;
        }
        Vector<DatabaseRecord> records = null;
        if (value instanceof Vector) {
            records = (Vector<DatabaseRecord>)value;
        } else {
            records = new Vector<DatabaseRecord>();
            DatabaseRecord dr = new DatabaseRecord();
            dr.add(new DatabaseField("result"), value);
            records.add(dr);
        }
        SimpleXMLFormatModel simpleXMLFormatModel = new SimpleXMLFormatModel();
        XMLConversionManager conversionManager = (XMLConversionManager)xrService.getOXSession().getDatasourcePlatform().getConversionManager();
        for (DatabaseRecord dr : records) {
            Element rowElement = Util.TEMP_DOC.createElement(tempXMLTag);
            for (DatabaseField field : dr.getFields()) {
                Object fieldValue = dr.get(field);
                if (fieldValue == null) continue;
                if (fieldValue instanceof Calendar) {
                    Calendar cValue = (Calendar)fieldValue;
                    fieldValue = conversionManager.convertObject(cValue, ClassConstants.STRING, XMLConstants.DATE_TIME_QNAME);
                }
                if (fieldValue instanceof Date) {
                    Date dValue = (Date)fieldValue;
                    fieldValue = conversionManager.convertObject(dValue, ClassConstants.STRING, XMLConstants.DATE_QNAME);
                } else if (fieldValue instanceof Time) {
                    Time tValue = (Time)fieldValue;
                    fieldValue = conversionManager.convertObject(tValue, ClassConstants.STRING, XMLConstants.TIME_QNAME);
                } else if (fieldValue instanceof Timestamp) {
                    Timestamp tsValue = (Timestamp)fieldValue;
                    fieldValue = conversionManager.convertObject(tsValue, ClassConstants.STRING, XMLConstants.DATE_TIME_QNAME);
                }
                String elementName = Util.sqlToXmlName(field.getName());
                Element columnElement = Util.TEMP_DOC.createElement(elementName);
                rowElement.appendChild(columnElement);
                String fieldValueString = fieldValue.toString();
                if (this.result.getType().equals(XMLConstants.BASE_64_BINARY_QNAME)) {
                    fieldValueString = Helper.buildHexStringFromBytes(Base64.base64Encode((byte[])fieldValue));
                    columnElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
                    columnElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    columnElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:base64Binary");
                }
                columnElement.appendChild(Util.TEMP_DOC.createTextNode(fieldValueString));
            }
            simpleXMLFormatModel.simpleXML.add(rowElement);
        }
        xmlRoot.setObject(simpleXMLFormatModel);
        return xmlRoot;
    }

    public class DataHandlerInstantiationPolicy
    extends InstantiationPolicy {
        protected String mimeType;

        public DataHandlerInstantiationPolicy(String mimeType) {
            this.mimeType = mimeType;
        }

        public Object buildNewInstance() throws DescriptorException {
            return new DataHandler(null, this.mimeType);
        }
    }
}

