/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.SuspendableService;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.spi.ShutdownAware;

public class DirectConsumer
extends DefaultConsumer
implements ShutdownAware,
SuspendableService {
    private DirectEndpoint endpoint;

    public DirectConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = (DirectEndpoint)endpoint;
    }

    protected void doStart() throws Exception {
        boolean existing;
        boolean bl = existing = this == this.endpoint.getConsumer();
        if (!existing && this.endpoint.hasConsumer(this)) {
            throw new IllegalArgumentException("Cannot add a 2nd consumer to the same endpoint. Endpoint " + this.endpoint + " only allows one consumer.");
        }
        if (!existing) {
            this.endpoint.addConsumer(this);
        }
    }

    protected void doStop() throws Exception {
        this.endpoint.removeConsumer(this);
    }

    protected void doSuspend() throws Exception {
        this.endpoint.removeConsumer(this);
    }

    protected void doResume() throws Exception {
        this.doStart();
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    public int getPendingExchangesSize() {
        return 0;
    }

    public void prepareShutdown() {
    }
}

