/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFileRenameExclusiveReadLockStrategy<T>
implements GenericFileExclusiveReadLockStrategy<T> {
    private static final transient Log LOG = LogFactory.getLog(GenericFileRenameExclusiveReadLockStrategy.class);
    private long timeout;
    private long checkInterval;

    @Override
    public void prepareOnStartup(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint) throws Exception {
    }

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<T> operations, GenericFile<T> file, Exchange exchange) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Waiting for exclusive read lock to file: " + file));
        }
        String newName = file.getFileName() + ".camelExclusiveReadLock";
        GenericFile<T> newFile = file.copyFrom(file);
        newFile.changeFileName(newName);
        StopWatch watch = new StopWatch();
        boolean exclusive = false;
        while (!exclusive) {
            long delta;
            if (this.timeout > 0L && (delta = watch.taken()) > this.timeout) {
                LOG.warn((Object)("Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + file));
                return false;
            }
            exclusive = operations.renameFile(file.getAbsoluteFilePath(), newFile.getAbsoluteFilePath());
            if (exclusive) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Acquired exclusive read lock to file: " + file));
                }
                operations.renameFile(newFile.getAbsoluteFilePath(), file.getAbsoluteFilePath());
                continue;
            }
            boolean interrupted = this.sleep();
            if (!interrupted) continue;
            return false;
        }
        return true;
    }

    @Override
    public void releaseExclusiveReadLock(GenericFileOperations<T> operations, GenericFile<T> file, Exchange exchange) throws Exception {
    }

    private boolean sleep() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Exclusive read lock not granted. Sleeping for " + this.checkInterval + " millis."));
        }
        try {
            Thread.sleep(this.checkInterval);
            return false;
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"Sleep interrupted while waiting for exclusive read lock, so breaking out");
            return true;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }
}

