/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.component.language.LanguageEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageComponent
extends DefaultComponent {
    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String name = ObjectHelper.before(remaining, ":");
        String script = ObjectHelper.after(remaining, ":");
        if (name == null && script == null) {
            name = remaining;
        }
        if (ObjectHelper.isEmpty(name)) {
            throw new IllegalArgumentException("Illegal syntax. Name of language not given in uri: " + uri);
        }
        Language language = this.getCamelContext().resolveLanguage(name);
        Expression expression = null;
        if (ObjectHelper.isNotEmpty(script)) {
            expression = language.createExpression(script);
        }
        return new LanguageEndpoint(uri, this, language, expression);
    }
}

