/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.Predicate;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.language.bean.BeanExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="method")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MethodCallExpression
extends ExpressionDefinition {
    @XmlAttribute(required=false)
    @Deprecated
    private String bean;
    @XmlAttribute(required=false)
    private String ref;
    @XmlAttribute(required=false)
    private String method;
    @XmlAttribute(required=false)
    private Class<?> beanType;
    @XmlTransient
    private Object instance;

    public MethodCallExpression() {
    }

    public MethodCallExpression(String beanName) {
        this(beanName, null);
    }

    public MethodCallExpression(String beanName, String method) {
        super(beanName);
        this.method = method;
    }

    public MethodCallExpression(Object instance) {
        this(instance, null);
    }

    public MethodCallExpression(Object instance, String method) {
        super(instance.getClass().getName());
        this.instance = instance;
        this.method = method;
    }

    public MethodCallExpression(Class<?> type) {
        this(type, null);
    }

    public MethodCallExpression(Class<?> type, String method) {
        super(type.toString());
        this.beanType = type;
        this.method = method;
    }

    @Override
    public String getLanguage() {
        return "bean";
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public Expression createExpression(CamelContext camelContext) {
        BeanExpression answer;
        if (this.beanType != null) {
            this.instance = ObjectHelper.newInstance(this.beanType);
            answer = new BeanExpression(this.instance, this.getMethod());
        } else if (this.instance != null) {
            answer = new BeanExpression(this.instance, this.getMethod());
        } else {
            String ref = this.beanName();
            RegistryBean holder = new RegistryBean(camelContext, ref);
            this.instance = holder.getBean();
            answer = new BeanExpression(ref, this.getMethod());
        }
        this.validateHasMethod(camelContext, this.instance, this.getMethod());
        return answer;
    }

    @Override
    public Predicate createPredicate(CamelContext camelContext) {
        return (BeanExpression)this.createExpression(camelContext);
    }

    protected void validateHasMethod(CamelContext context, Object bean, String method) {
        if (method == null) {
            return;
        }
        if (OgnlHelper.isValidOgnlExpression(method)) {
            return;
        }
        if (OgnlHelper.isInvalidValidOgnlExpression(method)) {
            ExpressionIllegalSyntaxException cause = new ExpressionIllegalSyntaxException(method);
            throw ObjectHelper.wrapRuntimeCamelException(new MethodNotFoundException(bean, method, (Throwable)cause));
        }
        BeanInfo info = new BeanInfo(context, bean.getClass());
        if (!info.hasMethod(method)) {
            throw ObjectHelper.wrapRuntimeCamelException(new MethodNotFoundException(null, bean, method));
        }
    }

    protected String beanName() {
        if (this.bean != null) {
            return this.bean;
        }
        if (this.ref != null) {
            return this.ref;
        }
        if (this.instance != null) {
            return ObjectHelper.className(this.instance);
        }
        return this.getExpression();
    }

    @Override
    public String toString() {
        return "bean{" + this.beanName() + (this.method != null ? ", method=" + this.method : "") + "}";
    }
}

