/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.File;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Poll;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.res.StringManager;

public class AprEndpoint {
    protected static Log log = LogFactory.getLog(AprEndpoint.class);
    protected static StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.res");
    public static final String CIPHER_SUITE_KEY = "javax.servlet.request.cipher_suite";
    public static final String KEY_SIZE_KEY = "javax.servlet.request.key_size";
    public static final String CERTIFICATE_KEY = "javax.servlet.request.X509Certificate";
    public static final String SESSION_ID_KEY = "javax.servlet.request.ssl_session";
    protected WorkerStack workers = null;
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected boolean initialized = false;
    protected int curThreadsBusy = 0;
    protected int curThreads = 0;
    protected int sequence = 0;
    protected long rootPool = 0L;
    protected long serverSock = 0L;
    protected long serverSockPool = 0L;
    protected long sslContext = 0L;
    private Acceptor[] acceptors = null;
    protected boolean deferAccept = true;
    protected Executor executor = null;
    protected int maxThreads = 200;
    protected int threadPriority = 5;
    protected int pollerSize = 8192;
    protected int sendfileSize = 1024;
    protected int port;
    protected InetAddress address;
    protected Handler handler = null;
    protected int backlog = 100;
    protected boolean tcpNoDelay = false;
    protected int soLinger = 100;
    protected int soTimeout = -1;
    protected int keepAliveTimeout = -1;
    protected int pollTime = 2000;
    protected boolean daemon = true;
    protected String name = "TP";
    protected boolean useSendfile = Library.APR_HAS_SENDFILE;
    protected boolean useComet = true;
    protected int acceptorThreadCount = 0;
    protected int sendfileThreadCount = 0;
    protected int pollerThreadCount = 0;
    protected Poller[] pollers = null;
    protected int pollerRoundRobin = 0;
    protected Poller[] cometPollers = null;
    protected int cometPollerRoundRobin = 0;
    protected Sendfile[] sendfiles = null;
    protected int sendfileRoundRobin = 0;
    protected int unlockTimeout = 250;
    protected boolean SSLEnabled = false;
    protected String SSLProtocol = "all";
    protected String SSLPassword = null;
    protected String SSLCipherSuite = "ALL";
    protected String SSLCertificateFile = null;
    protected String SSLCertificateKeyFile = null;
    protected String SSLCertificateChainFile = null;
    protected String SSLCACertificatePath = null;
    protected String SSLCACertificateFile = null;
    protected String SSLCARevocationPath = null;
    protected String SSLCARevocationFile = null;
    protected String SSLVerifyClient = "none";
    protected int SSLVerifyDepth = 10;

    public void setDeferAccept(boolean deferAccept) {
        this.deferAccept = deferAccept;
    }

    public boolean getDeferAccept() {
        return this.deferAccept;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        if (this.running) {
            WorkerStack workerStack = this.workers;
            synchronized (workerStack) {
                this.workers.resize(maxThreads);
            }
        }
    }

    public int getMaxThreads() {
        if (this.executor != null) {
            return -1;
        }
        return this.maxThreads;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setPollerSize(int pollerSize) {
        this.pollerSize = pollerSize;
    }

    public int getPollerSize() {
        return this.pollerSize;
    }

    public void setSendfileSize(int sendfileSize) {
        this.sendfileSize = sendfileSize;
    }

    public int getSendfileSize() {
        return this.sendfileSize;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public int getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(int pollTime) {
        if (pollTime > 0) {
            this.pollTime = pollTime;
        }
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public void setUseComet(boolean useComet) {
        this.useComet = useComet;
    }

    public boolean getUseComet() {
        return this.useComet;
    }

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setSendfileThreadCount(int sendfileThreadCount) {
        this.sendfileThreadCount = sendfileThreadCount;
    }

    public int getSendfileThreadCount() {
        return this.sendfileThreadCount;
    }

    public void setPollerThreadCount(int pollerThreadCount) {
        this.pollerThreadCount = pollerThreadCount;
    }

    public int getPollerThreadCount() {
        return this.pollerThreadCount;
    }

    public Poller getPoller() {
        this.pollerRoundRobin = (this.pollerRoundRobin + 1) % this.pollers.length;
        return this.pollers[this.pollerRoundRobin];
    }

    public Poller getCometPoller() {
        this.cometPollerRoundRobin = (this.cometPollerRoundRobin + 1) % this.cometPollers.length;
        return this.cometPollers[this.cometPollerRoundRobin];
    }

    public Sendfile getSendfile() {
        this.sendfileRoundRobin = (this.sendfileRoundRobin + 1) % this.sendfiles.length;
        return this.sendfiles[this.sendfileRoundRobin];
    }

    public int getMaxSpareThreads() {
        return 0;
    }

    public int getMinSpareThreads() {
        return 0;
    }

    public int getUnlockTimeout() {
        return this.unlockTimeout;
    }

    public void setUnlockTimeout(int unlockTimeout) {
        this.unlockTimeout = unlockTimeout;
    }

    public boolean isSSLEnabled() {
        return this.SSLEnabled;
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.SSLEnabled = SSLEnabled;
    }

    public String getSSLProtocol() {
        return this.SSLProtocol;
    }

    public void setSSLProtocol(String SSLProtocol) {
        this.SSLProtocol = SSLProtocol;
    }

    public String getSSLPassword() {
        return this.SSLPassword;
    }

    public void setSSLPassword(String SSLPassword) {
        this.SSLPassword = SSLPassword;
    }

    public String getSSLCipherSuite() {
        return this.SSLCipherSuite;
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        this.SSLCipherSuite = SSLCipherSuite;
    }

    public String getSSLCertificateFile() {
        return this.SSLCertificateFile;
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        this.SSLCertificateFile = SSLCertificateFile;
    }

    public String getSSLCertificateKeyFile() {
        return this.SSLCertificateKeyFile;
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        this.SSLCertificateKeyFile = SSLCertificateKeyFile;
    }

    public String getSSLCertificateChainFile() {
        return this.SSLCertificateChainFile;
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        this.SSLCertificateChainFile = SSLCertificateChainFile;
    }

    public String getSSLCACertificatePath() {
        return this.SSLCACertificatePath;
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        this.SSLCACertificatePath = SSLCACertificatePath;
    }

    public String getSSLCACertificateFile() {
        return this.SSLCACertificateFile;
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        this.SSLCACertificateFile = SSLCACertificateFile;
    }

    public String getSSLCARevocationPath() {
        return this.SSLCARevocationPath;
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        this.SSLCARevocationPath = SSLCARevocationPath;
    }

    public String getSSLCARevocationFile() {
        return this.SSLCARevocationFile;
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        this.SSLCARevocationFile = SSLCARevocationFile;
    }

    public String getSSLVerifyClient() {
        return this.SSLVerifyClient;
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        this.SSLVerifyClient = SSLVerifyClient;
    }

    public int getSSLVerifyDepth() {
        return this.SSLVerifyDepth;
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        this.SSLVerifyDepth = SSLVerifyDepth;
    }

    public int getKeepAliveCount() {
        if (this.pollers == null) {
            return 0;
        }
        int keepAliveCount = 0;
        for (int i = 0; i < this.pollers.length; ++i) {
            keepAliveCount += this.pollers[i].getKeepAliveCount();
        }
        return keepAliveCount;
    }

    public int getSendfileCount() {
        if (this.sendfiles == null) {
            return 0;
        }
        int sendfileCount = 0;
        for (int i = 0; i < this.sendfiles.length; ++i) {
            sendfileCount += this.sendfiles[i].getSendfileCount();
        }
        return sendfileCount;
    }

    public int getCurrentThreadCount() {
        if (this.executor != null) {
            return -1;
        }
        return this.curThreads;
    }

    public int getCurrentThreadsBusy() {
        if (this.executor != null) {
            return -1;
        }
        return this.workers != null ? this.curThreads - this.workers.size() : 0;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        this.rootPool = Pool.create(0L);
        this.serverSockPool = Pool.create(this.rootPool);
        String addressStr = null;
        addressStr = this.address == null ? null : this.address.getHostAddress();
        int family = 1;
        if (Library.APR_HAVE_IPV6) {
            if (addressStr == null) {
                if (!(OS.IS_BSD || OS.IS_WIN32 || OS.IS_WIN64)) {
                    family = 0;
                }
            } else if (addressStr.indexOf(58) >= 0) {
                family = 0;
            }
        }
        long inetAddress = Address.info(addressStr, family, this.port, 0, this.rootPool);
        this.serverSock = Socket.create(Address.getInfo((long)inetAddress).family, 0, 6, this.rootPool);
        if (OS.IS_UNIX) {
            Socket.optSet(this.serverSock, 16, 1);
        }
        Socket.optSet(this.serverSock, 2, 1);
        int ret = Socket.bind(this.serverSock, inetAddress);
        if (ret != 0) {
            throw new Exception(sm.getString("endpoint.init.bind", "" + ret, Error.strerror(ret)));
        }
        ret = Socket.listen(this.serverSock, this.backlog);
        if (ret != 0) {
            throw new Exception(sm.getString("endpoint.init.listen", "" + ret, Error.strerror(ret)));
        }
        if (OS.IS_WIN32 || OS.IS_WIN64) {
            Socket.optSet(this.serverSock, 16, 1);
        }
        if (this.useSendfile && !Library.APR_HAS_SENDFILE) {
            this.useSendfile = false;
        }
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.pollerThreadCount == 0) {
            if ((OS.IS_WIN32 || OS.IS_WIN64) && this.pollerSize > 1024) {
                this.pollerThreadCount = this.pollerSize / 1024;
                this.pollerSize -= this.pollerSize % 1024;
            } else {
                this.pollerThreadCount = 1;
            }
        }
        if (this.sendfileThreadCount == 0) {
            if ((OS.IS_WIN32 || OS.IS_WIN64) && this.sendfileSize > 1024) {
                this.sendfileThreadCount = this.sendfileSize / 1024;
                this.sendfileSize -= this.sendfileSize % 1024;
            } else {
                this.sendfileThreadCount = 1;
            }
        }
        if (this.deferAccept && Socket.optSet(this.serverSock, 32768, 1) == 70023) {
            this.deferAccept = false;
        }
        if (this.SSLEnabled) {
            int value = 7;
            if ("SSLv2".equalsIgnoreCase(this.SSLProtocol)) {
                value = 1;
            } else if ("SSLv3".equalsIgnoreCase(this.SSLProtocol)) {
                value = 2;
            } else if ("TLSv1".equalsIgnoreCase(this.SSLProtocol)) {
                value = 4;
            } else if ("SSLv2+SSLv3".equalsIgnoreCase(this.SSLProtocol)) {
                value = 3;
            } else if (!"all".equalsIgnoreCase(this.SSLProtocol) && this.SSLProtocol != null && this.SSLProtocol.length() != 0) {
                throw new Exception(sm.getString("endpoint.apr.invalidSslProtocol", this.SSLProtocol));
            }
            this.sslContext = SSLContext.make(this.rootPool, value, 1);
            SSLContext.setCipherSuite(this.sslContext, this.SSLCipherSuite);
            SSLContext.setCertificate(this.sslContext, this.SSLCertificateFile, this.SSLCertificateKeyFile, this.SSLPassword, 0);
            SSLContext.setCertificateChainFile(this.sslContext, this.SSLCertificateChainFile, false);
            SSLContext.setCACertificate(this.sslContext, this.SSLCACertificateFile, this.SSLCACertificatePath);
            SSLContext.setCARevocation(this.sslContext, this.SSLCARevocationFile, this.SSLCARevocationPath);
            value = 0;
            if ("optional".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 1;
            } else if ("require".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 2;
            } else if ("optionalNoCA".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 3;
            }
            SSLContext.setVerify(this.sslContext, value, this.SSLVerifyDepth);
            this.useSendfile = false;
        }
        this.initialized = true;
    }

    public void start() throws Exception {
        if (!this.initialized) {
            this.init();
        }
        if (!this.running) {
            int i;
            this.running = true;
            this.paused = false;
            if (this.executor == null) {
                this.workers = new WorkerStack(this.maxThreads);
            }
            this.pollers = new Poller[this.pollerThreadCount];
            for (i = 0; i < this.pollerThreadCount; ++i) {
                this.pollers[i] = new Poller(false);
                this.pollers[i].init();
                this.pollers[i].setName(this.getName() + "-Poller-" + i);
                this.pollers[i].setPriority(this.threadPriority);
                this.pollers[i].setDaemon(true);
                this.pollers[i].start();
            }
            this.cometPollers = new Poller[this.pollerThreadCount];
            for (i = 0; i < this.pollerThreadCount; ++i) {
                this.cometPollers[i] = new Poller(true);
                this.cometPollers[i].init();
                this.cometPollers[i].setName(this.getName() + "-CometPoller-" + i);
                this.cometPollers[i].setPriority(this.threadPriority);
                this.cometPollers[i].setDaemon(true);
                this.cometPollers[i].start();
            }
            if (this.useSendfile) {
                this.sendfiles = new Sendfile[this.sendfileThreadCount];
                for (i = 0; i < this.sendfileThreadCount; ++i) {
                    this.sendfiles[i] = new Sendfile();
                    this.sendfiles[i].init();
                    this.sendfiles[i].setName(this.getName() + "-Sendfile-" + i);
                    this.sendfiles[i].setPriority(this.threadPriority);
                    this.sendfiles[i].setDaemon(true);
                    this.sendfiles[i].start();
                }
            }
            this.acceptors = new Acceptor[this.acceptorThreadCount];
            for (i = 0; i < this.acceptorThreadCount; ++i) {
                this.acceptors[i] = new Acceptor();
                this.acceptors[i].setName(this.getName() + "-Acceptor-" + i);
                this.acceptors[i].setPriority(this.threadPriority);
                this.acceptors[i].setDaemon(this.getDaemon());
                this.acceptors[i].start();
            }
        }
    }

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public void stop() {
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            int i;
            this.running = false;
            this.unlockAccept();
            for (i = 0; i < this.acceptors.length; ++i) {
                long s = System.currentTimeMillis() + 10000L;
                while (this.acceptors[i].isAlive() && this.serverSock != 0L) {
                    try {
                        this.acceptors[i].interrupt();
                        this.acceptors[i].join(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < s) continue;
                    log.warn(sm.getString("endpoint.warn.unlockAcceptorFailed", this.acceptors[i].getName()));
                    if (this.serverSock == 0L) continue;
                    Socket.shutdown(this.serverSock, 0);
                    this.serverSock = 0L;
                }
            }
            for (i = 0; i < this.pollers.length; ++i) {
                try {
                    this.pollers[i].destroy();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.pollers = null;
            for (i = 0; i < this.cometPollers.length; ++i) {
                try {
                    this.cometPollers[i].destroy();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.cometPollers = null;
            if (this.useSendfile) {
                for (i = 0; i < this.sendfiles.length; ++i) {
                    try {
                        this.sendfiles[i].destroy();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.sendfiles = null;
            }
        }
    }

    public void destroy() throws Exception {
        if (this.running) {
            this.stop();
        }
        if (this.serverSockPool != 0L) {
            Pool.destroy(this.serverSockPool);
            this.serverSockPool = 0L;
        }
        if (this.serverSock != 0L) {
            Socket.close(this.serverSock);
            this.serverSock = 0L;
        }
        this.sslContext = 0L;
        if (this.rootPool != 0L) {
            Pool.destroy(this.rootPool);
            this.rootPool = 0L;
        }
        this.initialized = false;
    }

    protected int getSequence() {
        return this.sequence++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void unlockAccept() {
        java.net.Socket s;
        block10: {
            s = null;
            InetSocketAddress saddr = null;
            saddr = this.address == null ? new InetSocketAddress("localhost", this.port) : new InetSocketAddress(this.address, this.port);
            s = new java.net.Socket();
            s.setSoTimeout(this.soTimeout > 0 ? this.soTimeout : 60000);
            s.setSoLinger(true, 0);
            if (log.isDebugEnabled()) {
                log.debug("About to unlock socket for: " + saddr);
            }
            s.connect(saddr, this.unlockTimeout);
            if (!this.deferAccept) break block10;
            OutputStreamWriter sw = new OutputStreamWriter(s.getOutputStream(), "ISO-8859-1");
            sw.write("OPTIONS * HTTP/1.0\r\nUser-Agent: Tomcat wakeup connection\r\n\r\n");
            sw.flush();
        }
        Object var5_5 = null;
        if (s == null) return;
        try {
            s.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("endpoint.debug.unlock", "" + this.port), e);
                }
                Object var5_6 = null;
                if (s == null) return;
                try {
                    s.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean setSocketOptions(long socket) {
        int step = 1;
        try {
            if (this.soLinger >= 0) {
                Socket.optSet(socket, 1, this.soLinger);
            }
            if (this.tcpNoDelay) {
                Socket.optSet(socket, 512, this.tcpNoDelay ? 1 : 0);
            }
            if (this.soTimeout > 0) {
                Socket.timeoutSet(socket, this.soTimeout * 1000);
            }
            step = 2;
            if (this.sslContext != 0L) {
                SSLSocket.attach(this.sslContext, socket);
                if (SSLSocket.handshake(socket) != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("endpoint.err.handshake") + ": " + SSL.getLastError());
                    }
                    return false;
                }
            }
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                if (step == 2) {
                    log.debug(sm.getString("endpoint.err.handshake"), t);
                } else {
                    log.debug(sm.getString("endpoint.err.unexpected"), t);
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker createWorkerThread() {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            if (this.workers.size() > 0) {
                ++this.curThreadsBusy;
                return this.workers.pop();
            }
            if (this.maxThreads > 0 && this.curThreads < this.maxThreads) {
                ++this.curThreadsBusy;
                if (this.curThreadsBusy == this.maxThreads) {
                    log.info(sm.getString("endpoint.info.maxThreads", Integer.toString(this.maxThreads), this.address, Integer.toString(this.port)));
                }
                return this.newWorkerThread();
            }
            if (this.maxThreads < 0) {
                ++this.curThreadsBusy;
                return this.newWorkerThread();
            }
            return null;
        }
    }

    protected Worker newWorkerThread() {
        Worker workerThread = new Worker();
        workerThread.start();
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker getWorkerThread() {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            Worker workerThread;
            while ((workerThread = this.createWorkerThread()) == null) {
                try {
                    this.workers.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return workerThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleWorkerThread(Worker workerThread) {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            this.workers.push(workerThread);
            --this.curThreadsBusy;
            this.workers.notify();
        }
    }

    protected long allocatePoller(int size, long pool, int timeout) {
        try {
            return Poll.create(size, pool, 0, timeout * 1000);
        }
        catch (Error e) {
            if (Status.APR_STATUS_IS_EINVAL(e.getError())) {
                log.info(sm.getString("endpoint.poll.limitedpollsize", "" + size));
                return 0L;
            }
            log.error(sm.getString("endpoint.poll.initfail"), e);
            return -1L;
        }
    }

    protected boolean processSocketWithOptions(long socket) {
        try {
            if (this.executor == null) {
                this.getWorkerThread().assignWithOptions(socket);
            } else {
                this.executor.execute(new SocketWithOptionsProcessor(socket));
            }
        }
        catch (Throwable t) {
            log.error(sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    protected boolean processSocket(long socket) {
        try {
            if (this.executor == null) {
                this.getWorkerThread().assign(socket);
            } else {
                this.executor.execute(new SocketProcessor(socket));
            }
        }
        catch (Throwable t) {
            log.error(sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    protected boolean processSocket(long socket, SocketStatus status) {
        try {
            if (this.executor == null) {
                this.getWorkerThread().assign(socket, status);
            } else {
                this.executor.execute(new SocketEventProcessor(socket, status));
            }
        }
        catch (Throwable t) {
            log.error(sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    private void destroySocket(long socket) {
        if (this.running && socket != 0L) {
            Socket.destroy(socket);
        }
    }

    protected class SocketEventProcessor
    implements Runnable {
        protected long socket = 0L;
        protected SocketStatus status = null;

        public SocketEventProcessor(long socket, SocketStatus status) {
            this.socket = socket;
            this.status = status;
        }

        public void run() {
            if (AprEndpoint.this.handler.event(this.socket, this.status) == Handler.SocketState.CLOSED) {
                AprEndpoint.this.destroySocket(this.socket);
                this.socket = 0L;
            }
        }
    }

    protected class SocketProcessor
    implements Runnable {
        protected long socket = 0L;

        public SocketProcessor(long socket) {
            this.socket = socket;
        }

        public void run() {
            if (AprEndpoint.this.handler.process(this.socket) == Handler.SocketState.CLOSED) {
                AprEndpoint.this.destroySocket(this.socket);
                this.socket = 0L;
            }
        }
    }

    protected class SocketWithOptionsProcessor
    implements Runnable {
        protected long socket = 0L;

        public SocketWithOptionsProcessor(long socket) {
            this.socket = socket;
        }

        public void run() {
            if (!AprEndpoint.this.deferAccept) {
                if (AprEndpoint.this.setSocketOptions(this.socket)) {
                    AprEndpoint.this.getPoller().add(this.socket);
                } else {
                    AprEndpoint.this.destroySocket(this.socket);
                    this.socket = 0L;
                }
            } else if (!AprEndpoint.this.setSocketOptions(this.socket) || AprEndpoint.this.handler.process(this.socket) == Handler.SocketState.CLOSED) {
                AprEndpoint.this.destroySocket(this.socket);
                this.socket = 0L;
            }
        }
    }

    public class WorkerStack {
        protected Worker[] workers = null;
        protected int end = 0;

        public WorkerStack(int size) {
            this.workers = new Worker[size];
        }

        public void push(Worker worker) {
            if (this.end < this.workers.length) {
                this.workers[this.end++] = worker;
            } else {
                --AprEndpoint.this.curThreads;
            }
        }

        public Worker pop() {
            if (this.end > 0) {
                return this.workers[--this.end];
            }
            return null;
        }

        public Worker peek() {
            return this.workers[this.end];
        }

        public boolean isEmpty() {
            return this.end == 0;
        }

        public int size() {
            return this.end;
        }

        public void resize(int newSize) {
            Worker[] newWorkers = new Worker[newSize];
            int len = this.workers.length;
            if (newSize < len) {
                len = newSize;
            }
            System.arraycopy(this.workers, 0, newWorkers, 0, len);
            this.workers = newWorkers;
        }
    }

    public static interface Handler {
        public SocketState process(long var1);

        public SocketState event(long var1, SocketStatus var3);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SocketState {
            OPEN,
            CLOSED,
            LONG;

        }
    }

    public class Sendfile
    extends Thread {
        protected long sendfilePollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected HashMap<Long, SendfileData> sendfileData;
        protected volatile int sendfileCount;
        protected ArrayList<SendfileData> addS;
        protected volatile int addCount;

        public int getSendfileCount() {
            return this.sendfileCount;
        }

        protected void init() {
            this.pool = Pool.create(AprEndpoint.this.serverSockPool);
            int size = AprEndpoint.this.sendfileSize / AprEndpoint.this.sendfileThreadCount;
            this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.soTimeout);
            if (this.sendfilePollset == 0L && size > 1024) {
                size = 1024;
                this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.soTimeout);
            }
            if (this.sendfilePollset == 0L) {
                size = 62;
                this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.soTimeout);
            }
            this.desc = new long[size * 2];
            this.sendfileData = new HashMap(size);
            this.addS = new ArrayList();
            this.addCount = 0;
        }

        public void destroy() {
            this.addCount = 0;
            for (int i = this.addS.size() - 1; i >= 0; --i) {
                SendfileData data = this.addS.get(i);
                AprEndpoint.this.destroySocket(data.socket);
            }
            this.addS.clear();
            int rv = Poll.pollset(this.sendfilePollset, this.desc);
            if (rv > 0) {
                for (int n = 0; n < rv; ++n) {
                    AprEndpoint.this.destroySocket(this.desc[n * 2 + 1]);
                }
            }
            Pool.destroy(this.pool);
            this.sendfileData.clear();
            try {
                while (this.isAlive()) {
                    this.interrupt();
                    this.join(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(SendfileData data) {
            block8: {
                try {
                    data.fdpool = Socket.pool(data.socket);
                    data.fd = File.open(data.fileName, 4129, 0, data.fdpool);
                    data.pos = data.start;
                    Socket.timeoutSet(data.socket, 0L);
                    do {
                        long nw;
                        if ((nw = Socket.sendfilen(data.socket, data.fd, data.pos, data.end - data.pos, 0)) < 0L) {
                            if (-nw != 120002L) {
                                Pool.destroy(data.fdpool);
                                data.socket = 0L;
                                return false;
                            }
                            break block8;
                        }
                        data.pos += nw;
                    } while (data.pos < data.end);
                    Pool.destroy(data.fdpool);
                    Socket.timeoutSet(data.socket, AprEndpoint.this.soTimeout * 1000);
                    return true;
                }
                catch (Exception e) {
                    log.error(sm.getString("endpoint.sendfile.error"), e);
                    return false;
                }
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.addS.add(data);
                ++this.addCount;
                this.notify();
            }
            return false;
        }

        protected void remove(SendfileData data) {
            int rv = Poll.remove(this.sendfilePollset, data.socket);
            if (rv == 0) {
                --this.sendfileCount;
            }
            this.sendfileData.remove(new Long(data.socket));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long maintainTime = 0L;
            while (AprEndpoint.this.running) {
                Sendfile e2;
                while (AprEndpoint.this.paused && AprEndpoint.this.running) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {}
                }
                if (!AprEndpoint.this.running) break;
                if (this.sendfileCount < 1 && this.addCount < 1) {
                    e2 = this;
                    synchronized (e2) {
                        while (this.sendfileCount < 1 && this.addS.size() < 1 && AprEndpoint.this.running) {
                            maintainTime = 0L;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e3) {}
                        }
                    }
                }
                if (!AprEndpoint.this.running) break;
                try {
                    int errn;
                    if (this.addCount > 0) {
                        e2 = this;
                        synchronized (e2) {
                            Object var9_20;
                            int successCount = 0;
                            try {
                                for (int i = this.addS.size() - 1; i >= 0; --i) {
                                    SendfileData data = this.addS.get(i);
                                    int rv = Poll.add(this.sendfilePollset, data.socket, 4);
                                    if (rv == 0) {
                                        this.sendfileData.put(new Long(data.socket), data);
                                        ++successCount;
                                        continue;
                                    }
                                    log.warn(sm.getString("endpoint.sendfile.addfail", "" + rv, Error.strerror(rv)));
                                    AprEndpoint.this.destroySocket(data.socket);
                                }
                                var9_20 = null;
                                this.sendfileCount += successCount;
                                this.addS.clear();
                                this.addCount = 0;
                            }
                            catch (Throwable throwable) {
                                var9_20 = null;
                                this.sendfileCount += successCount;
                                this.addS.clear();
                                this.addCount = 0;
                                throw throwable;
                            }
                        }
                    }
                    maintainTime += (long)AprEndpoint.this.pollTime;
                    int rv = Poll.poll(this.sendfilePollset, AprEndpoint.this.pollTime, this.desc, false);
                    if (rv > 0) {
                        for (int n = 0; n < rv; ++n) {
                            SendfileData state = this.sendfileData.get(new Long(this.desc[n * 2 + 1]));
                            if ((this.desc[n * 2] & 0x20L) == 32L || (this.desc[n * 2] & 0x10L) == 16L) {
                                this.remove(state);
                                AprEndpoint.this.destroySocket(state.socket);
                                continue;
                            }
                            long nw = Socket.sendfilen(state.socket, state.fd, state.pos, state.end - state.pos, 0);
                            if (nw < 0L) {
                                this.remove(state);
                                AprEndpoint.this.destroySocket(state.socket);
                                continue;
                            }
                            state.pos += nw;
                            if (state.pos < state.end) continue;
                            this.remove(state);
                            if (state.keepAlive) {
                                Pool.destroy(state.fdpool);
                                Socket.timeoutSet(state.socket, AprEndpoint.this.soTimeout * 1000);
                                AprEndpoint.this.getPoller().add(state.socket);
                                continue;
                            }
                            AprEndpoint.this.destroySocket(state.socket);
                        }
                    } else if (rv < 0 && (errn = -rv) != 120001 && errn != 120003) {
                        if (errn > 120000) {
                            errn -= 120000;
                        }
                        log.error(sm.getString("endpoint.poll.fail", "" + errn, Error.strerror(errn)));
                        Sendfile state = this;
                        synchronized (state) {
                            this.destroy();
                            this.init();
                            continue;
                        }
                    }
                    if (AprEndpoint.this.soTimeout <= 0 || maintainTime <= 1000000L || !AprEndpoint.this.running) continue;
                    rv = Poll.maintain(this.sendfilePollset, this.desc, true);
                    maintainTime = 0L;
                    if (rv <= 0) continue;
                    for (int n = 0; n < rv; ++n) {
                        SendfileData state = this.sendfileData.get(new Long(this.desc[n]));
                        this.remove(state);
                        AprEndpoint.this.destroySocket(state.socket);
                    }
                }
                catch (Throwable t) {
                    log.error(sm.getString("endpoint.poll.error"), t);
                }
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.notifyAll();
            }
        }
    }

    public static class SendfileData {
        public String fileName;
        public long fd;
        public long fdpool;
        public long start;
        public long end;
        public long socket;
        public long pos;
        public boolean keepAlive;
    }

    protected class Worker
    implements Runnable {
        protected Thread thread = null;
        protected boolean available = false;
        protected long socket = 0L;
        protected SocketStatus status = null;
        protected boolean options = false;

        protected Worker() {
        }

        protected synchronized void assignWithOptions(long socket) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.socket = socket;
            this.status = null;
            this.options = true;
            this.available = true;
            this.notifyAll();
        }

        protected synchronized void assign(long socket) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.socket = socket;
            this.status = null;
            this.options = false;
            this.available = true;
            this.notifyAll();
        }

        protected synchronized void assign(long socket, SocketStatus status) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            this.socket = socket;
            this.status = status;
            this.options = false;
            this.available = true;
            this.notifyAll();
        }

        protected synchronized long await() {
            while (!this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            long socket = this.socket;
            this.available = false;
            this.notifyAll();
            return socket;
        }

        public void run() {
            while (AprEndpoint.this.running) {
                long socket = this.await();
                if (socket == 0L) continue;
                if (!AprEndpoint.this.deferAccept && this.options) {
                    if (AprEndpoint.this.setSocketOptions(socket)) {
                        AprEndpoint.this.getPoller().add(socket);
                    } else {
                        AprEndpoint.this.destroySocket(socket);
                        socket = 0L;
                    }
                } else if (this.status != null && AprEndpoint.this.handler.event(socket, this.status) == Handler.SocketState.CLOSED) {
                    AprEndpoint.this.destroySocket(socket);
                    socket = 0L;
                } else if (this.status == null && (this.options && !AprEndpoint.this.setSocketOptions(socket) || AprEndpoint.this.handler.process(socket) == Handler.SocketState.CLOSED)) {
                    AprEndpoint.this.destroySocket(socket);
                    socket = 0L;
                }
                AprEndpoint.this.recycleWorkerThread(this);
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setName(AprEndpoint.this.getName() + "-" + ++AprEndpoint.this.curThreads);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public class Poller
    extends Thread {
        protected long serverPollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected long[] addS;
        protected volatile int addCount = 0;
        protected boolean comet = true;
        protected volatile int keepAliveCount = 0;

        public int getKeepAliveCount() {
            return this.keepAliveCount;
        }

        public Poller(boolean comet) {
            this.comet = comet;
        }

        protected void init() {
            this.pool = Pool.create(AprEndpoint.this.serverSockPool);
            int size = AprEndpoint.this.pollerSize / AprEndpoint.this.pollerThreadCount;
            int timeout = AprEndpoint.this.keepAliveTimeout;
            if (timeout < 0) {
                timeout = AprEndpoint.this.soTimeout;
            }
            this.serverPollset = AprEndpoint.this.allocatePoller(size, this.pool, timeout);
            if (this.serverPollset == 0L && size > 1024) {
                size = 1024;
                this.serverPollset = AprEndpoint.this.allocatePoller(size, this.pool, timeout);
            }
            if (this.serverPollset == 0L) {
                size = 62;
                this.serverPollset = AprEndpoint.this.allocatePoller(size, this.pool, timeout);
            }
            this.desc = new long[size * 2];
            this.keepAliveCount = 0;
            this.addS = new long[size];
            this.addCount = 0;
        }

        public void destroy() {
            for (int i = 0; i < this.addCount; ++i) {
                if (this.comet) {
                    AprEndpoint.this.processSocket(this.addS[i], SocketStatus.STOP);
                    continue;
                }
                AprEndpoint.this.destroySocket(this.addS[i]);
            }
            int rv = Poll.pollset(this.serverPollset, this.desc);
            if (rv > 0) {
                for (int n = 0; n < rv; ++n) {
                    if (this.comet) {
                        AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.STOP);
                        continue;
                    }
                    AprEndpoint.this.destroySocket(this.desc[n * 2 + 1]);
                }
            }
            Pool.destroy(this.pool);
            this.keepAliveCount = 0;
            this.addCount = 0;
            try {
                while (this.isAlive()) {
                    this.interrupt();
                    this.join(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long socket) {
            Poller poller = this;
            synchronized (poller) {
                if (this.addCount >= this.addS.length) {
                    if (this.comet) {
                        AprEndpoint.this.processSocket(socket, SocketStatus.ERROR);
                    } else {
                        AprEndpoint.this.destroySocket(socket);
                    }
                    return;
                }
                this.addS[this.addCount] = socket;
                ++this.addCount;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long maintainTime = 0L;
            while (AprEndpoint.this.running) {
                Poller e2;
                while (AprEndpoint.this.paused && AprEndpoint.this.running) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {}
                }
                if (!AprEndpoint.this.running) break;
                if (this.keepAliveCount < 1 && this.addCount < 1) {
                    e2 = this;
                    synchronized (e2) {
                        while (this.keepAliveCount < 1 && this.addCount < 1 && AprEndpoint.this.running) {
                            maintainTime = 0L;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e3) {}
                        }
                    }
                }
                if (!AprEndpoint.this.running) break;
                try {
                    int errn;
                    if (this.addCount > 0) {
                        e2 = this;
                        synchronized (e2) {
                            Object var8_16;
                            int successCount = 0;
                            try {
                                for (int i = this.addCount - 1; i >= 0; --i) {
                                    int rv = Poll.add(this.serverPollset, this.addS[i], 1);
                                    if (rv == 0) {
                                        ++successCount;
                                        continue;
                                    }
                                    if (this.comet) {
                                        AprEndpoint.this.processSocket(this.addS[i], SocketStatus.ERROR);
                                        continue;
                                    }
                                    AprEndpoint.this.destroySocket(this.addS[i]);
                                }
                                var8_16 = null;
                                this.keepAliveCount += successCount;
                                this.addCount = 0;
                            }
                            catch (Throwable throwable) {
                                var8_16 = null;
                                this.keepAliveCount += successCount;
                                this.addCount = 0;
                                throw throwable;
                            }
                        }
                    }
                    maintainTime += (long)AprEndpoint.this.pollTime;
                    int rv = Poll.poll(this.serverPollset, AprEndpoint.this.pollTime, this.desc, true);
                    if (rv > 0) {
                        this.keepAliveCount -= rv;
                        for (int n = 0; n < rv; ++n) {
                            if ((this.desc[n * 2] & 0x20L) != 32L && (this.desc[n * 2] & 0x10L) != 16L && (!this.comet || AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.OPEN)) && (this.comet || AprEndpoint.this.processSocket(this.desc[n * 2 + 1]))) continue;
                            if (this.comet) {
                                AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.DISCONNECT);
                                continue;
                            }
                            AprEndpoint.this.destroySocket(this.desc[n * 2 + 1]);
                        }
                    } else if (rv < 0 && (errn = -rv) != 120001 && errn != 120003) {
                        if (errn > 120000) {
                            errn -= 120000;
                        }
                        log.error(sm.getString("endpoint.poll.fail", "" + errn, Error.strerror(errn)));
                        Poller poller = this;
                        synchronized (poller) {
                            this.destroy();
                            this.init();
                            continue;
                        }
                    }
                    if (AprEndpoint.this.soTimeout <= 0 || maintainTime <= 1000000L || !AprEndpoint.this.running) continue;
                    rv = Poll.maintain(this.serverPollset, this.desc, true);
                    maintainTime = 0L;
                    if (rv <= 0) continue;
                    this.keepAliveCount -= rv;
                    for (int n = 0; n < rv; ++n) {
                        if (this.comet) {
                            AprEndpoint.this.processSocket(this.desc[n], SocketStatus.TIMEOUT);
                            continue;
                        }
                        AprEndpoint.this.destroySocket(this.desc[n]);
                    }
                }
                catch (Throwable t) {
                    log.error(sm.getString("endpoint.poll.error"), t);
                }
            }
            Poller poller = this;
            synchronized (poller) {
                this.notifyAll();
            }
        }
    }

    protected class Acceptor
    extends Thread {
        private final Log log = LogFactory.getLog(Acceptor.class);

        protected Acceptor() {
        }

        public void run() {
            while (AprEndpoint.this.running) {
                while (AprEndpoint.this.paused && AprEndpoint.this.running) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                if (!AprEndpoint.this.running) break;
                try {
                    long socket = Socket.accept(AprEndpoint.this.serverSock);
                    if (AprEndpoint.this.deferAccept && (AprEndpoint.this.paused || !AprEndpoint.this.running)) {
                        AprEndpoint.this.destroySocket(socket);
                        continue;
                    }
                    if (AprEndpoint.this.processSocketWithOptions(socket)) continue;
                    AprEndpoint.this.destroySocket(socket);
                }
                catch (Throwable t) {
                    if (!AprEndpoint.this.running) continue;
                    String msg = sm.getString("endpoint.accept.fail");
                    if (t instanceof Error) {
                        Error e = (Error)t;
                        if (e.getError() == 233) {
                            this.log.warn(msg, t);
                            continue;
                        }
                        this.log.error(msg, t);
                        continue;
                    }
                    this.log.error(msg, t);
                }
            }
        }
    }
}

