/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session.singleton;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.Timer;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.EasyBeansSingletonSB;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationBegin;
import org.ow2.easybeans.container.session.JPoolWrapperFactory;
import org.ow2.easybeans.container.session.PoolWrapper;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.event.bean.EventBeanInvocationEnd;
import org.ow2.easybeans.event.bean.EventBeanInvocationError;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.rpc.JEJBResponse;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.enhanced.EnhancedPool;
import org.ow2.util.pool.impl.enhanced.PoolConfiguration;
import org.ow2.util.pool.impl.enhanced.manager.IPoolManager;
import org.ow2.util.pool.impl.enhanced.manager.optional.IPoolItemRemoveManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonSessionFactory
extends SessionFactory<EasyBeansSingletonSB>
implements IPoolItemRemoveManager<EasyBeansSingletonSB> {
    private ReadWriteLock lock = null;

    public SingletonSessionFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
        PoolConfiguration poolConfig = new PoolConfiguration();
        poolConfig.setMax(1);
        poolConfig.setMin(1);
        poolConfig.setSpare(0);
        if (Boolean.getBoolean("easybeans.useSimplePool")) {
            JPool jPool = new JPool(new JPoolWrapperFactory(this));
            jPool.setPoolConfiguration((IPoolConfiguration)poolConfig);
            this.setPool(jPool);
        } else {
            EnhancedPool singletonPool = this.getManagementPool().getEnhancedPoolFactory().createEnhancedPool((IPoolManager)this);
            singletonPool.setPoolConfiguration((IPoolConfiguration)poolConfig);
            this.setPool(new PoolWrapper(singletonPool));
        }
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    protected EasyBeansSingletonSB getBean(Long beanId) throws IllegalArgumentException {
        try {
            return (EasyBeansSingletonSB)this.getPool().get();
        }
        catch (PoolException e) {
            throw new IllegalArgumentException("Cannot get element in the pool", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public EJBResponse localCall(EJBLocalRequest localCallRequest) {
        Object value;
        JEJBResponse ejbResponse;
        block33: {
            Lock writeLock;
            IAuditID previousID;
            long number;
            boolean enabledEvent;
            String methodEventProviderId;
            OperationState oldState;
            String oldInvokedBusinessInterface;
            ClassLoader oldClassLoader;
            EasyBeansSingletonSB bean;
            block31: {
                ejbResponse = new JEJBResponse();
                bean = null;
                try {
                    bean = this.getBean(null);
                }
                catch (IllegalArgumentException e) {
                    ejbResponse.setRPCException(new RPCException("Cannot get element in the pool", (Throwable)e));
                    return ejbResponse;
                }
                catch (NoSuchEJBException e) {
                    ejbResponse.setRPCException(new RPCException("Bean has been removed", (Throwable)e));
                    return ejbResponse;
                }
                Method m = this.getHashes().get(localCallRequest.getMethodHash());
                if (m == null) {
                    ejbResponse.setRPCException(new RPCException("Cannot find method called on the bean '" + this.getClassName() + "'."));
                    return ejbResponse;
                }
                value = null;
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
                oldInvokedBusinessInterface = (String)this.getInvokedBusinessInterfaceNameThreadLocal().get();
                this.getInvokedBusinessInterfaceNameThreadLocal().set(localCallRequest.getInvokedBusinessInterfaceName());
                oldState = this.getOperationState();
                this.getOperationStateThreadLocal().set(OperationState.BUSINESS_METHOD);
                methodEventProviderId = this.getJ2EEManagedObjectId() + "/" + J2EEManagedObjectNamingHelper.getMethodSignature(m) + "@Local";
                enabledEvent = !localCallRequest.isCalledFromRemoteRequest();
                EZBEventBeanInvocationBegin event = null;
                number = 0L;
                previousID = null;
                if (enabledEvent) {
                    if (this.getCurrentInvocationID() != null) {
                        previousID = this.getCurrentInvocationID().newInvocation();
                    }
                    event = this.getInvocationEventBegin(methodEventProviderId, localCallRequest.getMethodArgs());
                    number = event.getInvocationNumber();
                    this.getEventDispatcher().dispatch((IEvent)event);
                }
                writeLock = this.lock.writeLock();
                writeLock.lock();
                value = m.invoke((Object)bean, localCallRequest.getMethodArgs());
                Object var21_17 = null;
                if (!enabledEvent) break block31;
                this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                if (this.getCurrentInvocationID() != null) {
                    this.getCurrentInvocationID().setAuditID(previousID);
                }
            }
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
            this.getOperationStateThreadLocal().set(oldState);
            try {
                this.getPool().release((Object)bean);
            }
            catch (PoolException e2) {
                ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e2));
            }
            writeLock.unlock();
            {
                break block33;
                catch (IllegalArgumentException e) {
                    ejbResponse.setRPCException(new RPCException((Throwable)e));
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                    }
                    Object var21_18 = null;
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                        if (this.getCurrentInvocationID() != null) {
                            this.getCurrentInvocationID().setAuditID(previousID);
                        }
                    }
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                    this.getOperationStateThreadLocal().set(oldState);
                    try {
                        this.getPool().release((Object)bean);
                    }
                    catch (PoolException e2) {
                        ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e2));
                    }
                    writeLock.unlock();
                    break block33;
                }
                catch (IllegalAccessException e) {
                    ejbResponse.setRPCException(new RPCException((Throwable)e));
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                    }
                    Object var21_19 = null;
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                        if (this.getCurrentInvocationID() != null) {
                            this.getCurrentInvocationID().setAuditID(previousID);
                        }
                    }
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                    this.getOperationStateThreadLocal().set(oldState);
                    try {
                        this.getPool().release((Object)bean);
                    }
                    catch (PoolException e2) {
                        ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e2));
                    }
                    writeLock.unlock();
                    break block33;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    RPCException rpcException = new RPCException(cause);
                    ApplicationException applicationException = (ApplicationException)this.getBeanInfo().getApplicationExceptions().get(cause.getClass().getName());
                    if (applicationException != null) {
                        rpcException.setApplicationException();
                    }
                    ejbResponse.setRPCException(rpcException);
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                    }
                    Object var21_20 = null;
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                        if (this.getCurrentInvocationID() != null) {
                            this.getCurrentInvocationID().setAuditID(previousID);
                        }
                    }
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                    this.getOperationStateThreadLocal().set(oldState);
                    try {
                        this.getPool().release((Object)bean);
                    }
                    catch (PoolException e2) {
                        ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e2));
                    }
                    writeLock.unlock();
                }
            }
            catch (Throwable throwable) {
                Object var21_21 = null;
                if (enabledEvent) {
                    this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                    if (this.getCurrentInvocationID() != null) {
                        this.getCurrentInvocationID().setAuditID(previousID);
                    }
                }
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                this.getOperationStateThreadLocal().set(oldState);
                try {
                    this.getPool().release((Object)bean);
                }
                catch (PoolException e2) {
                    ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e2));
                }
                writeLock.unlock();
                throw throwable;
            }
        }
        ejbResponse.setValue(value);
        return ejbResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void start() throws FactoryException {
        super.start();
        EasyBeansSingletonSB bean = null;
        if (!this.getSessionBeanInfo().isStartup()) return;
        try {
            try {
                bean = this.getBean(null);
            }
            catch (RuntimeException e) {
                throw new FactoryException("Cannot initialize Singleton bean", (Throwable)e);
            }
            Object var4_2 = null;
            if (bean == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (bean == null) throw throwable;
            try {
                this.getPool().release((Object)bean);
                throw throwable;
            }
            catch (PoolException e) {
                throw new FactoryException("Cannot release bean", (Throwable)e);
            }
        }
        try {}
        catch (PoolException e) {
            throw new FactoryException("Cannot release bean", (Throwable)e);
        }
        this.getPool().release((Object)bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimeout(Timer timer) {
        EasyBeansSingletonSB bean = null;
        bean = this.getBean(null);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            bean.timeoutCallByEasyBeans(timer);
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            try {
                this.getPool().release((Object)bean);
            }
            catch (PoolException e) {
                throw new EJBException("cannot release bean", (Exception)((Object)e));
            }
            throw throwable;
        }
        try {
            this.getPool().release((Object)bean);
        }
        catch (PoolException e) {
            throw new EJBException("cannot release bean", (Exception)((Object)e));
        }
    }
}

