/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactory;

public class MultiLogFactory
implements LogFactory {
    private List<LogFactory> _delegates;

    public MultiLogFactory(LogFactory d1, LogFactory d2) {
        this(new LogFactory[]{d1, d2});
    }

    public MultiLogFactory(LogFactory d1, LogFactory d2, LogFactory d3) {
        this(new LogFactory[]{d1, d2, d3});
    }

    public MultiLogFactory(LogFactory[] delegates) {
        this._delegates = new CopyOnWriteArrayList<LogFactory>(Arrays.asList(delegates));
    }

    public void addLogFactory(LogFactory factory) {
        this._delegates.add(factory);
    }

    public void removeLogFactory(LogFactory factory) {
        this._delegates.remove(factory);
    }

    public LogFactory[] getDelegates() {
        return this._delegates.toArray(new LogFactory[0]);
    }

    public synchronized Log getLog(String channel) {
        ArrayList<Log> logs = new ArrayList<Log>(this._delegates.size());
        for (LogFactory f : this._delegates) {
            Log l;
            if (f == null || (l = f.getLog(channel)) == null) continue;
            logs.add(l);
        }
        return new MultiLog(logs.toArray(new Log[logs.size()]));
    }

    private static class MultiLog
    implements Log {
        private Log[] _logs;

        public MultiLog(Log[] logs) {
            this._logs = logs;
        }

        public Log[] getDelegates() {
            return this._logs;
        }

        public void trace(Object msg) {
            for (int i = 0; i < this._logs.length; ++i) {
                this._logs[i].trace(msg);
            }
        }

        public void trace(Object msg, Throwable t) {
            for (int i = 0; i < this._logs.length; ++i) {
                this._logs[i].trace(msg, t);
            }
        }

        public void info(Object msg) {
            for (int i = 0; i < this._logs.length; ++i) {
                this._logs[i].info(msg);
            }
        }

        public void info(Object msg, Throwable t) {
            for (int i = 0; i < this._logs.length; ++i) {
                this._logs[i].info(msg, t);
            }
        }

        public void warn(Object msg) {
            for (int i = 0; i < this._logs.length; ++i) {
                this._logs[i].warn(msg);
            }
        }

        public void warn(Object msg, Throwable t) {
            for (int i = 0; i < this._logs.length; ++i) {
                this._logs[i].warn(msg, t);
            }
        }

        public void error(Object msg) {
            for (int i = 0; i < this._logs.length; ++i) {
                this._logs[i].error(msg);
            }
        }

        public void error(Object msg, Throwable t) {
            for (int i = 0; i < this._logs.length; ++i) {
                this._logs[i].error(msg, t);
            }
        }

        public void fatal(Object msg) {
            for (int i = 0; i < this._logs.length; ++i) {
                this._logs[i].fatal(msg);
            }
        }

        public void fatal(Object msg, Throwable t) {
            for (int i = 0; i < this._logs.length; ++i) {
                this._logs[i].fatal(msg, t);
            }
        }

        public boolean isTraceEnabled() {
            for (int i = 0; i < this._logs.length; ++i) {
                if (!this._logs[i].isTraceEnabled()) continue;
                return true;
            }
            return false;
        }

        public boolean isInfoEnabled() {
            for (int i = 0; i < this._logs.length; ++i) {
                if (!this._logs[i].isInfoEnabled()) continue;
                return true;
            }
            return false;
        }

        public boolean isWarnEnabled() {
            for (int i = 0; i < this._logs.length; ++i) {
                if (!this._logs[i].isWarnEnabled()) continue;
                return true;
            }
            return false;
        }

        public boolean isErrorEnabled() {
            for (int i = 0; i < this._logs.length; ++i) {
                if (!this._logs[i].isErrorEnabled()) continue;
                return true;
            }
            return false;
        }

        public boolean isFatalEnabled() {
            for (int i = 0; i < this._logs.length; ++i) {
                if (!this._logs[i].isFatalEnabled()) continue;
                return true;
            }
            return false;
        }
    }
}

