/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.common.Pool;
import java.io.Serializable;

public class Operation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SAVE = 1;
    public static final int CREATE = 4;
    public static final int DELETE = 2;
    public static final int NOOP = 5;
    public static final int COMMIT = 3;
    public static final int END = 127;
    public int type;
    public String dirName;
    public String name;
    public byte[] value;
    public int logidx;
    public int logptr;
    private static Pool pool = null;

    private Operation(int type, String dirName, String name, byte[] value) {
        this.type = type;
        this.dirName = dirName;
        this.name = name;
        this.value = value;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",type=").append(this.type);
        strbuf.append(",dirName=").append(this.dirName);
        strbuf.append(",name=").append(this.name);
        strbuf.append(",logidx=").append(this.logidx);
        strbuf.append(')');
        return strbuf.toString();
    }

    public static void initPool(int LogThresholdOperation) {
        pool = new Pool("Transaction$Operation", LogThresholdOperation);
    }

    public static Operation alloc(int type, String dirName, String name) {
        return Operation.alloc(type, dirName, name, null);
    }

    public static Operation alloc(int type, String dirName, String name, byte[] value) {
        Operation op = null;
        try {
            op = (Operation)pool.allocElement();
        }
        catch (Exception exc) {
            return new Operation(type, dirName, name, value);
        }
        op.type = type;
        op.dirName = dirName;
        op.name = name;
        op.value = value;
        return op;
    }

    public void free() {
        this.dirName = null;
        this.name = null;
        this.value = null;
        pool.freeElement((Object)this);
    }
}

