/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.ServerConfigHelper;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.agent.conf.A3CML;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.agent.conf.A3CMLDomain;
import fr.dyade.aaa.agent.conf.A3CMLNetwork;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.objectweb.joram.mom.dest.AdminTopicMBean;
import org.objectweb.joram.mom.dest.Destination;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.dest.Topic;
import org.objectweb.joram.mom.notifications.AdminReplyNot;
import org.objectweb.joram.mom.notifications.AdminRequestNot;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.ClusterJoinAck;
import org.objectweb.joram.mom.notifications.ClusterJoinNot;
import org.objectweb.joram.mom.notifications.FwdAdminRequestNot;
import org.objectweb.joram.mom.notifications.GetProxyIdListNot;
import org.objectweb.joram.mom.notifications.GetProxyIdNot;
import org.objectweb.joram.mom.notifications.GetRightsReplyNot;
import org.objectweb.joram.mom.notifications.GetRightsRequestNot;
import org.objectweb.joram.mom.notifications.RequestGroupNot;
import org.objectweb.joram.mom.notifications.TopicForwardNot;
import org.objectweb.joram.mom.proxies.AdminNotification;
import org.objectweb.joram.mom.proxies.SendReplyNot;
import org.objectweb.joram.mom.proxies.UserAgent;
import org.objectweb.joram.shared.DestinationConstants;
import org.objectweb.joram.shared.admin.AbstractAdminMessage;
import org.objectweb.joram.shared.admin.AddDomainRequest;
import org.objectweb.joram.shared.admin.AddServerRequest;
import org.objectweb.joram.shared.admin.AdminCommandConstant;
import org.objectweb.joram.shared.admin.AdminCommandReply;
import org.objectweb.joram.shared.admin.AdminCommandRequest;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.CreateDestinationReply;
import org.objectweb.joram.shared.admin.CreateDestinationRequest;
import org.objectweb.joram.shared.admin.CreateUserReply;
import org.objectweb.joram.shared.admin.CreateUserRequest;
import org.objectweb.joram.shared.admin.DeleteDestination;
import org.objectweb.joram.shared.admin.DeleteUser;
import org.objectweb.joram.shared.admin.DestinationAdminRequest;
import org.objectweb.joram.shared.admin.GetConfigRequest;
import org.objectweb.joram.shared.admin.GetDMQSettingsReply;
import org.objectweb.joram.shared.admin.GetDMQSettingsRequest;
import org.objectweb.joram.shared.admin.GetDestinationsReply;
import org.objectweb.joram.shared.admin.GetDestinationsRequest;
import org.objectweb.joram.shared.admin.GetDomainNames;
import org.objectweb.joram.shared.admin.GetDomainNamesRep;
import org.objectweb.joram.shared.admin.GetLocalServer;
import org.objectweb.joram.shared.admin.GetLocalServerRep;
import org.objectweb.joram.shared.admin.GetRightsReply;
import org.objectweb.joram.shared.admin.GetRightsRequest;
import org.objectweb.joram.shared.admin.GetServersIdsReply;
import org.objectweb.joram.shared.admin.GetServersIdsRequest;
import org.objectweb.joram.shared.admin.GetStatsReply;
import org.objectweb.joram.shared.admin.GetStatsRequest;
import org.objectweb.joram.shared.admin.GetUsersReply;
import org.objectweb.joram.shared.admin.GetUsersRequest;
import org.objectweb.joram.shared.admin.RemoveDomainRequest;
import org.objectweb.joram.shared.admin.RemoveServerRequest;
import org.objectweb.joram.shared.admin.SetDMQRequest;
import org.objectweb.joram.shared.admin.SetThresholdRequest;
import org.objectweb.joram.shared.admin.StopServerRequest;
import org.objectweb.joram.shared.admin.UpdateUser;
import org.objectweb.joram.shared.admin.UserAdminRequest;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.messages.MessageHelper;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;

public final class AdminTopic
extends Topic
implements AdminTopicMBean {
    private static final long serialVersionUID = 1L;
    private static AdminTopic ref;
    private int serverId;
    private Map destinationsTable = new Hashtable();
    private Map usersTable = new Hashtable();
    private Map proxiesTable = new Hashtable();
    private Map requestsTable = new Hashtable();
    private long msgCounter = 0L;
    static AgentId adminId;

    public AdminTopic() throws RequestException {
        super("JoramAdminTopic", true, AgentId.JoramAdminStamp);
        this.setAdminId(this.getId());
        this.serverId = AgentServer.getServerId();
    }

    public String toString() {
        return "AdminTopic";
    }

    public static AgentId getDefault(short serverId) {
        return new AgentId(serverId, serverId, AgentId.JoramAdminStamp);
    }

    public static final AgentId getDefault() {
        if (adminId == null) {
            adminId = new AgentId(AgentServer.getServerId(), AgentServer.getServerId(), AgentId.JoramAdminStamp);
        }
        return adminId;
    }

    public static final boolean isAdminTopicId(AgentId id) {
        if (id == null) {
            return false;
        }
        return id.getStamp() == AgentId.JoramAdminStamp;
    }

    public void react(AgentId from, Notification not) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": got " + not + " from: " + from.toString()));
        }
        this.setSave();
        if (not instanceof AdminNotification) {
            this.handleAdminNotification((AdminNotification)not);
        } else if (not instanceof FwdAdminRequestNot) {
            this.processAdminRequests(((FwdAdminRequestNot)not).getReplyTo(), ((FwdAdminRequestNot)not).getRequestMsgId(), ((FwdAdminRequestNot)not).getRequest(), from);
        } else if (not instanceof AdminReplyNot) {
            this.handleAdminReply((AdminReplyNot)not);
        } else if (not instanceof GetProxyIdNot) {
            this.handleGetProxyIdNot((GetProxyIdNot)not);
        } else if (not instanceof GetProxyIdListNot) {
            this.handleGetProxyIdListNot((GetProxyIdListNot)not);
        } else {
            super.react(from, not);
        }
    }

    private AgentId getProxyId(Identity identity, String inaddr) throws Exception {
        AgentId userProxId = null;
        Identity userIdentity = (Identity)this.usersTable.get(identity.getUserName());
        if (userIdentity == null) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("User [" + identity.getUserName() + "] does not exist"));
            }
            throw new Exception("User [" + identity.getUserName() + "] does not exist");
        }
        if (!userIdentity.check(identity)) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"identity check failed.");
            }
            throw new Exception("identity check failed.");
        }
        userProxId = (AgentId)this.proxiesTable.get(identity.getUserName());
        if (userProxId == null) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("No proxy deployed for user [" + identity.getUserName() + "]"));
            }
            throw new Exception("No proxy deployed for user [" + identity.getUserName() + "]");
        }
        return userProxId;
    }

    protected void handleDeniedMessage(String msgId, AgentId replyTo) {
        this.distributeReply(replyTo, msgId, new AdminReply(4, "Permission denied."));
    }

    private void handleAdminNotification(AdminNotification adminNot) {
        block4: {
            Identity identity = adminNot.getIdentity();
            try {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("AdminTopic store identity = " + identity));
                }
                this.usersTable.put(identity.getUserName(), identity);
                this.proxiesTable.put(identity.getUserName(), adminNot.getProxyId());
                this.clients.put(adminNot.getProxyId(), new Integer(READWRITE));
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(identity.getUserName() + " successfully set as admin client."));
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block4;
                logger.log(BasicLevel.ERROR, (Object)"Exception:: ", (Throwable)e);
            }
        }
    }

    private void handleAdminReply(AdminReplyNot not) {
        String requestId = not.getRequestId();
        if (requestId == null) {
            return;
        }
        AgentId replyTo = (AgentId)this.requestsTable.remove(requestId);
        if (replyTo == null) {
            return;
        }
        AdminReply reply = not instanceof GetRightsReplyNot ? this.doProcess((GetRightsReplyNot)not) : new AdminReply(not.getSuccess(), not.getInfo());
        this.distributeReply(replyTo, requestId, reply);
    }

    private void handleGetProxyIdNot(GetProxyIdNot not) {
        try {
            AgentId proxyId = this.getProxyId(not.getIdentity(), not.getInAddr());
            not.Return(proxyId);
        }
        catch (Exception exc) {
            not.Throw(exc);
        }
    }

    private void handleGetProxyIdListNot(GetProxyIdListNot not) {
        Vector<AgentId> idList = new Vector<AgentId>();
        for (AgentId aid : this.proxiesTable.values()) {
            idList.addElement(aid);
        }
        Object[] res = new AgentId[idList.size()];
        idList.copyInto(res);
        not.Return((AgentId[])res);
    }

    private AdminReply doProcess(GetRightsReplyNot not) {
        Vector readers = not.getReaders();
        Vector writers = not.getWriters();
        GetRightsReply reply = new GetRightsReply(not.getSuccess(), not.getInfo(), not.isFreeReading(), not.isFreeWriting());
        for (String name : this.proxiesTable.keySet()) {
            AgentId proxyId = (AgentId)this.proxiesTable.get(name);
            if (readers.contains(proxyId)) {
                reply.addReader(name, proxyId.toString());
            }
            if (!writers.contains(proxyId)) continue;
            reply.addWriter(name, proxyId.toString());
        }
        return reply;
    }

    protected void requestGroupNot(AgentId from, RequestGroupNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AdminTopic.requestGroupNot(" + (Object)((Object)not) + ')'));
        }
        Enumeration en = not.getClientMessages();
        while (en.hasMoreElements()) {
            ClientMessages cm = (ClientMessages)((Object)en.nextElement());
            try {
                this.clientMessages(from, cm);
            }
            catch (Exception exc) {}
        }
    }

    protected ClientMessages preProcess(AgentId from, ClientMessages msgs) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AdminTopic.clientMessages(" + (Object)((Object)msgs) + ')'));
        }
        if (!msgs.isPersistent() && !msgs.getAsyncSend()) {
            this.forward(from, new SendReplyNot(msgs.getClientContext(), msgs.getRequestId()));
        }
        this.processAdminRequests(msgs);
        return null;
    }

    protected void clusterJoinAck(ClusterJoinAck ack) {
        if (logger.isLoggable(BasicLevel.WARN)) {
            logger.log(BasicLevel.WARN, (Object)("Unexpected notification: " + (Object)((Object)ack)));
        }
    }

    protected void clusterJoin(ClusterJoinNot not) {
        if (logger.isLoggable(BasicLevel.WARN)) {
            logger.log(BasicLevel.WARN, (Object)("Unexpected notification: " + (Object)((Object)not)));
        }
    }

    protected void topicForwardNot(AgentId from, TopicForwardNot not) {
        if (logger.isLoggable(BasicLevel.WARN)) {
            logger.log(BasicLevel.WARN, (Object)("Unexpected notification: " + (Object)((Object)not)));
        }
    }

    public void deleteNot(AgentId from, DeleteNot not) {
        if (logger.isLoggable(BasicLevel.WARN)) {
            logger.log(BasicLevel.WARN, (Object)("Unexpected request: " + not));
        }
    }

    protected void doUnknownAgent(UnknownAgent uA) {
        AgentId agId = uA.agent;
        Notification not = uA.not;
        if (not instanceof AdminRequestNot) {
            String reqId = ((AdminRequestNot)not).getId();
            if (reqId != null) {
                AgentId replyTo = (AgentId)this.requestsTable.remove(reqId);
                this.strbuf.append("Request [").append(not.getClass().getName());
                this.strbuf.append("], sent to AdminTopic on server [").append(this.serverId);
                this.strbuf.append("], successful [false]: unknown agent [").append(agId).append(']');
                this.distributeReply(replyTo, reqId, new AdminReply(false, this.strbuf.toString()));
                this.strbuf.setLength(0);
            }
        } else {
            super.doUnknownAgent(uA);
        }
    }

    private void processAdminRequests(ClientMessages not) {
        if (not == null) {
            return;
        }
        for (Message msg : not.getMessages()) {
            ++this.nbMsgsReceiveSinceCreation;
            String msgId = msg.id;
            AgentId replyTo = AgentId.fromString((String)msg.replyToId);
            AdminRequest request = (AdminRequest)msg.getAdminMessage();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": got " + request));
            }
            if (request == null) {
                logger.log(BasicLevel.ERROR, (Object)("--- " + this + ": got bad AdminRequest."));
                this.distributeReply(replyTo, msgId, new AdminReply(false, "Unexpected request to AdminTopic"));
            }
            this.processAdminRequests(replyTo, msgId, request, null);
        }
    }

    private void processAdminRequests(AgentId replyTo, String msgId, AdminRequest request, AgentId from) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ".processAdminRequests(" + msgId + ',' + request + ')'));
        }
        String info = null;
        this.setSave();
        try {
            if (request instanceof StopServerRequest) {
                this.doProcess((StopServerRequest)request, replyTo, msgId);
            } else if (request instanceof CreateDestinationRequest) {
                this.doProcess((CreateDestinationRequest)request, replyTo, msgId);
            } else if (request instanceof DeleteDestination) {
                this.doProcess((DeleteDestination)request, replyTo, msgId);
            } else if (request instanceof CreateUserRequest) {
                this.doProcess((CreateUserRequest)request, replyTo, msgId);
            } else if (request instanceof UpdateUser) {
                this.doProcess((UpdateUser)request, replyTo, msgId);
            } else if (request instanceof DeleteUser) {
                this.doProcess((DeleteUser)request, replyTo, msgId);
            } else if (request instanceof SetDMQRequest) {
                this.doProcess((SetDMQRequest)request, replyTo, msgId);
            } else if (request instanceof SetThresholdRequest) {
                this.doProcess((SetThresholdRequest)request, replyTo, msgId);
            } else if (request instanceof GetServersIdsRequest) {
                this.doProcess((GetServersIdsRequest)request, replyTo, msgId);
            } else if (request instanceof GetDomainNames) {
                this.doProcess((GetDomainNames)request, replyTo, msgId);
            } else if (request instanceof GetLocalServer) {
                this.doProcess(replyTo, msgId);
            } else if (request instanceof GetDestinationsRequest) {
                this.doProcess((GetDestinationsRequest)request, replyTo, msgId);
            } else if (request instanceof GetUsersRequest) {
                this.doProcess((GetUsersRequest)request, replyTo, msgId);
            } else if (request instanceof GetRightsRequest) {
                this.doProcess((GetRightsRequest)request, replyTo, msgId);
            } else if (request instanceof GetDMQSettingsRequest) {
                this.doProcess((GetDMQSettingsRequest)request, replyTo, msgId);
            } else if (request instanceof GetStatsRequest) {
                this.doProcess((GetStatsRequest)request, replyTo, msgId);
            } else if (request instanceof DestinationAdminRequest) {
                this.doProcess((DestinationAdminRequest)request, replyTo, msgId);
            } else if (request instanceof AddServerRequest) {
                this.doProcess((AddServerRequest)request, replyTo, msgId, from);
            } else if (request instanceof AddDomainRequest) {
                this.doProcess((AddDomainRequest)request, replyTo, msgId, from);
            } else if (request instanceof RemoveServerRequest) {
                this.doProcess((RemoveServerRequest)request, replyTo, msgId, from);
            } else if (request instanceof RemoveDomainRequest) {
                this.doProcess((RemoveDomainRequest)request, replyTo, msgId, from);
            } else if (request instanceof GetConfigRequest) {
                this.doProcess((GetConfigRequest)request, replyTo, msgId);
            } else if (request instanceof UserAdminRequest) {
                this.doProcess((UserAdminRequest)request, replyTo, msgId);
            } else if (request instanceof AdminCommandRequest) {
                this.doProcess((AdminCommandRequest)request, replyTo, msgId);
            }
        }
        catch (UnknownServerException exc) {
            info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], successful [false]: ").append(exc.getMessage()).toString();
            this.strbuf.setLength(0);
            this.distributeReply(replyTo, msgId, new AdminReply(false, info));
        }
        catch (MomException exc) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)exc);
            }
            if (request == null) {
                info = this.strbuf.append("Unexpected request to AdminTopic on server [").append(this.serverId).append("]: ").append(exc.getMessage()).toString();
                this.strbuf.setLength(0);
            } else {
                info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [false]: ").append(exc.getMessage()).toString();
                this.strbuf.setLength(0);
            }
            this.distributeReply(replyTo, msgId, new AdminReply(false, info));
        }
    }

    private void doProcess(StopServerRequest request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (this.checkServerId(request.getServerId())) {
            this.distributeReply(replyTo, msgId, new AdminReply(true, "Server stopped"));
            AgentServer.stop((boolean)false, (long)500L, (boolean)true);
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
        }
    }

    private void doProcess(CreateDestinationRequest request, AgentId replyTo, String msgId) throws UnknownServerException, RequestException {
        if (this.checkServerId(request.getServerId())) {
            DestinationDesc destDesc = this.createDestination(request.getDestinationName(), this.getId(), request.getProperties(), request.getExpectedType(), request.getClassName(), request.getClass().getName(), this.strbuf);
            this.distributeReply(replyTo, msgId, (AdminReply)new CreateDestinationReply(destDesc.getId().toString(), destDesc.getName(), this.strbuf.toString()));
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)this.strbuf.toString());
            }
            this.strbuf.setLength(0);
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
        }
    }

    private DestinationDesc createDestination(String destName, AgentId adminId, Properties properties, byte type, String className, String requestClassName, StringBuffer strbuf) throws UnknownServerException, RequestException {
        DestinationDesc destDesc;
        if (destName != null && !destName.equals("") && this.destinationsTable.containsKey(destName)) {
            destDesc = (DestinationDesc)this.destinationsTable.get(destName);
            if (!DestinationConstants.compatible((byte)destDesc.getType(), (byte)type)) {
                throw new RequestException("Destination type not compliant");
            }
            strbuf.append("Request [").append(requestClassName).append("], processed by AdminTopic on server [").append(this.serverId).append("], successful [true]: destination [").append(destName).append("] has been retrieved");
        } else {
            Destination dest = null;
            try {
                dest = (Destination)Class.forName(className).newInstance();
                dest.setName(destName);
                dest.setAdminId(adminId);
                dest.setProperties(properties);
            }
            catch (Exception exc) {
                logger.log(BasicLevel.ERROR, (Object)("Could not instantiate Destination class [" + className + "]: "), (Throwable)exc);
                if (exc instanceof ClassCastException) {
                    throw new RequestException("Class [" + className + "] is not a Destination class.");
                }
                throw new RequestException("Could not instantiate Destination class [" + className + "]: " + exc);
            }
            byte destType = dest.getType();
            if (!DestinationConstants.compatible((byte)destType, (byte)type)) {
                throw new RequestException("Requested destination type is not compliant with destination classname");
            }
            if (destName == null || destName.equals("")) {
                destName = dest.getAgentId();
            }
            destDesc = new DestinationDesc(dest.getId(), destName, destType);
            try {
                dest.deploy();
                this.destinationsTable.put(destName, destDesc);
                strbuf.append("Request [").append(requestClassName).append("], processed by AdminTopic on server [").append(this.serverId).append("], successful [true]: ").append(className).append(" [").append(dest.getAgentId()).append("] has been created and deployed");
            }
            catch (Exception exc) {
                if (logger.isLoggable(BasicLevel.ERROR)) {
                    logger.log(BasicLevel.ERROR, (Object)"xxx", (Throwable)exc);
                }
                throw new RequestException("Error while deploying Destination [" + className + "]: " + exc);
            }
        }
        return destDesc;
    }

    private void doProcess(DeleteDestination request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString((String)request.getId());
        if (this.checkServerId(destId.getTo())) {
            for (DestinationDesc destDesc : this.destinationsTable.values()) {
                if (!destDesc.getId().equals((Object)destId)) continue;
                this.destinationsTable.remove(destDesc.getName());
                break;
            }
            this.forward(destId, (Notification)new DeleteNot());
            String info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [true]: destination [").append(destId).append("], successfuly notified for deletion").toString();
            this.strbuf.setLength(0);
            this.distributeReply(replyTo, msgId, new AdminReply(true, info));
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)info);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
        }
    }

    private void doProcess(CreateUserRequest request, AgentId replyTo, String msgId) throws UnknownServerException, RequestException {
        if (this.checkServerId(request.getServerId())) {
            String info;
            Identity identity = request.getIdentity();
            String name = identity.getUserName();
            AgentId proxId = (AgentId)this.proxiesTable.get(name);
            if (proxId != null) {
                Identity userIdentity = (Identity)this.usersTable.get(name);
                if (logger.isLoggable(BasicLevel.INFO)) {
                    logger.log(BasicLevel.INFO, (Object)("User [" + name + "] already exists : " + userIdentity));
                }
                try {
                    if (!userIdentity.check(identity)) {
                        throw new RequestException("User [" + name + "] already exists" + " but with a different password.");
                    }
                }
                catch (Exception e) {
                    throw new RequestException("User [" + name + "] already exists :: Exception :" + e.getMessage());
                }
                info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], processed by AdminTopic on server [").append(this.serverId).append("], successful [true]: proxy [").append(proxId.toString()).append("] of user [").append(name).append("] has been retrieved").toString();
                this.strbuf.setLength(0);
            } else {
                UserAgent proxy = new UserAgent();
                proxy.setName(name);
                proxId = proxy.getId();
                proxy.setInterceptors(request.getProperties());
                try {
                    proxy.deploy();
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("doProcess CreateUserRequest:: store (in usersTable) this identity = " + identity));
                    }
                    this.usersTable.put(name, identity);
                    this.proxiesTable.put(name, proxy.getId());
                    info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], processed by AdminTopic on server [").append(this.serverId).append("], successful [true]: proxy [").append(proxId.toString()).append("] for user [").append(name).append("] has been created and deployed").toString();
                    this.strbuf.setLength(0);
                }
                catch (Exception exc) {
                    if (logger.isLoggable(BasicLevel.ERROR)) {
                        logger.log(BasicLevel.ERROR, (Object)("EXCEPTION:: createUser [" + name + "]"), (Throwable)exc);
                    }
                    throw new RequestException("User proxy not deployed: " + exc);
                }
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)info);
            }
            this.distributeReply(replyTo, msgId, (AdminReply)new CreateUserReply(proxId.toString(), info));
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
        }
    }

    private void doProcess(UpdateUser request, AgentId replyTo, String msgId) throws RequestException, UnknownServerException {
        String name = request.getUserName();
        AgentId proxId = AgentId.fromString((String)request.getProxId());
        if (this.checkServerId(proxId.getTo())) {
            if (!this.usersTable.containsKey(name)) {
                throw new RequestException("User [" + name + "] does not exist");
            }
            Identity newIdentity = request.getNewIdentity();
            if (!newIdentity.getUserName().equals(name) && this.usersTable.containsKey(newIdentity.getUserName())) {
                throw new RequestException("Name [" + newIdentity.getUserName() + "] already used");
            }
            if (this.usersTable.containsKey(name)) {
                this.usersTable.remove(name);
                this.proxiesTable.remove(name);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("doProcess UpdateUser:: store (in usersTable) this identity = " + newIdentity));
                }
                this.usersTable.put(newIdentity.getUserName(), newIdentity);
                this.proxiesTable.put(newIdentity.getUserName(), proxId);
            }
            String info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], processed by AdminTopic on server [").append(this.serverId).append("], successful [true]: user [").append(name).append("] has been updated to [").append(newIdentity.getUserName()).append("]").toString();
            this.strbuf.setLength(0);
            this.distributeReply(replyTo, msgId, new AdminReply(true, info));
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)info);
            }
        } else {
            this.forward(AdminTopic.getDefault(proxId.getTo()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
        }
    }

    private void doProcess(DeleteUser request, AgentId replyTo, String msgId) throws UnknownServerException {
        String name = request.getUserName();
        AgentId proxId = AgentId.fromString((String)request.getProxId());
        if (this.checkServerId(proxId.getTo())) {
            if (this.usersTable.containsKey(name)) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Forward delete request to proxy " + proxId));
                }
                this.forward(proxId, new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId, this.createMessageId()));
            } else {
                String info = this.strbuf.append("Request [").append(request.getClass().getName()).append("], sent to AdminTopic on server [").append(this.serverId).append("], successful [false]: user [").append(name).append("] does not exist").toString();
                this.strbuf.setLength(0);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)info);
                }
                this.distributeReply(replyTo, msgId, new AdminReply(6, info));
            }
        } else {
            this.forward(AdminTopic.getDefault(proxId.getTo()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
        }
    }

    private void doProcess(SetDMQRequest request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString((String)request.getDestId());
        if (destId.isNullId()) {
            if (this.checkServerId(destId.getTo())) {
                Queue.defaultDMQId = null;
                if (request.getDmqId() != null) {
                    Queue.defaultDMQId = AgentId.fromString((String)request.getDmqId());
                }
                this.distributeReply(replyTo, msgId, new AdminReply(true, null));
            } else {
                this.forward(AdminTopic.getDefault(destId.getTo()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
            }
        } else {
            this.forward(destId, new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId, this.createMessageId()));
        }
    }

    private void doProcess(SetThresholdRequest request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString((String)request.getDestId());
        if (destId.isNullId()) {
            if (this.checkServerId(destId.getTo())) {
                Queue.defaultThreshold = 0;
                if (request.getThreshold() > 0) {
                    Queue.defaultThreshold = request.getThreshold();
                }
                this.distributeReply(replyTo, msgId, new AdminReply(true, null));
            } else {
                this.forward(AdminTopic.getDefault(destId.getTo()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
            }
        } else {
            this.forward(destId, new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId, this.createMessageId()));
        }
    }

    private void doProcess(GetServersIdsRequest request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (this.checkServerId(request.getServerId())) {
            try {
                int serversCount;
                Enumeration<Object> servers;
                String domainName = request.getDomainName();
                A3CMLConfig config = AgentServer.getConfig();
                if (domainName != null) {
                    A3CMLDomain domain = config.getDomain(domainName);
                    servers = domain.servers.elements();
                    serversCount = domain.servers.size();
                } else {
                    servers = config.servers.elements();
                    serversCount = config.servers.size();
                }
                int[] ids = new int[serversCount];
                String[] names = new String[serversCount];
                String[] hostNames = new String[serversCount];
                int i = 0;
                while (servers.hasMoreElements()) {
                    A3CMLServer server = (A3CMLServer)servers.nextElement();
                    ids[i] = server.sid;
                    names[i] = server.name;
                    hostNames[i] = server.hostname;
                    ++i;
                }
                GetServersIdsReply reply = new GetServersIdsReply(ids, names, hostNames);
                this.distributeReply(replyTo, msgId, (AdminReply)reply);
            }
            catch (Exception exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
                this.distributeReply(replyTo, msgId, new AdminReply(false, exc.toString()));
            }
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
        }
    }

    private void doProcess(AgentId replyTo, String msgId) {
        try {
            A3CMLConfig config = AgentServer.getConfig();
            A3CMLServer a3cmlServer = config.getServer(AgentServer.getServerId(), AgentServer.getClusterId());
            this.distributeReply(replyTo, msgId, (AdminReply)new GetLocalServerRep((int)a3cmlServer.sid, a3cmlServer.name, a3cmlServer.hostname));
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)(this + ".doProcess()"), (Throwable)exc);
            this.distributeReply(replyTo, msgId, new AdminReply(false, exc.toString()));
        }
    }

    private void doProcess(GetDomainNames request, AgentId replyTo, String msgId) {
        try {
            A3CMLConfig config = AgentServer.getConfig();
            A3CMLServer server = config.getServer((short)request.getServerId());
            String[] domainNames = new String[server.networks.size()];
            for (int i = 0; i < server.networks.size(); ++i) {
                A3CMLNetwork nw = (A3CMLNetwork)server.networks.elementAt(i);
                domainNames[i] = nw.domain;
            }
            GetDomainNamesRep reply = new GetDomainNamesRep(domainNames);
            this.distributeReply(replyTo, msgId, (AdminReply)reply);
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new AdminReply(false, exc.toString()));
        }
    }

    private void doProcess(GetDestinationsRequest request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (this.checkServerId(request.getServerId())) {
            Iterator destinations = this.destinationsTable.values().iterator();
            String[] ids = new String[this.destinationsTable.size()];
            String[] names = new String[this.destinationsTable.size()];
            byte[] types = new byte[this.destinationsTable.size()];
            int i = 0;
            while (destinations.hasNext()) {
                DestinationDesc destDesc = (DestinationDesc)destinations.next();
                ids[i] = destDesc.getId().toString();
                names[i] = destDesc.getName();
                types[i] = destDesc.getType();
                ++i;
            }
            GetDestinationsReply reply = new GetDestinationsReply(ids, names, types);
            this.distributeReply(replyTo, msgId, (AdminReply)reply);
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
        }
    }

    private void doProcess(GetUsersRequest request, AgentId replyTo, String msgId) throws UnknownServerException {
        if (this.checkServerId(request.getServerId())) {
            Hashtable<String, String> users = new Hashtable<String, String>(this.proxiesTable.size() * 4 / 3);
            for (String name : this.proxiesTable.keySet()) {
                users.put(name, ((AgentId)this.proxiesTable.get(name)).toString());
            }
            GetUsersReply reply = new GetUsersReply(users);
            this.distributeReply(replyTo, msgId, (AdminReply)reply);
        } else {
            this.forward(AdminTopic.getDefault((short)request.getServerId()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
        }
    }

    private void doProcess(GetRightsRequest request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId destId = AgentId.fromString((String)request.getDest());
        if (this.checkServerId(destId.getTo())) {
            this.forward(destId, new GetRightsRequestNot(msgId));
            if (replyTo != null) {
                this.requestsTable.put(msgId, replyTo);
            }
        } else {
            this.forward(AdminTopic.getDefault(destId.getTo()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
        }
    }

    private void doProcess(GetDMQSettingsRequest request, AgentId replyTo, String msgId) throws UnknownServerException {
        AgentId targetId = AgentId.fromString((String)request.getTarget());
        if (targetId.isNullId()) {
            if (this.checkServerId(targetId.getTo())) {
                String dmqId = null;
                if (Queue.defaultDMQId != null) {
                    dmqId = Queue.defaultDMQId.toString();
                }
                GetDMQSettingsReply reply = new GetDMQSettingsReply(dmqId, Queue.defaultThreshold);
                this.distributeReply(replyTo, msgId, (AdminReply)reply);
            } else {
                this.forward(AdminTopic.getDefault(targetId.getTo()), new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId));
            }
        } else {
            this.forward(targetId, new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId, this.createMessageId()));
        }
    }

    private void doProcess(GetStatsRequest request, AgentId replyTo, String msgId) {
        AgentId destId = AgentId.fromString((String)request.getDest());
        if (destId.isNullId()) {
            Hashtable<String, Float> stats = new Hashtable<String, Float>();
            stats.put("AverageLoad1", new Float(AgentServer.getEngineAverageLoad1()));
            stats.put("AverageLoad5", new Float(AgentServer.getEngineAverageLoad5()));
            stats.put("AverageLoad15", new Float(AgentServer.getEngineAverageLoad15()));
            GetStatsReply reply = new GetStatsReply(stats);
            this.distributeReply(replyTo, msgId, (AdminReply)reply);
        } else {
            this.forward(destId, new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId, this.createMessageId()));
        }
    }

    private void doProcess(DestinationAdminRequest request, AgentId replyTo, String msgId) {
        AgentId destId = AgentId.fromString((String)request.getDestId());
        this.forward(destId, new FwdAdminRequestNot((AdminRequest)request, replyTo, msgId, this.createMessageId()));
    }

    private void doProcess(AddDomainRequest request, AgentId replyTo, String msgId, AgentId from) {
        try {
            ServerConfigHelper helper = new ServerConfigHelper(true);
            if (helper.addDomain(request.getDomainName(), request.getNetwork(), request.getServerId(), request.getPort())) {
                this.distributeReply(replyTo, msgId, new AdminReply(true, "Domain added"));
            }
            if (from == null) {
                this.broadcastRequest((AdminRequest)request, -1, replyTo, msgId);
            }
        }
        catch (ServerConfigHelper.NameAlreadyUsedException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new AdminReply(0, exc.getMessage()));
        }
        catch (ServerConfigHelper.StartFailureException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new AdminReply(1, exc.getMessage()));
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new AdminReply(false, exc.toString()));
        }
    }

    private void doProcess(RemoveDomainRequest request, AgentId replyTo, String msgId, AgentId from) {
        try {
            ServerConfigHelper helper = new ServerConfigHelper(true);
            if (helper.removeDomain(request.getDomainName())) {
                this.distributeReply(replyTo, msgId, new AdminReply(true, "Domain removed"));
            }
            if (from == null) {
                this.broadcastRequest((AdminRequest)request, -1, replyTo, msgId);
            }
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new AdminReply(false, exc.toString()));
        }
    }

    private void doProcess(AddServerRequest request, AgentId replyTo, String msgId, AgentId from) {
        try {
            ServerConfigHelper helper = new ServerConfigHelper(false);
            helper.addServer(request.getServerId(), request.getHostName(), request.getDomainName(), request.getPort(), request.getServerName());
            helper.addService(request.getServerId(), "org.objectweb.joram.mom.proxies.ConnectionManager", "root root");
            String[] serviceNames = request.getServiceNames();
            String[] serviceArgs = request.getServiceArgs();
            for (int i = 0; i < serviceNames.length; ++i) {
                helper.addService(request.getServerId(), serviceNames[i], serviceArgs[i]);
            }
            helper.commit();
            this.distributeReply(replyTo, msgId, new AdminReply(true, "Server added"));
            if (from == null) {
                this.broadcastRequest((AdminRequest)request, request.getServerId(), replyTo, msgId);
            }
        }
        catch (ServerConfigHelper.ServerIdAlreadyUsedException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new AdminReply(2, exc.getMessage()));
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new AdminReply(false, exc.toString()));
        }
    }

    private void doProcess(RemoveServerRequest request, AgentId replyTo, String msgId, AgentId from) {
        try {
            ServerConfigHelper helper = new ServerConfigHelper(true);
            helper.removeServer(request.getServerId());
            this.distributeReply(replyTo, msgId, new AdminReply(true, "Server removed"));
            if (from == null) {
                this.broadcastRequest((AdminRequest)request, request.getServerId(), replyTo, msgId);
            }
        }
        catch (UnknownServerException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new AdminReply(3, exc.getMessage()));
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new AdminReply(false, exc.toString()));
        }
    }

    private void broadcastRequest(AdminRequest request, int avoidServerId, AgentId replyTo, String msgId) {
        FwdAdminRequestNot not = new FwdAdminRequestNot(request, replyTo, msgId);
        Enumeration ids = AgentServer.getServersIds();
        while (ids.hasMoreElements()) {
            short id = (Short)ids.nextElement();
            if (id == AgentServer.getServerId() || id == avoidServerId) continue;
            this.forward(AdminTopic.getDefault(id), not);
        }
    }

    private void doProcess(GetConfigRequest request, AgentId replyTo, String msgId) {
        try {
            A3CMLConfig a3cmlConfig = AgentServer.getConfig();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(baos);
            A3CML.toXML((A3CMLConfig)a3cmlConfig, (PrintWriter)out);
            out.flush();
            baos.flush();
            baos.close();
            this.distributeReply(replyTo, msgId, new AdminReply(true, baos.toString()));
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            this.distributeReply(replyTo, msgId, new AdminReply(false, exc.toString()));
        }
    }

    private void distributeReply(AgentId to, String msgId, AdminReply reply) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AdminTopic.distributeReply(" + to + ',' + msgId + ',' + reply + ')'));
        }
        if (to == null) {
            return;
        }
        Message message = MessageHelper.createMessage((String)this.createMessageId(), (String)msgId, (String)this.getAgentId(), (byte)this.getType());
        try {
            message.setAdminMessage((AbstractAdminMessage)reply);
            ClientMessages clientMessages = new ClientMessages(-1, -1, message);
            this.forward(to, clientMessages);
            ++this.nbMsgsDeliverSinceCreation;
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
        }
    }

    private String createMessageId() {
        ++this.msgCounter;
        return "ID:" + this.getId().toString() + '_' + this.msgCounter;
    }

    private void doProcess(UserAdminRequest request, AgentId replyTo, String requestMsgId) throws UnknownServerException {
        AgentId userId = AgentId.fromString((String)request.getUserId());
        if (this.checkServerId(userId.getTo())) {
            this.forward(userId, new FwdAdminRequestNot((AdminRequest)request, replyTo, requestMsgId, this.createMessageId()));
        } else {
            this.forward(AdminTopic.getDefault(userId.getTo()), new FwdAdminRequestNot((AdminRequest)request, replyTo, requestMsgId, null));
        }
    }

    private void doProcess(AdminCommandRequest request, AgentId replyTo, String requestMsgId) throws UnknownServerException {
        AgentId targetId = null;
        try {
            targetId = AgentId.fromString((String)request.getTargetId());
        }
        catch (Exception e) {
            throw new UnknownServerException(e.getMessage());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AdminTopic.doProcess(" + request + ',' + replyTo + ',' + requestMsgId + ")   targetId = " + targetId));
        }
        if (!targetId.isNullId()) {
            if (targetId.equals((Object)this.getAgentId())) {
                Properties replyProp = null;
                try {
                    switch (request.getCommand()) {
                        case 0: {
                            break;
                        }
                        default: {
                            throw new Exception("Bad command : \"" + AdminCommandConstant.commandNames[request.getCommand()] + "\"");
                        }
                    }
                    this.distributeReply(replyTo, requestMsgId, (AdminReply)new AdminCommandReply(true, AdminCommandConstant.commandNames[request.getCommand()] + " done.", replyProp));
                }
                catch (Exception exc) {
                    if (logger.isLoggable(BasicLevel.WARN)) {
                        logger.log(BasicLevel.WARN, (Object)"", (Throwable)exc);
                    }
                    this.distributeReply(replyTo, requestMsgId, new AdminReply(-1, exc.toString()));
                }
            } else {
                this.forward(targetId, new FwdAdminRequestNot((AdminRequest)request, replyTo, requestMsgId));
            }
        } else {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"Request (AdminCommandRequest) to an undefined targetId (null).");
            }
            this.distributeReply(replyTo, requestMsgId, new AdminReply(3, "Request (AdminCommandRequest) to an undefined targetId (null)."));
        }
    }

    private boolean checkServerId(int serverId) throws UnknownServerException {
        if (serverId == this.serverId) {
            return true;
        }
        Enumeration ids = AgentServer.getServersIds();
        while (ids.hasMoreElements()) {
            if (((Short)ids.nextElement()).intValue() != serverId) continue;
            return false;
        }
        throw new UnknownServerException("server#" + serverId + " is unknow.");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(Queue.defaultDMQId);
        out.writeInt(Queue.defaultThreshold);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Queue.defaultDMQId = (AgentId)in.readObject();
        Queue.defaultThreshold = in.readInt();
        in.defaultReadObject();
        ref = this;
    }

    public void createUser(String user, String passwd) throws Exception {
        this.createUser(user, passwd, this.serverId);
    }

    public void createUser(String user, String passwd, int serverId) throws Exception {
        this.createUser(user, passwd, serverId, SimpleIdentity.class.getName());
    }

    public void createUser(String user, String passwd, int serverId, String identityClassName) throws Exception {
        Identity identity = null;
        try {
            identity = (Identity)Class.forName(identityClassName).newInstance();
            if (passwd != null) {
                identity.setIdentity(user, passwd);
            } else {
                identity.setUserName(user);
            }
        }
        catch (Exception e) {
            throw new RequestException(e.getMessage());
        }
        CreateUserRequest request = new CreateUserRequest(identity, serverId, null);
        FwdAdminRequestNot createNot = new FwdAdminRequestNot((AdminRequest)request, null, null);
        Channel.sendTo((AgentId)this.getId(), (Notification)createNot);
    }

    public void createQueue(String name) {
        this.createQueue(name, this.serverId);
    }

    public void createQueue(String name, int serverId) {
        this.createQueue(name, Queue.class.getName(), serverId);
    }

    public void createQueue(String name, String queueClassName, int serverId) {
        CreateDestinationRequest request = new CreateDestinationRequest(serverId, name, queueClassName, null, 2);
        FwdAdminRequestNot createNot = new FwdAdminRequestNot((AdminRequest)request, null, null);
        Channel.sendTo((AgentId)this.getId(), (Notification)createNot);
    }

    public void createTopic(String name) {
        this.createTopic(name, this.serverId);
    }

    public void createTopic(String name, int serverId) {
        this.createTopic(name, Topic.class.getName(), serverId);
    }

    public void createTopic(String name, String topicClassName, int serverId) {
        CreateDestinationRequest request = new CreateDestinationRequest(serverId, name, topicClassName, null, 1);
        FwdAdminRequestNot createNot = new FwdAdminRequestNot((AdminRequest)request, null, null);
        Channel.sendTo((AgentId)this.getId(), (Notification)createNot);
    }

    public static void deleteUser(String userName) {
        AdminTopic.ref.usersTable.remove(userName);
        AdminTopic.ref.proxiesTable.remove(userName);
    }

    public static DestinationDesc lookupDest(String name, byte type) throws RequestException {
        DestinationDesc desc = null;
        if (name != null && name.length() > 0 && (desc = (DestinationDesc)AdminTopic.ref.destinationsTable.get(name)) != null && !DestinationConstants.compatible((byte)desc.getType(), (byte)type)) {
            throw new RequestException("Destination type not compliant");
        }
        return desc;
    }

    public static void registerDest(AgentId id, String name, byte type) {
        DestinationDesc desc = new DestinationDesc(id, name, type);
        AdminTopic.ref.destinationsTable.put(name, desc);
        try {
            AgentServer.getTransaction().save((Serializable)((Object)ref), ref.getId().toString());
        }
        catch (IOException exc) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot unregister destination", (Throwable)exc);
        }
    }

    public static void unregisterDest(String name) {
        AdminTopic.ref.destinationsTable.remove(name);
        try {
            AgentServer.getTransaction().save((Serializable)((Object)ref), ref.getId().toString());
        }
        catch (IOException exc) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot unregister destination", (Throwable)exc);
        }
    }

    static {
        adminId = null;
    }

    public static class DestinationDesc
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AgentId id;
        private String name;
        private byte type;

        public DestinationDesc(AgentId id, String name, byte type) {
            this.id = id;
            this.name = name;
            this.type = type;
        }

        public final AgentId getId() {
            return this.id;
        }

        public final String getName() {
            return this.name;
        }

        public final byte getType() {
            return this.type;
        }

        public String toString() {
            StringBuffer strbuf = new StringBuffer();
            strbuf.append('(').append(super.toString());
            strbuf.append(",id=").append(this.id);
            strbuf.append(",name=").append(this.name);
            strbuf.append(",type=").append(this.type).append(')');
            return strbuf.toString();
        }
    }
}

