/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.util;

import fr.dyade.aaa.common.Debug;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.objectweb.joram.mom.util.MessageInterceptor;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class InterceptorsHelper {
    public static Logger logger = Debug.getLogger((String)InterceptorsHelper.class.getName());
    private static final String INTERCEPTOR_CLASS_NAME_SEPARATOR = ",";

    public static synchronized void addInterceptors(String listInterceptorClassName, List interceptors) throws Exception {
        if (listInterceptorClassName != null && interceptors != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("addInterceptors(" + listInterceptorClassName + ", " + interceptors + ')'));
            }
            String error = null;
            StringTokenizer token = new StringTokenizer(listInterceptorClassName, INTERCEPTOR_CLASS_NAME_SEPARATOR);
            while (token.hasMoreTokens()) {
                String interceptorClassName = token.nextToken();
                try {
                    interceptors.add((MessageInterceptor)Class.forName(interceptorClassName).newInstance());
                }
                catch (Throwable t) {
                    if (logger.isLoggable(BasicLevel.WARN)) {
                        logger.log(BasicLevel.WARN, (Object)"addInterceptors", t);
                    }
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    if (error == null) {
                        error = "(" + interceptorClassName + " exc=" + sw.toString() + ')';
                        continue;
                    }
                    error = error + "(" + interceptorClassName + " exc=" + sw.toString() + ')';
                }
            }
            if (error != null) {
                throw new Exception(error);
            }
        }
    }

    private static boolean removeInterceptor(String interceptorClassName, List interceptors) {
        boolean removed = false;
        if (interceptorClassName != null) {
            Iterator it = interceptors.iterator();
            while (it.hasNext()) {
                if (!interceptorClassName.equals(it.next().getClass().getName())) continue;
                removed = true;
                it.remove();
                break;
            }
        }
        return removed;
    }

    public static synchronized void removeInterceptors(String listInterceptorClassName, List interceptors) throws Exception {
        if (listInterceptorClassName != null && interceptors != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("removeInterceptors(" + listInterceptorClassName + ", " + interceptors + ')'));
            }
            String error = null;
            StringTokenizer token = new StringTokenizer(listInterceptorClassName, INTERCEPTOR_CLASS_NAME_SEPARATOR);
            while (token.hasMoreTokens()) {
                String interceptorClassName = token.nextToken();
                try {
                    InterceptorsHelper.removeInterceptor(interceptorClassName, interceptors);
                }
                catch (Throwable t) {
                    if (logger.isLoggable(BasicLevel.WARN)) {
                        logger.log(BasicLevel.WARN, (Object)"removeInterceptors", t);
                    }
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    if (error == null) {
                        error = "(" + interceptorClassName + " exc=" + sw.toString() + ')';
                        continue;
                    }
                    error = error + "(" + interceptorClassName + " exc=" + sw.toString() + ')';
                }
            }
            if (error != null) {
                throw new Exception(error);
            }
        }
    }

    public static synchronized boolean replaceInterceptor(String newInterceptorClassName, String oldInterceptorClassName, List interceptors) throws Exception {
        if (newInterceptorClassName != null && oldInterceptorClassName != null && interceptors != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("replaceInterceptor(" + newInterceptorClassName + ", " + oldInterceptorClassName + ", " + interceptors + ')'));
            }
            try {
                boolean replaced = false;
                for (MessageInterceptor oldMI : interceptors) {
                    if (!oldInterceptorClassName.equals(oldMI.getClass().getName())) continue;
                    int index = interceptors.indexOf(oldMI);
                    interceptors.remove(index);
                    interceptors.add(index, (MessageInterceptor)Class.forName(newInterceptorClassName).newInstance());
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("replaceInterceptor index = " + index));
                    }
                    replaced = true;
                    break;
                }
                return replaced;
            }
            catch (Throwable t) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)"replaceInterceptor", t);
                }
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                throw new Exception("(" + newInterceptorClassName + " exc=" + sw.toString() + ')');
            }
        }
        return false;
    }

    public static String getListInterceptors(List interceptors) {
        if (interceptors != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("getListInterceptors(" + interceptors + ')'));
            }
            StringBuffer buff = new StringBuffer();
            Iterator it = interceptors.iterator();
            while (it.hasNext()) {
                MessageInterceptor messageInterceptor = (MessageInterceptor)it.next();
                buff.append(messageInterceptor.getClass().getName());
                if (!it.hasNext()) continue;
                buff.append(INTERCEPTOR_CLASS_NAME_SEPARATOR);
            }
            return buff.toString();
        }
        return null;
    }
}

