/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.archive.impl;

import java.io.IOException;
import java.net.URL;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.api.IArchiveFactory;
import org.ow2.util.archive.impl.DefaultArchiveFactory;
import org.ow2.util.archive.impl.URLArchiveImpl;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLArchiveFactory
implements IArchiveFactory<URL> {
    public IArchive create(URL url) {
        if ("file".equals(url.getProtocol())) {
            return new DefaultArchiveFactory().create(URLUtils.urlToFile((URL)url));
        }
        try {
            return new URLArchiveImpl(url);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Class<URL> getSupportedClass() {
        return URL.class;
    }
}

