/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.substitution.resolver;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.ow2.util.substitution.IPropertyResolver;
import org.ow2.util.substitution.ISubstitutionEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveResolver
implements IPropertyResolver {
    private ISubstitutionEngine engine;
    private IPropertyResolver delegate;
    private Stack<String> processedExpressions;
    private Map<String, String> resolutions;
    private List<Report> reports;
    private boolean strict = true;

    public RecursiveResolver(ISubstitutionEngine engine, IPropertyResolver delegate) {
        assert (engine != null);
        assert (delegate != null);
        this.engine = engine;
        this.delegate = delegate;
        this.processedExpressions = new Stack();
        this.resolutions = new Hashtable<String, String>();
        this.reports = new ArrayList<Report>();
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public List<Report> getReports() {
        return this.reports;
    }

    @Override
    public String resolve(String expression) {
        if (this.isAlreadyProcessed(expression)) {
            Report report = this.createReport(expression);
            this.reports.add(report);
            if (this.isStrict()) {
                throw new IllegalArgumentException(report.toString());
            }
            return "[" + expression + ":infinite-loop]";
        }
        String resolved = this.delegate.resolve(expression);
        if (resolved == null) {
            throw new IllegalArgumentException("Expression [" + expression + "] could not be resolved.");
        }
        return this.doSubstitute(expression, resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doSubstitute(String expression, String resolved) {
        this.processedExpressions.push(expression);
        this.resolutions.put(expression, resolved);
        try {
            String string = this.engine.substitute(resolved);
            return string;
        }
        finally {
            this.processedExpressions.pop();
            this.resolutions.remove(expression);
        }
    }

    private boolean isAlreadyProcessed(String expression) {
        return this.processedExpressions.contains(expression);
    }

    private Report createReport(String name) {
        Report report = new Report();
        report.expression = name;
        report.resolutionStack = new Stack();
        for (String element : this.processedExpressions) {
            Resolution res = new Resolution(element, this.resolutions.get(element));
            report.resolutionStack.push(res);
        }
        return report;
    }

    public static class Resolution {
        public String name;
        public String value;

        public Resolution(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resolution that = (Resolution)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Report {
        private String expression;
        private Stack<Resolution> resolutionStack;

        public String getRecursiveExpression() {
            return this.expression;
        }

        public Stack<Resolution> getResolutionStack() {
            return this.resolutionStack;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Stopping infinite recursion loop on '");
            sb.append(this.expression);
            sb.append("'\n");
            sb.append("Recursion stack\n");
            int i = 0;
            for (Resolution resolution : this.resolutionStack) {
                sb.append("  ");
                sb.append(i);
                sb.append(". ");
                sb.append(resolution.name);
                sb.append(" -> ");
                sb.append(resolution.value);
                sb.append("\n");
                ++i;
            }
            return sb.toString();
        }
    }
}

