/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EffectivePolicyImpl;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyUtils;
import org.apache.cxf.ws.policy.PolicyVerificationInInterceptor;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

public class PolicyInInterceptor
extends AbstractPolicyInterceptor {
    public static final PolicyInInterceptor INSTANCE = new PolicyInInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyInInterceptor.class);

    public PolicyInInterceptor() {
        super("org.apache.cxf.ws.policy.PolicyInInterceptor", "receive");
    }

    protected void handle(Message msg) {
        Exchange exchange = msg.getExchange();
        Bus bus = exchange.get(Bus.class);
        Endpoint e = exchange.get(Endpoint.class);
        if (null == e) {
            LOG.fine("No endpoint.");
            return;
        }
        EndpointInfo ei = e.getEndpointInfo();
        PolicyEngine pe = bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        if (MessageUtils.isRequestor(msg)) {
            BindingOperationInfo boi = exchange.get(BindingOperationInfo.class);
            Policy p = (Policy)msg.getContextualProperty("org.apache.cxf.ws.policy.override");
            if (p != null) {
                EndpointPolicyImpl endpi = new EndpointPolicyImpl(p);
                EffectivePolicyImpl effectivePolicy = new EffectivePolicyImpl();
                effectivePolicy.initialise(endpi, (PolicyEngineImpl)pe, true);
                msg.put(EffectivePolicy.class, effectivePolicy);
                PolicyUtils.logPolicy(LOG, Level.FINEST, "Using effective policy: ", (PolicyComponent)effectivePolicy.getPolicy());
                List<Interceptor> interceptors = effectivePolicy.getInterceptors();
                for (Interceptor i : interceptors) {
                    msg.getInterceptorChain().add(i);
                    LOG.log(Level.FINE, "Added interceptor of type {0}", i.getClass().getSimpleName());
                }
                Collection<PolicyAssertion> assertions = effectivePolicy.getChosenAlternative();
                if (null != assertions && !assertions.isEmpty()) {
                    msg.put(AssertionInfoMap.class, new AssertionInfoMap(assertions));
                    msg.getInterceptorChain().add(PolicyVerificationInInterceptor.INSTANCE);
                }
            } else if (boi == null) {
                Collection<PolicyAssertion> assertions;
                Conduit conduit = exchange.getConduit(msg);
                EndpointPolicy ep = pe.getClientEndpointPolicy(ei, conduit);
                List<Interceptor> interceptors = ep.getInterceptors();
                if (null != interceptors) {
                    for (Interceptor i : interceptors) {
                        msg.getInterceptorChain().add(i);
                    }
                }
                if (null != (assertions = ep.getVocabulary()) && !assertions.isEmpty()) {
                    msg.put(AssertionInfoMap.class, new AssertionInfoMap(assertions));
                    msg.getInterceptorChain().add(PolicyVerificationInInterceptor.INSTANCE);
                }
            } else {
                EffectivePolicy ep = pe.getEffectiveClientResponsePolicy(ei, boi);
                List<Interceptor> interceptors = ep.getInterceptors();
                if (null != interceptors) {
                    for (Interceptor i : interceptors) {
                        msg.getInterceptorChain().add(i);
                    }
                }
                if (ep.getPolicy() != null) {
                    msg.put(AssertionInfoMap.class, new AssertionInfoMap(ep.getPolicy()));
                    msg.getInterceptorChain().add(PolicyVerificationInInterceptor.INSTANCE);
                }
            }
        } else {
            Collection<PolicyAssertion> assertions;
            Destination destination = exchange.getDestination();
            EndpointPolicy ep = pe.getServerEndpointPolicy(ei, destination);
            List<Interceptor> interceptors = ep.getInterceptors();
            if (null != interceptors) {
                for (Interceptor i : interceptors) {
                    msg.getInterceptorChain().add(i);
                    LOG.log(Level.FINE, "Added interceptor of type {0}", i.getClass().getSimpleName());
                }
            }
            if (null != (assertions = ep.getVocabulary()) && !assertions.isEmpty()) {
                msg.put(AssertionInfoMap.class, new AssertionInfoMap(assertions));
                msg.getInterceptorChain().add(PolicyVerificationInInterceptor.INSTANCE);
            }
        }
    }
}

