/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.StringTokenizer;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;

public class SSLServerSocketFactory
implements org.jacorb.orb.factory.SSLServerSocketFactory,
Configurable {
    private ServerSocketFactory factory = null;
    private boolean require_mutual_auth = false;
    private boolean request_mutual_auth = false;
    private boolean trusteesFromKS = false;
    private String[] cipher_suites = null;
    private String[] enabledProtocols = null;
    private TrustManager trustManager = null;
    private short serverSupportedOptions = 0;
    private short serverRequiredOptions = 0;
    private String keystore_location = null;
    private String keystore_passphrase = null;
    private Logger logger;

    public SSLServerSocketFactory(ORB oRB) {
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        StringTokenizer stringTokenizer;
        int n;
        block15: {
            block14: {
                this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.security.jsse");
                this.trusteesFromKS = configuration.getAttributeAsBoolean("jacorb.security.jsse.trustees_from_ks", false);
                this.serverSupportedOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
                this.serverRequiredOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
                if ((this.serverSupportedOptions & 0x40) != 0) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Will create SSL sockets that request client authentication");
                    }
                    this.request_mutual_auth = true;
                }
                if ((this.serverRequiredOptions & 0x40) != 0) {
                    this.require_mutual_auth = true;
                    this.request_mutual_auth = false;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Will create SSL sockets that require client authentication");
                    }
                }
                this.keystore_location = configuration.getAttribute("jacorb.security.keystore", "UNSET");
                this.keystore_passphrase = configuration.getAttribute("jacorb.security.keystore_password", "UNSET");
                try {
                    this.trustManager = (TrustManager)((org.jacorb.config.Configuration)configuration).getAttributeAsObject("jacorb.security.ssl.server.trust_manager");
                }
                catch (ConfigurationException configurationException) {
                    if (!this.logger.isErrorEnabled()) break block14;
                    this.logger.error("TrustManager object creation failed. Please check value of property 'jacorb.security.ssl.server.trust_manager'. Current value: " + configuration.getAttribute("jacorb.security.ssl.server.trust_manager", ""), configurationException);
                }
            }
            if (configuration.getAttribute("jacorb.security.ssl.server.protocols", null) != null) {
                this.enabledProtocols = (String[])((org.jacorb.config.Configuration)configuration).getAttributeList("jacorb.security.ssl.server.protocols").toArray();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Setting user specified server enabled protocols : " + configuration.getAttribute("jacorb.security.ssl.server.protocols", ""));
                }
            }
            try {
                this.factory = this.createServerSocketFactory();
            }
            catch (Exception exception) {
                if (!this.logger.isWarnEnabled()) break block15;
                this.logger.warn("Exception", exception);
            }
        }
        if (this.factory == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Unable to create ServerSocketFactory!");
            }
            throw new ConfigurationException("Unable to create ServerSocketFactory!");
        }
        String string = configuration.getAttribute("jacorb.security.ssl.server.cipher_suites", null);
        if (string != null && (n = (stringTokenizer = new StringTokenizer(string, ",")).countTokens()) > 0) {
            this.cipher_suites = new String[n];
            while (stringTokenizer.hasMoreElements()) {
                this.cipher_suites[--n] = stringTokenizer.nextToken();
            }
        }
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n);
        if (this.request_mutual_auth) {
            sSLServerSocket.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            sSLServerSocket.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            sSLServerSocket.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            sSLServerSocket.setEnabledProtocols(this.enabledProtocols);
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n, n2);
        if (this.request_mutual_auth) {
            sSLServerSocket.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            sSLServerSocket.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            sSLServerSocket.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            sSLServerSocket.setEnabledProtocols(this.enabledProtocols);
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n, n2, inetAddress);
        if (this.request_mutual_auth) {
            sSLServerSocket.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            sSLServerSocket.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            sSLServerSocket.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            sSLServerSocket.setEnabledProtocols(this.enabledProtocols);
        }
        return sSLServerSocket;
    }

    public boolean isSSL(ServerSocket serverSocket) {
        return serverSocket instanceof SSLServerSocket;
    }

    private ServerSocketFactory createServerSocketFactory() throws IOException, GeneralSecurityException {
        TrustManager[] trustManagerArray;
        KeyStore keyStore = KeyStoreUtil.getKeyStore(this.keystore_location, this.keystore_passphrase.toCharArray());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, this.keystore_passphrase.toCharArray());
        TrustManagerFactory trustManagerFactory = null;
        if ((this.serverRequiredOptions & 0x40) != 0 || (this.serverSupportedOptions & 0x40) != 0) {
            trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            if (this.trusteesFromKS) {
                trustManagerFactory.init(keyStore);
            } else {
                trustManagerFactory.init((KeyStore)null);
            }
        }
        if (this.trustManager == null) {
            trustManagerArray = trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers();
        } else {
            trustManagerArray = new TrustManager[]{this.trustManager};
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified server TrustManger : " + this.trustManager.getClass().toString());
            }
        }
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, null);
        return sSLContext.getServerSocketFactory();
    }
}

