/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genic;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.ow2.jonas.deployment.ejb.FieldDesc;
import org.ow2.jonas.lib.ejb21.JavaType;
import org.ow2.jonas.lib.ejb21.jorm.JormType;

public class VcField {
    private String mName = null;
    private String mTypeName = null;
    private boolean isPrimaryKey = false;
    private boolean mIsCmp1 = false;
    private String mDefaultValue = null;
    private String mSqlTypeName = null;
    private String mSqlGetMethod = null;
    private String mSqlSetMethod = null;
    private boolean hasNotPrimitiveType = false;
    private boolean hasBigIntegerType = false;
    private boolean hasSerializableType = false;
    private boolean hasJavaLangTypeExceptString = false;
    private String jormTypeName = null;
    private boolean mustBeConvert = false;
    private String convertClassName = null;

    public VcField(String mName, Class fType, FieldDesc fd, boolean isCmp1) {
        this.mIsCmp1 = isCmp1;
        this.mName = mName;
        this.mTypeName = JavaType.getName((Class)fType);
        this.isPrimaryKey = fd.isPrimaryKey();
        this.mDefaultValue = JavaType.getDefaultValue((Class)fType);
        if (this.mIsCmp1) {
            this.mSqlTypeName = JavaType.getSQLType((Class)fType);
            this.mSqlGetMethod = JavaType.getSQLGetMethod((Class)fType);
            this.mSqlSetMethod = JavaType.getSQLSetMethod((Class)fType);
            this.hasNotPrimitiveType = !fType.isPrimitive();
            this.hasBigIntegerType = fType.equals(BigInteger.class);
            this.hasSerializableType = "setSerializable".equals(this.mSqlSetMethod) && "getSerializable".equals(this.mSqlGetMethod);
            this.hasJavaLangTypeExceptString = false;
            if (fType.getPackage() != null && "java.lang".equals(fType.getPackage().getName()) && !String.class.equals((Object)fType)) {
                this.hasJavaLangTypeExceptString = true;
            }
        } else {
            this.jormTypeName = JormType.getPType((Class)fType, (boolean)this.isPrimaryKey).getJavaName();
            if (fType.equals(Date.class)) {
                this.mustBeConvert = true;
                this.convertClassName = "org.ow2.jonas.lib.ejb21.sql.SqlDateFieldMapping";
            } else if (fType.equals(Time.class)) {
                this.mustBeConvert = true;
                this.convertClassName = "org.ow2.jonas.lib.ejb21.sql.SqlTimeFieldMapping";
            } else if (fType.equals(Timestamp.class)) {
                this.mustBeConvert = true;
                this.convertClassName = "org.ow2.jonas.lib.ejb21.sql.SqlTimestampFieldMapping";
            } else if (this.isPrimaryKey && fType.equals(Float.class)) {
                this.mustBeConvert = true;
                this.convertClassName = "org.ow2.jonas.lib.ejb21.jorm.FloatPkFieldMapping";
            }
        }
    }

    VcField(Field field, FieldDesc fd) {
        this(field.getName(), field.getType(), fd, true);
    }

    VcField(FieldDesc fd) {
        this(fd.getName(), fd.getFieldType(), fd, false);
    }

    public String getName() {
        return this.mName;
    }

    public String getNameUpperFirst() {
        return Character.toUpperCase(this.mName.charAt(0)) + this.mName.substring(1);
    }

    public String jormGetter() {
        return "paGet" + this.getNameUpperFirst();
    }

    public String jormSetter() {
        return "paSet" + this.getNameUpperFirst();
    }

    public String getGetterName() {
        return "get" + Character.toUpperCase(this.mName.charAt(0)) + this.mName.substring(1);
    }

    public String getSetterName() {
        return "set" + Character.toUpperCase(this.mName.charAt(0)) + this.mName.substring(1);
    }

    public String getTypeName() {
        return this.mTypeName;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    public String getSqlTypeName() {
        return this.mSqlTypeName;
    }

    public String getSqlGetMethod() {
        return this.mSqlGetMethod;
    }

    public String getSqlSetMethod() {
        return this.mSqlSetMethod;
    }

    public boolean hasNotPrimitiveType() {
        return this.hasNotPrimitiveType;
    }

    public boolean hasBigIntegerType() {
        return this.hasBigIntegerType;
    }

    public boolean hasSerializableType() {
        return this.hasSerializableType;
    }

    public boolean hasJavaLangTypeExceptString() {
        return this.hasJavaLangTypeExceptString;
    }

    public String getJormTypeName() {
        return this.jormTypeName;
    }

    public boolean isMustBeConvert() {
        return this.mustBeConvert;
    }

    public String getConvertClassName() {
        return this.convertClassName;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\n    Name                 = " + this.getName());
        ret.append("\n    isPrimaryKey         = " + this.isPrimaryKey());
        ret.append("\n    NameUpperFirst       = " + this.getNameUpperFirst());
        ret.append("\n    GetterName           = " + this.getGetterName());
        ret.append("\n    SetterName           = " + this.getSetterName());
        ret.append("\n    TypeName             = " + this.getTypeName());
        ret.append("\n    DefaultValue         = " + this.getDefaultValue());
        if (this.mIsCmp1) {
            ret.append("\n    SqlTypeName          = " + this.getSqlTypeName());
            ret.append("\n    SqlGetMethod         = " + this.getSqlGetMethod());
            ret.append("\n    SqlSetMethod         = " + this.getSqlSetMethod());
            ret.append("\n    hasNotPrimitiveType  = " + this.hasNotPrimitiveType());
            ret.append("\n    hasBigIntegerType    = " + this.hasBigIntegerType());
            ret.append("\n    hasSerializableType  = " + this.hasSerializableType());
            ret.append("\n    hasJavaLangTypeExceptString = " + this.hasJavaLangTypeExceptString());
        } else {
            ret.append("\n    JormTypeName         = " + this.getJormTypeName());
            ret.append("\n    MustBeConvert        = " + this.isMustBeConvert());
            ret.append("\n    ConvertClassName     = " + this.getConvertClassName());
        }
        return ret.toString();
    }
}

