/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.internal.logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import org.apache.commons.modeler.BaseModelMBean;
import org.ow2.jonas.audit.internal.logger.AuditLogService;
import org.ow2.jonas.audit.internal.logger.NodeReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditLogServiceAdapter
extends BaseModelMBean {
    protected AuditLogService getManagedComponent() {
        try {
            return (AuditLogService)this.getManagedResource();
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalStateException("Cannot get the managed resource of the MBean", e);
        }
        catch (RuntimeOperationsException e) {
            throw new IllegalStateException("Cannot get the managed resource of the MBean", e);
        }
        catch (MBeanException e) {
            throw new IllegalStateException("Cannot get the managed resource of the MBean", e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new IllegalStateException("Cannot get the managed resource of the MBean", e);
        }
    }

    public void postRegister(Boolean registrationDone) {
    }

    public String[] getRootNodesID() {
        ArrayList<String> ids = new ArrayList<String>();
        LinkedList<NodeReport> list = this.getManagedComponent().getNodeReports();
        if (list != null) {
            ListIterator<NodeReport> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                NodeReport node = listIterator.previous();
                if (node.isMissingParent()) continue;
                ids.add(node.getID());
            }
        }
        return ids.toArray(new String[ids.size()]);
    }

    public Map<String, Object> getDescriptionNodeId(String id) {
        HashMap<String, Object> description = new HashMap<String, Object>();
        NodeReport node = this.getManagedComponent().search(id, true);
        if (node == null) {
            return null;
        }
        description.put("date", node.getDate());
        description.put("name", node.getName());
        description.put("application", node.getApplication());
        description.put("desc", node.getDesc());
        description.put("type", node.getType().toString());
        description.put("execTime", node.getExecTime());
        TreeMap<Integer, NodeReport> map = node.getTreeMap();
        Set<Map.Entry<Integer, NodeReport>> entries = map.entrySet();
        ArrayList<String> children = new ArrayList<String>();
        for (Map.Entry<Integer, NodeReport> nodeEntry : entries) {
            children.add(nodeEntry.getValue().getID());
        }
        description.put("children", children.toArray(new String[children.size()]));
        description.put("depth", this.getDepth(node));
        return description;
    }

    protected int getDepth(NodeReport node) {
        int count = 1;
        TreeMap<Integer, NodeReport> map = node.getTreeMap();
        Set<Map.Entry<Integer, NodeReport>> entries = map.entrySet();
        int max = 0;
        for (Map.Entry<Integer, NodeReport> nodeEntry : entries) {
            int tmp = this.getDepth(nodeEntry.getValue());
            if (tmp <= max) continue;
            max = tmp;
        }
        return count += max;
    }
}

