/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORMetadata {
    private Annotation m_annotation;
    private MetadataAccessibleObject m_accessibleObject;
    private String m_xmlElement;

    public ORMetadata(String xmlElement) {
        this.m_xmlElement = xmlElement;
    }

    public ORMetadata(Annotation annotation, MetadataAccessibleObject accessibleObject) {
        this.m_annotation = annotation;
        this.m_accessibleObject = accessibleObject;
    }

    protected MetadataAccessibleObject getAccessibleObject() {
        return this.m_accessibleObject;
    }

    protected Annotation getAnnotation() {
        return this.m_annotation;
    }

    protected XMLEntityMappings getEntityMappings() {
        return this.m_accessibleObject.getEntityMappings();
    }

    protected String getIdentifier() {
        return "";
    }

    protected Object getLocation() {
        return this.m_accessibleObject.getLocation();
    }

    protected String getXMLElement() {
        return this.m_xmlElement;
    }

    protected boolean hasIdentifier() {
        return !this.getIdentifier().equals("");
    }

    protected Class initXMLClassName(String className) {
        return this.m_accessibleObject.getEntityMappings().getClassForName(className);
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        this.m_accessibleObject = accessibleObject;
    }

    protected void initXMLObject(ORMetadata metadata, MetadataAccessibleObject accessibleObject) {
        if (metadata != null) {
            metadata.initXMLObject(accessibleObject);
        }
    }

    protected void initXMLObjects(List metadatas, MetadataAccessibleObject accessibleObject) {
        for (ORMetadata metadata : metadatas) {
            metadata.initXMLObject(accessibleObject);
        }
    }

    protected boolean loadedFromAnnotation() {
        return this.m_annotation != null || this.m_accessibleObject.getLocation() instanceof AnnotatedElement;
    }

    protected boolean loadedFromEclipseLinkXML() {
        if (this.loadedFromXML()) {
            return this.m_accessibleObject.getLocation().toString().contains("META-INF/eclipselink-orm.xml");
        }
        return false;
    }

    protected boolean loadedFromXML() {
        return this.m_xmlElement != null;
    }

    protected void merge(ORMetadata metadata) {
    }

    protected List mergeORObjectLists(List list1, List list2) {
        boolean found;
        ArrayList<ORMetadata> newList = new ArrayList<ORMetadata>();
        for (ORMetadata obj1 : list1) {
            found = false;
            for (ORMetadata obj2 : list2) {
                if (!obj2.getIdentifier().equals(obj1.getIdentifier())) continue;
                if (obj2.shouldOverride(obj1)) {
                    newList.add(obj2);
                } else {
                    newList.add(obj1);
                }
                found = true;
                break;
            }
            if (found) continue;
            newList.add(obj1);
        }
        for (ORMetadata obj2 : list2) {
            found = false;
            for (ORMetadata obj1 : list1) {
                if (!obj2.getIdentifier().equals(obj1.getIdentifier())) continue;
                found = true;
                break;
            }
            if (found) continue;
            newList.add(obj2);
        }
        return newList;
    }

    protected ORMetadata mergeORObjects(ORMetadata obj1, ORMetadata obj2) {
        if (obj2 != null) {
            if (obj1 != null) {
                if (obj2.shouldOverride(obj1)) {
                    return obj2;
                }
            } else {
                return obj2;
            }
        }
        return obj1;
    }

    protected boolean mergePrimitiveBoolean(boolean value1, boolean value2, MetadataAccessibleObject accessibleObject, String xmlElement) {
        Boolean bool2;
        Boolean bool1 = value1 ? new Boolean(true) : null;
        Boolean bl = bool2 = value2 ? new Boolean(true) : null;
        if (bool1 == null && bool2 == null) {
            return false;
        }
        return (Boolean)this.mergeSimpleObjects(bool1, bool2, accessibleObject, xmlElement);
    }

    protected Object mergeSimpleObjects(Object obj1, Object obj2, MetadataAccessibleObject accessibleObject, String xmlElement) {
        if (obj1 == null && obj2 == null) {
            return null;
        }
        SimpleORMetadata object1 = obj1 == null ? null : new SimpleORMetadata(obj1, this.getAccessibleObject(), xmlElement);
        SimpleORMetadata object2 = obj2 == null ? null : new SimpleORMetadata(obj2, accessibleObject, xmlElement);
        return ((SimpleORMetadata)this.mergeORObjects(object1, object2)).getValue();
    }

    protected EntityAccessor reloadEntity(EntityAccessor entity, MetadataDescriptor descriptor) {
        if (this.m_accessibleObject.getEntityMappings() == null) {
            EntityAccessor entityAccessor = new EntityAccessor(entity.getAnnotation(), entity.getJavaClass(), entity.getProject());
            descriptor.setDefaultAccess(entity.getDescriptor().getDefaultAccess());
            entityAccessor.setDescriptor(descriptor);
            return entityAccessor;
        }
        return this.m_accessibleObject.getEntityMappings().reloadEntity(entity, descriptor);
    }

    protected MappedSuperclassAccessor reloadMappedSuperclass(MappedSuperclassAccessor mappedSuperclass, MetadataDescriptor descriptor) {
        if (this.m_accessibleObject.getEntityMappings() == null) {
            MappedSuperclassAccessor mappedSuperclassAccessor = new MappedSuperclassAccessor(mappedSuperclass.getAnnotation(), mappedSuperclass.getJavaClass(), descriptor);
            return mappedSuperclassAccessor;
        }
        return this.m_accessibleObject.getEntityMappings().reloadMappedSuperclass(mappedSuperclass, descriptor);
    }

    public void setAccessibleObject(MetadataAccessibleObject accessibleObject) {
        this.m_accessibleObject = accessibleObject;
    }

    public boolean shouldOverride(ORMetadata existing) {
        MetadataLogger logger = this.getAccessibleObject().getLogger();
        if (existing == null) {
            return true;
        }
        if (!existing.equals(this)) {
            if (this.loadedFromXML() && existing.loadedFromAnnotation()) {
                if (this.hasIdentifier()) {
                    logger.logWarningMessage("metadata_warning_override_named_annotation_with_xml", existing.getAnnotation(), this.getIdentifier(), existing.getLocation(), this.getLocation());
                } else {
                    logger.logWarningMessage("metadata_warning_override_annotation_with_xml", existing.getAnnotation(), existing.getLocation(), this.getLocation());
                }
                return true;
            }
            if (this.loadedFromAnnotation() && existing.loadedFromXML()) {
                if (this.hasIdentifier()) {
                    logger.logWarningMessage("metadata_warning_override_named_annotation_with_xml", this.m_annotation, this.getIdentifier(), this.getLocation(), existing.getLocation());
                } else {
                    logger.logWarningMessage("metadata_warning_override_annotation_with_xml", this.m_annotation, this.getLocation(), existing.getLocation());
                }
            } else {
                if (this.loadedFromEclipseLinkXML() && !existing.loadedFromEclipseLinkXML()) {
                    if (this.hasIdentifier()) {
                        logger.logWarningMessage("metadata_warning_override_named_xml_with_eclipselink_xml", existing.getXMLElement(), this.getIdentifier(), existing.getLocation(), this.getLocation());
                    } else {
                        logger.logWarningMessage("metadata_warning_override_xml_with_eclipselink_xml", existing.getXMLElement(), existing.getLocation(), this.getLocation());
                    }
                    return true;
                }
                if (!this.loadedFromEclipseLinkXML() && existing.loadedFromEclipseLinkXML()) {
                    if (this.hasIdentifier()) {
                        logger.logWarningMessage("metadata_warning_override_named_xml_with_eclipselink_xml", existing.getXMLElement(), this.getIdentifier(), this.getLocation(), existing.getLocation());
                    } else {
                        logger.logWarningMessage("metadata_warning_override_xml_with_eclipselink_xml", existing.getXMLElement(), this.getLocation(), existing.getLocation());
                    }
                } else {
                    if (this.loadedFromAnnotation()) {
                        if (this.hasIdentifier()) {
                            throw ValidationException.conflictingNamedAnnotations(this.getIdentifier(), this.m_annotation, this.getLocation(), existing.getAnnotation(), existing.getLocation());
                        }
                        throw ValidationException.conflictingAnnotations(this.m_annotation, this.getLocation(), existing.getAnnotation(), existing.getLocation());
                    }
                    if (this.hasIdentifier()) {
                        throw ValidationException.conflictingNamedXMLElements(this.getIdentifier(), this.m_xmlElement, this.getLocation(), existing.getLocation());
                    }
                    throw ValidationException.conflictingXMLElements(this.m_xmlElement, this.getAccessibleObject().getElement(), this.getLocation(), existing.getLocation());
                }
            }
        }
        return false;
    }

    protected boolean valuesMatch(List<Object> list1, List<Object> list2) {
        if (list1.size() == list2.size()) {
            for (Object obj1 : list1) {
                if (list2.contains(obj1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean valuesMatch(Object value1, Object value2) {
        if (value1 == null && value2 != null || value2 == null && value1 != null) {
            return false;
        }
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1.equals(value2);
    }

    private class SimpleORMetadata
    extends ORMetadata {
        private Object m_value;

        public SimpleORMetadata(Object value, MetadataAccessibleObject accessibleObject, String xmlElement) {
            super(xmlElement);
            this.setAccessibleObject(accessibleObject);
            this.m_value = value;
        }

        public boolean equals(Object objectToCompare) {
            if (objectToCompare instanceof SimpleORMetadata) {
                return this.valuesMatch(this.getValue(), ((SimpleORMetadata)objectToCompare).getValue());
            }
            return false;
        }

        public Object getValue() {
            return this.m_value;
        }
    }
}

