/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.smartclient.spi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.ow2.easybeans.component.smartclient.client.AskingClassLoader;
import org.ow2.easybeans.component.smartclient.spi.ProDelegate;
import org.ow2.easybeans.component.smartclient.spi.SmartContext;
import org.ow2.easybeans.component.smartclient.spi.SmartContextFactoryInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartContextFactory
implements InitialContextFactory {
    private static Logger logger = Logger.getLogger(SmartContextFactory.class.getName());
    private static final String DEFAULT_URL = "smart://localhost:2503";
    private static final String CAROL_FACTORY = "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory";
    public static final String EASYBEANS_DELEGATING_FACTORY = "easybeans.smart.delegate.factory";
    public static final String EASYBEANS_SMART_JNDI_FACTORY = "easybeans.smart.jndi.factory";
    private static boolean useSmartInfoByClassLoader = false;
    public static final String EASYBEANS_FACTORY = "easybeans.rpc.rmi.factory";
    private static Map<String, SmartContextFactoryInfo> infos = new HashMap<String, SmartContextFactoryInfo>();
    private static Map<ClassLoader, SmartContextFactoryInfo> infosClassLoader = new WeakHashMap<ClassLoader, SmartContextFactoryInfo>();
    private static String defaultProviderURL = null;

    public SmartContextFactory() {
        System.setProperty(EASYBEANS_FACTORY, System.getProperty(EASYBEANS_DELEGATING_FACTORY, this.getClass().getName()));
        System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", ProDelegate.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context getInitialContext(Hashtable environment) throws NamingException {
        SmartContextFactoryInfo info = SmartContextFactory.checkInit(environment);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(info.getClassLoader());
        String oldInitialContextFactory = System.getProperty("java.naming.factory.initial");
        try {
            String jndiFactory = (String)environment.get(EASYBEANS_SMART_JNDI_FACTORY);
            if (jndiFactory == null) {
                jndiFactory = System.getProperty(EASYBEANS_SMART_JNDI_FACTORY);
            }
            if (jndiFactory == null) {
                jndiFactory = CAROL_FACTORY;
            }
            environment.put("java.naming.factory.initial", jndiFactory);
            environment.put("java.naming.provider.url", info.getProviderURL());
            SmartContext smartContext = new SmartContext(new InitialContext(environment), info.getClassLoader());
            return smartContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
            if (oldInitialContextFactory != null) {
                System.setProperty("java.naming.factory.initial", oldInitialContextFactory);
            }
        }
    }

    protected static SmartContextFactoryInfo checkInit(Hashtable<?, ?> environment) throws NamingException {
        String currentProviderURL = (String)environment.get("java.naming.provider.url");
        if (currentProviderURL == null) {
            if (defaultProviderURL == null) {
                logger.log(Level.WARNING, "No PROVIDER_URL setting found, use the default URL 'smart://localhost:2503'.");
                currentProviderURL = DEFAULT_URL;
            } else {
                currentProviderURL = defaultProviderURL;
            }
        }
        SmartContextFactoryInfo info = null;
        info = useSmartInfoByClassLoader ? infosClassLoader.get(Thread.currentThread().getContextClassLoader()) : infos.get(currentProviderURL);
        if (info == null) {
            try {
                info = new SmartContextFactoryInfo();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Initializing Smart Factory with remote URL '" + currentProviderURL + "'.");
                }
                String host = SmartContextFactory.getHostOfUrl(currentProviderURL);
                int portNumber = SmartContextFactory.getPortOfUrl(currentProviderURL);
                AskingClassLoader classLoader = SmartContextFactory.createClassLoader(host, portNumber);
                info.setClassLoader(classLoader);
                ProDelegate.setClassLoader(classLoader);
                String providerURL = classLoader.getProviderURL();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Got remote PROVIDER_URL '" + providerURL + "'.");
                }
                info.setProviderURL(providerURL);
                infos.put(currentProviderURL, info);
                infos.put(providerURL, info);
                if (useSmartInfoByClassLoader) {
                    infosClassLoader.put(Thread.currentThread().getContextClassLoader(), info);
                }
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Cannot get a remote ClassLoader");
                ne.initCause(e);
                throw ne;
            }
        }
        return info;
    }

    private static AskingClassLoader createClassLoader(final String host, final int portNumber) {
        return AccessController.doPrivileged(new PrivilegedAction<AskingClassLoader>(){

            @Override
            public AskingClassLoader run() {
                return new AskingClassLoader(host, portNumber);
            }
        });
    }

    public static int getPortOfUrl(String url) throws NamingException {
        int portNumber = 0;
        try {
            StringTokenizer st = new StringTokenizer(url, ":");
            st.nextToken();
            st.nextToken();
            if (st.hasMoreTokens()) {
                StringTokenizer lastst = new StringTokenizer(st.nextToken(), "/");
                String pts = lastst.nextToken().trim();
                int i = pts.indexOf(44);
                if (i > 0) {
                    pts = pts.substring(0, i);
                }
                portNumber = new Integer(pts);
            }
            return portNumber;
        }
        catch (Exception e) {
            throw new NamingException("Invalid URL '" + url + "'. It should be on the format <protocol>://<hostname>:<port>");
        }
    }

    private static String getHostOfUrl(String url) throws NamingException {
        String host = null;
        try {
            String[] tmpSplitStr = url.split(":");
            String tmpHost = tmpSplitStr[1];
            String[] tmpSplitHost = tmpHost.split("/");
            host = tmpSplitHost[tmpSplitHost.length - 1];
        }
        catch (Exception e) {
            throw new NamingException("Invalid URL '" + url + "'. It should be on the format <protocol>://<hostname>:<port>");
        }
        return host;
    }

    public static void setDefaultProviderUrl(String providerURL) {
        defaultProviderURL = providerURL;
    }

    public static void setUseClassLoader(boolean useOfClassLoader) {
        useSmartInfoByClassLoader = useOfClassLoader;
    }
}

