/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ear.internal.mbean;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.jonas.ear.internal.EARModule;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.management.javaee.J2EEDeployedObjectMBean;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.url.URLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EARModuleMBean
extends J2EEDeployedObjectMBean<EARModule> {
    private String[] modules = null;

    public String getDeploymentDescriptor() {
        String dd = null;
        try {
            dd = ((EARModule)this.getManagedResource()).getDeploymentDescriptor();
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalStateException("Cannot get the managed resource of the EARModuleMBean", e);
        }
        catch (RuntimeOperationsException e) {
            throw new IllegalStateException("Cannot get the managed resource of the EARModuleMBean", e);
        }
        catch (MBeanException e) {
            throw new IllegalStateException("Cannot get the managed resource of the EARModuleMBean", e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new IllegalStateException("Cannot get the managed resource of the EARModuleMBean", e);
        }
        return dd;
    }

    private void initModules() {
        ArrayList<String> modulesList = new ArrayList<String>();
        ObjectName objectName = null;
        try {
            objectName = ObjectName.getInstance(this.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Cannot get ObjectName on '" + this.getObjectName() + "'", e);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Cannot get ObjectName on '" + this.getObjectName() + "'", e);
        }
        String domain = objectName.getDomain();
        String serverName = objectName.getKeyProperty("J2EEServer");
        String appName = objectName.getKeyProperty("name");
        ObjectName modulesOn = null;
        modulesOn = J2eeObjectName.getEJBModules((String)domain, (String)serverName, (String)appName);
        this.addModuleObjectNames(modulesList, modulesOn);
        modulesOn = J2eeObjectName.getWebModules((String)domain, (String)serverName, (String)appName);
        this.addModuleObjectNames(modulesList, modulesOn);
        modulesOn = J2eeObjectName.getResourceAdapterModules((String)domain, (String)serverName, (String)appName);
        this.addModuleObjectNames(modulesList, modulesOn);
        modulesOn = J2eeObjectName.getAppClientModules((String)domain, (String)serverName, (String)appName);
        this.addModuleObjectNames(modulesList, modulesOn);
        this.modules = modulesList.toArray(new String[modulesList.size()]);
    }

    private void addModuleObjectNames(List<String> modulesList, ObjectName objectName) {
        Iterator<ObjectName> itNames = this.getRegistry().getMBeanServer().queryNames(objectName, null).iterator();
        while (itNames.hasNext()) {
            modulesList.add(itNames.next().toString());
        }
    }

    public String getName() {
        return ((EARModule)this.getManagedComponent()).getEARDeployable().getModuleName();
    }

    public URL getEarUrl() {
        try {
            URL earURL = ((EARDeployable)((EARModule)this.getManagedComponent()).getEARDeployable().getOriginalDeployable()).getArchive().getURL();
            if ("file".equals(earURL.getProtocol())) {
                File file = URLUtils.urlToFile((URL)earURL);
                earURL = file.toURL();
            }
            return earURL;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot get URL from deployable '" + ((EARModule)this.getManagedComponent()).getEARDeployable() + "'.", e);
        }
    }

    public String[] getModules() {
        if (this.modules == null) {
            this.initModules();
        }
        return this.modules;
    }

    public String loadClass(String className) throws InvalidTargetObjectTypeException, InstanceNotFoundException, MBeanException {
        Transformer transformer;
        JClassLoader systemClassLoader = null;
        try {
            systemClassLoader = LoaderManager.getInstance().getExternalLoader();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get LoaderManager", e);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Cannot build document builder", e);
        }
        Document document = builder.newDocument();
        Element classElement = document.createElement("class");
        document.appendChild(classElement);
        classElement.setAttribute("name", className);
        boolean classNotFound = false;
        String error = null;
        ClassLoader earClassLoader = ((EARModule)this.getManagedResource()).getClassLoader();
        Class<?> clazz = null;
        try {
            clazz = earClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            error = e.toString();
            classNotFound = true;
        }
        catch (Error e) {
            classNotFound = true;
            error = e.toString();
        }
        classElement.setAttribute("classNotFound", Boolean.toString(classNotFound));
        if (classNotFound) {
            Element errorElement = document.createElement("error");
            classElement.appendChild(errorElement);
            Text errorText = document.createTextNode(error);
            errorElement.appendChild(errorText);
        } else {
            String type = "Application";
            ClassLoader classClassLoader = clazz.getClassLoader();
            boolean found = false;
            for (ClassLoader cl = earClassLoader; cl != null && !found; cl = cl.getParent()) {
                if (cl.equals(classClassLoader)) {
                    found = true;
                }
                if (!systemClassLoader.equals(cl)) continue;
                type = "System";
            }
            classElement.setAttribute("where", type);
            if (classClassLoader != null) {
                Element classLoaderElement = document.createElement("class-loader");
                classElement.appendChild(classLoaderElement);
                classLoaderElement.setAttribute("name", classClassLoader.getClass().getName());
                Text classLoaderText = document.createTextNode(classClassLoader.toString());
                classLoaderElement.appendChild(classLoaderText);
            }
        }
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Unable to get a new transformer", e);
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        try {
            transformer.transform(new DOMSource(document), streamResult);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Unable to transform the document", e);
        }
        return stringWriter.toString();
    }

    public String[] getClassLoaderFilters() throws InvalidTargetObjectTypeException, InstanceNotFoundException, MBeanException {
        List filters = ((EARModule)this.getManagedResource()).getFilteringClassLoader().getFilters();
        return filters.toArray(new String[filters.size()]);
    }

    public URL[] getResources(String resourceName) throws InvalidTargetObjectTypeException, InstanceNotFoundException, MBeanException {
        ClassLoader classLoader = ((EARModule)this.getManagedResource()).getClassLoader();
        Enumeration<URL> urls = null;
        try {
            urls = classLoader.getResources(resourceName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get the resource '" + resourceName + "'.", e);
        }
        ArrayList<URL> urlsList = new ArrayList<URL>();
        while (urls.hasMoreElements()) {
            urlsList.add(urls.nextElement());
        }
        return urlsList.toArray(new URL[urlsList.size()]);
    }
}

