/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.ha;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Daemon;
import fr.dyade.aaa.jndi2.ha.GetRequestIdNot;
import fr.dyade.aaa.jndi2.ha.HARequestContext;
import fr.dyade.aaa.jndi2.msg.IOControl;
import fr.dyade.aaa.jndi2.server.TcpRequestNot;
import fr.dyade.aaa.jndi2.server.Trace;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.objectweb.util.monolog.api.BasicLevel;

public class HATcpServer {
    private volatile ServerSocket listen;
    private Monitor[] monitors;
    private AgentId serverId;

    public HATcpServer(ServerSocket listen, int nbm, AgentId serverId) {
        this.listen = listen;
        this.monitors = new Monitor[nbm];
        this.serverId = serverId;
        for (int i = 0; i < this.monitors.length; ++i) {
            this.monitors[i] = new Monitor("JndiServer.Monitor#" + i, this);
            this.monitors[i].setDaemon(true);
            this.monitors[i].setThreadGroup(AgentServer.getThreadGroup());
        }
    }

    public final void start() {
        for (int i = 0; i < this.monitors.length; ++i) {
            this.monitors[i].start();
        }
    }

    public final void stop() {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)"TcpServer.stop()");
        }
        try {
            this.listen.close();
            this.listen = null;
        }
        catch (Exception exc) {
            // empty catch block
        }
        for (int i = 0; i < this.monitors.length; ++i) {
            this.monitors[i].stop();
        }
    }

    public final ServerSocket getListen() {
        return this.listen;
    }

    public final AgentId getServerId() {
        return this.serverId;
    }

    public static class Monitor
    extends Daemon {
        private HATcpServer tcpServer;

        protected Monitor(String name, HATcpServer tcpServer) {
            super(name);
            this.tcpServer = tcpServer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void run() {
            try {
                block13: while (this.running) {
                    Socket socket;
                    this.canStop = true;
                    try {
                        ServerSocket listen = this.tcpServer.getListen();
                        if (listen == null) return;
                        socket = listen.accept();
                        this.canStop = false;
                    }
                    catch (IOException exc) {
                        if (!this.running) return;
                        Trace.logger.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during accept"), (Throwable)exc);
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            continue;
                        }
                    }
                    if (!this.running) {
                        return;
                    }
                    if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                        Trace.logger.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection from " + socket.getInetAddress() + ':' + socket.getPort()));
                    }
                    try {
                        IOControl ioCtrl = new IOControl(socket);
                        int rid = ioCtrl.readInt();
                        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                            Trace.logger.log(BasicLevel.DEBUG, (Object)(" -> request id = " + rid));
                        }
                        switch (rid) {
                            case -2: {
                                Channel.sendTo((AgentId)this.tcpServer.getServerId(), (Notification)new TcpRequestNot(new HARequestContext(ioCtrl, -2)));
                                continue block13;
                            }
                            case -1: {
                                GetRequestIdNot gri = new GetRequestIdNot();
                                gri.invoke(this.tcpServer.getServerId());
                                int newRid = gri.getId();
                                ioCtrl.writeInt(newRid);
                                Channel.sendTo((AgentId)this.tcpServer.getServerId(), (Notification)new TcpRequestNot(new HARequestContext(ioCtrl, newRid)));
                                continue block13;
                            }
                        }
                        Channel.sendTo((AgentId)this.tcpServer.getServerId(), (Notification)new TcpRequestNot(new HARequestContext(ioCtrl, rid)));
                    }
                    catch (Exception exc) {
                        Trace.logger.log(BasicLevel.ERROR, (Object)(this.getName() + ""), (Throwable)exc);
                    }
                }
                return;
            }
            finally {
                this.finish();
            }
        }

        protected void close() {
        }

        protected void shutdown() {
            this.close();
        }
    }
}

