/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.util;

import java.io.File;
import java.util.ArrayList;
import org.ow2.jonas.Version;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSTools {
    private static final Log logger = LogFactory.getLog(JAXWSTools.class);
    private static final String TOOLS = "tools.jar";

    public static File[] getClasspath() throws Exception {
        String osName = System.getProperty("os.name", "");
        ArrayList<File> jars = new ArrayList<File>();
        JAXWSTools.addWsGenJarsLocation(jars);
        if (osName.indexOf("mac") < 0) {
            JAXWSTools.addToolsJarLocation(jars);
        }
        return jars.toArray(new File[jars.size()]);
    }

    private static void addWsGenJarsLocation(ArrayList<File> jars) {
        String jaxbxjcPath;
        String ow2JAXBPath;
        String javaEEAPIPath;
        String jonasHomePath = System.getProperty("jonas.root");
        String version = Version.getNumber();
        String axis2BundlePath = jonasHomePath + "/repositories/maven2-internal/org/ow2/jonas/jonas-webservices-axis2/" + version + "/jonas-webservices-axis2-" + version + "-ipojo.jar";
        if (new File(axis2BundlePath).exists()) {
            jars.add(new File(axis2BundlePath));
        }
        if (new File(javaEEAPIPath = jonasHomePath + "/repositories/maven2-internal/org/ow2/jonas/osgi/javaee-api/" + version + "/javaee-api-" + version + ".jar").exists()) {
            jars.add(new File(javaEEAPIPath));
        }
        File ow2JAXBDir = new File(jonasHomePath + "/repositories/maven2-internal/org/ow2/bundles/ow2-bundles-externals-jaxb2");
        File jaxbDir = ow2JAXBDir.listFiles()[0];
        String ow2JAXBVersion = null;
        if (jaxbDir.exists()) {
            ow2JAXBVersion = jaxbDir.getName();
        }
        if (new File(ow2JAXBPath = jonasHomePath + "/repositories/maven2-internal/org/ow2/bundles/ow2-bundles-externals-jaxb2/" + ow2JAXBVersion + "/ow2-bundles-externals-jaxb2-" + ow2JAXBVersion + ".jar").exists()) {
            jars.add(new File(ow2JAXBPath));
        }
        if (new File(jaxbxjcPath = jonasHomePath + "/lib/jaxb-xjc.jar").exists()) {
            jars.add(new File(jaxbxjcPath));
        }
    }

    private static void addToolsJarLocation(ArrayList<File> jars) {
        File jdkhomelib;
        String jreHomePath = System.getProperty("java.home");
        String javaHomePath = "";
        int jreHomePathLength = jreHomePath.length();
        if (jreHomePathLength > 0) {
            int i = jreHomePath.substring(0, jreHomePathLength - 1).lastIndexOf(File.separator);
            javaHomePath = jreHomePath.substring(0, i);
        }
        if (!(jdkhomelib = new File(javaHomePath, "lib")).exists()) {
            logger.warn((Object)("Missing " + jdkhomelib.getAbsolutePath() + ". This may be required for wsgen to run. "), new Object[0]);
        } else {
            File tools = new File(jdkhomelib, TOOLS);
            if (!tools.exists()) {
                logger.warn((Object)("Missing tools.jar in" + jdkhomelib.getAbsolutePath() + ". This may be required for wsgen to run. "), new Object[0]);
            } else {
                jars.add(tools.getAbsoluteFile());
            }
        }
    }
}

