/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.admin;

import fr.dyade.aaa.common.stream.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.objectweb.joram.shared.admin.AdminReply;

public class GetStatsReply
extends AdminReply {
    private static final long serialVersionUID = 1L;
    private Hashtable stats;

    public GetStatsReply(Hashtable stats) {
        super(true, null);
        this.stats = stats;
    }

    public Hashtable getStats() {
        return this.stats;
    }

    public GetStatsReply() {
    }

    protected int getClassId() {
        return 56;
    }

    public void readFrom(InputStream is) throws IOException {
        super.readFrom(is);
        int size = StreamUtil.readIntFrom((InputStream)is);
        if (size == -1) {
            this.stats = null;
        } else {
            this.stats = new Hashtable(size * 4 / 3);
            for (int i = 0; i < size; ++i) {
                String key = StreamUtil.readStringFrom((InputStream)is);
                Object value = StreamUtil.readObjectFrom((InputStream)is);
                this.stats.put(key, value);
            }
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        super.writeTo(os);
        if (this.stats == null) {
            StreamUtil.writeTo((int)-1, (OutputStream)os);
        } else {
            int size = this.stats.size();
            StreamUtil.writeTo((int)size, (OutputStream)os);
            Enumeration keys = this.stats.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                StreamUtil.writeTo((String)key, (OutputStream)os);
                StreamUtil.writeObjectTo(this.stats.get(key), (OutputStream)os);
            }
        }
    }
}

