/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import java.net.ConnectException;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClusterAdd;
import org.objectweb.joram.shared.admin.ClusterLeave;
import org.objectweb.joram.shared.admin.ClusterList;
import org.objectweb.joram.shared.admin.SetFather;

public class AdminHelper {
    public static void setClusterLink(Topic clusterTopic, Topic joiningTopic) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new ClusterAdd(clusterTopic.getName(), joiningTopic.getName()));
    }

    public static void unsetClusterLink(Topic topic) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new ClusterLeave(topic.getName()));
    }

    public static void setHierarchicalLink(Topic father, Topic son) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new SetFather(father.getName(), son.getName()));
    }

    public static void unsetHierarchicalLink(Topic topic) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new SetFather(null, topic.getName()));
    }

    public static void setQueueCluster(Queue clusterQueue, Queue joiningQueue) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new ClusterAdd(clusterQueue.getName(), joiningQueue.getName()));
    }

    public static void setQueueCluster(Destination clusterQueue, Queue joiningQueue) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new ClusterAdd(clusterQueue.getName(), joiningQueue.getName()));
    }

    public static void leaveQueueCluster(Queue clusterQueue, Queue leaveQueue) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new ClusterLeave(leaveQueue.getName()));
    }

    public static AdminReply listQueueCluster(Queue clusterQueue) throws ConnectException, AdminException {
        return AdminModule.doRequest((AdminRequest)new ClusterList(clusterQueue.getName()));
    }
}

