/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizerImpl;

public class StandardTokenizer
extends Tokenizer {
    private final StandardTokenizerImpl scanner;
    public static final int ALPHANUM = 0;
    public static final int APOSTROPHE = 1;
    public static final int ACRONYM = 2;
    public static final int COMPANY = 3;
    public static final int EMAIL = 4;
    public static final int HOST = 5;
    public static final int NUM = 6;
    public static final int CJ = 7;
    public static final int ACRONYM_DEP = 8;
    public static final String[] TOKEN_TYPES = new String[]{"<ALPHANUM>", "<APOSTROPHE>", "<ACRONYM>", "<COMPANY>", "<EMAIL>", "<HOST>", "<NUM>", "<CJ>", "<ACRONYM_DEP>"};
    public static final String[] tokenImage = TOKEN_TYPES;
    private boolean replaceInvalidAcronym = false;
    private int maxTokenLength = 255;

    void setInput(Reader reader) {
        this.input = reader;
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public StandardTokenizer(Reader input) {
        this.input = input;
        this.scanner = new StandardTokenizerImpl(input);
    }

    public StandardTokenizer(Reader input, boolean replaceInvalidAcronym) {
        this.replaceInvalidAcronym = replaceInvalidAcronym;
        this.input = input;
        this.scanner = new StandardTokenizerImpl(input);
    }

    public Token next(Token result) throws IOException {
        int posIncr = 1;
        int tokenType;
        while ((tokenType = this.scanner.getNextToken()) != -1) {
            if (this.scanner.yylength() <= this.maxTokenLength) {
                result.clear();
                result.setPositionIncrement(posIncr);
                this.scanner.getText(result);
                int start = this.scanner.yychar();
                result.setStartOffset(start);
                result.setEndOffset(start + result.termLength());
                if (tokenType == 8) {
                    if (this.replaceInvalidAcronym) {
                        result.setType(StandardTokenizerImpl.TOKEN_TYPES[5]);
                        result.setTermLength(result.termLength() - 1);
                    } else {
                        result.setType(StandardTokenizerImpl.TOKEN_TYPES[2]);
                    }
                } else {
                    result.setType(StandardTokenizerImpl.TOKEN_TYPES[tokenType]);
                }
                return result;
            }
            ++posIncr;
        }
        return null;
    }

    public void reset() throws IOException {
        super.reset();
        this.scanner.yyreset(this.input);
    }

    public void reset(Reader reader) throws IOException {
        this.input = reader;
        this.reset();
    }

    public boolean isReplaceInvalidAcronym() {
        return this.replaceInvalidAcronym;
    }

    public void setReplaceInvalidAcronym(boolean replaceInvalidAcronym) {
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }
}

