/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.jrmp.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.ObjID;
import org.ow2.carol.rmi.interceptor.spi.JClientRequestInterceptor;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JClientInterceptorHelper;
import org.ow2.carol.util.configuration.TraceCarol;
import sun.rmi.transport.Connection;
import sun.rmi.transport.StreamRemoteCall;

public class JRemoteCall
extends StreamRemoteCall {
    protected JClientRequestInterceptor[] cis = null;
    private static final boolean CAROL_JRMP_REMOTE_CALL_SKIP_DEFAULT_RESOLVE_CLASS = Boolean.getBoolean("carol.jrmp.remote.call.skip.default.resolve.class");
    private boolean shouldConfigureInputStream = true;

    public JRemoteCall(Connection c, ObjID id, int op, long hash, JClientRequestInterceptor[] cis) throws RemoteException {
        super(c, id, op, hash);
        this.cis = cis;
    }

    public void executeCall() throws Exception {
        try {
            super.executeCall();
        }
        catch (Exception e) {
            if (e.getMessage().equals("dummy")) {
                Object ex;
                ObjectInput in = this.getInputStream();
                JClientInterceptorHelper.receive_exception(in, this.cis);
                try {
                    ex = in.readObject();
                }
                catch (Exception exc) {
                    throw new UnmarshalException("Error unmarshaling return", exc);
                }
                if (ex instanceof Exception) {
                    this.exceptionReceivedFromServer((Exception)ex);
                }
                throw new UnmarshalException("Return type not Exception");
            }
            throw e;
        }
        ObjectInput in = this.getInputStream();
        JClientInterceptorHelper.receive_reply(in, this.cis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInput getInputStream() throws IOException {
        if (this.shouldConfigureInputStream && CAROL_JRMP_REMOTE_CALL_SKIP_DEFAULT_RESOLVE_CLASS) {
            ObjectInput objectInput = super.getInputStream();
            try {
                Method resolveMethod = objectInput.getClass().getMethod("skipDefaultResolveClass", new Class[0]);
                boolean methodAccess = resolveMethod.isAccessible();
                try {
                    resolveMethod.setAccessible(true);
                    resolveMethod.invoke((Object)objectInput, new Object[0]);
                }
                finally {
                    resolveMethod.setAccessible(methodAccess);
                }
            }
            catch (NoSuchMethodException e) {
                TraceCarol.error("Unable to call skipDefaultResolveClass method on JRMP MarshalInputStream or MarshalOutputStream. Performance tweak for OSGi environments will not be available.", e);
            }
            catch (InvocationTargetException e) {
                TraceCarol.error("Unable to call skipDefaultResolveClass method on JRMP MarshalInputStream or MarshalOutputStream. Performance tweak for OSGi environments will not be available.", e);
            }
            catch (IllegalAccessException e) {
                TraceCarol.error("Unable to call skipDefaultResolveClass method on JRMP MarshalInputStream or MarshalOutputStream. Performance tweak for OSGi environments will not be available.", e);
            }
            this.shouldConfigureInputStream = false;
            return objectInput;
        }
        return super.getInputStream();
    }

    public void releaseInputStream() throws IOException {
        this.shouldConfigureInputStream = true;
        super.releaseInputStream();
    }
}

